/*
 * Decompiled with CFR 0.152.
 */
package org.spantus.mpeg7.extractors.impl;

import java.util.List;
import org.spantus.core.FrameValues;
import org.spantus.core.FrameVectorValues;
import org.spantus.core.extractor.IExtractorConfig;
import org.spantus.mpeg7.extractors.AbstractMpeg7Extractor;

public class AudioPowerExtractor
extends AbstractMpeg7Extractor {
    public static final String EXTRACTOR_NAME = "AudioPower";
    public static final double LOG10 = Math.log(10.0);
    private boolean logScale;

    public FrameVectorValues calculateWindow(FrameValues window) {
        FrameVectorValues calculatedValues = this.createFrameValueVector();
        double power = 0.0;
        for (Float val : window) {
            power += Math.pow(val.floatValue(), 2.0);
        }
        power /= (double)window.size();
        if (this.getLogScale()) {
            power = 10.0f / (float)LOG10 * (float)Math.log(power + (double)1.4E-45f);
        }
        FrameValues fv = new FrameValues();
        fv.add((Object)new Float(power));
        calculatedValues.add((List)fv);
        return calculatedValues;
    }

    public String getName() {
        return EXTRACTOR_NAME;
    }

    public boolean getLogScale() {
        return this.logScale;
    }

    public void setLogScale(boolean logScale) {
        this.logScale = logScale;
    }

    public IExtractorConfig getConfig() {
        return null;
    }

    public float getExtractorSampleRate() {
        return 0.0f;
    }

    public void setConfig(IExtractorConfig config) {
    }
}

