/*
 * Decompiled with CFR 0.152.
 */
package it.univpm.deit.audio;

import de.crysandt.audio.mpeg7audio.msgs.Msg;
import de.crysandt.audio.mpeg7audio.msgs.MsgAudioSpectrum;
import de.crysandt.audio.mpeg7audio.msgs.MsgEndOfSignal;
import de.crysandt.audio.mpeg7audio.msgs.MsgListener;
import de.crysandt.audio.mpeg7audio.msgs.MsgSpeaker;
import de.crysandt.audio.mpeg7audio.msgs.MsgSpectralCentroid;

public class SpectralCentroid
extends MsgSpeaker
implements MsgListener {
    private float samplerate;
    private float[] sumArray;
    private boolean isFirst = true;
    private int count = 0;

    public SpectralCentroid(float samplerate) {
        this.samplerate = samplerate;
    }

    public void receivedMsg(Msg m) {
        if (m instanceof MsgAudioSpectrum) {
            this.receivedMsg((MsgAudioSpectrum)m);
        }
        if (m instanceof MsgEndOfSignal) {
            this.receivedMsg((MsgEndOfSignal)m);
        }
    }

    public void receivedMsg(MsgAudioSpectrum m) {
        float[] spectrum = m.getAudioSpectrum();
        if (this.isFirst) {
            this.sumArray = new float[spectrum.length];
            this.isFirst = false;
        }
        for (int i = 0; i < spectrum.length; ++i) {
            int n = i;
            this.sumArray[n] = this.sumArray[n] + spectrum[i];
        }
        ++this.count;
    }

    public void receivedMsg(MsgEndOfSignal meos) {
        int i = 0;
        while (i < this.sumArray.length) {
            int n = i++;
            this.sumArray[n] = this.sumArray[n] / (float)this.count;
        }
        float dF = this.samplerate / 2.0f / (float)this.sumArray.length;
        float num = 0.0f;
        float den = 0.0f;
        for (int i2 = 0; i2 < this.sumArray.length; ++i2) {
            num += dF * (float)i2 * this.sumArray[i2];
            den += this.sumArray[i2];
        }
        float spectralCentroid = num / den;
        this.send(new MsgSpectralCentroid(meos.time, meos.duration, spectralCentroid));
        this.send(meos);
    }
}

