/*
 * Decompiled with CFR 0.152.
 */
package it.univpm.deit.audio;

import de.crysandt.audio.mpeg7audio.msgs.Msg;
import de.crysandt.audio.mpeg7audio.msgs.MsgAudioSpectrum;
import de.crysandt.audio.mpeg7audio.msgs.MsgListener;
import de.crysandt.audio.mpeg7audio.msgs.MsgResizer;
import de.crysandt.audio.mpeg7audio.msgs.MsgSilence;
import de.crysandt.audio.mpeg7audio.msgs.MsgSpeaker;
import java.util.LinkedList;

public class Silence
extends MsgSpeaker
implements MsgListener {
    private float power = 0.0f;
    private float ZCR = 0.0f;
    private int start_time = 0;
    private int sil_dur = 0;
    private boolean first = false;
    private boolean start_sil = false;
    private boolean end_sil = false;
    private LinkedList<MsgResizer> msglist = new LinkedList();
    private int min_dur = 0;
    private float[] buffer = new float[]{0.0f, 0.0f, 0.0f};
    private float tot_conf = 0.0f;
    private float confidence = 0.0f;
    private int levelofref = 0;

    public Silence(int min_dur, int levelofref) {
        this.min_dur = min_dur;
        this.levelofref = levelofref;
    }

    public void receivedMsg(Msg msg) {
        if (msg instanceof MsgAudioSpectrum) {
            this.receivedMsg((MsgAudioSpectrum)msg);
        } else if (msg instanceof MsgResizer) {
            this.receivedMsg((MsgResizer)msg);
        }
    }

    public void receivedMsg(MsgAudioSpectrum mas) {
        float[] spectrum = mas.getAudioSpectrum();
        this.power = 0.0f;
        for (int j = 0; j < spectrum.length; ++j) {
            this.power += spectrum[j];
        }
    }

    public void flush() {
        this.end_sil = true;
        this.endOfSilence(this.msglist.getLast());
        super.flush();
    }

    private void endOfSilence(Msg mes) {
        if (this.start_sil && this.end_sil) {
            this.sil_dur = mes.duration + mes.time - this.start_time;
            if (this.sil_dur > this.min_dur) {
                this.send(new MsgSilence(this.start_time, this.sil_dur, this.min_dur, this.tot_conf * (float)mes.hopsize / (float)this.sil_dur));
            }
            this.start_sil = false;
            this.end_sil = false;
            this.start_time = 0;
            this.tot_conf = 0.0f;
            this.first = true;
        }
    }

    public void receivedMsg(MsgResizer msg) {
        this.msglist.addLast(msg);
        if (this.msglist.size() == 3) {
            int j;
            MsgResizer mes = this.msglist.getFirst();
            float[] x = mes.getSignal();
            float n = 0.0f;
            int temoin = 1;
            for (j = 2; j < x.length; ++j) {
                if (this.sign(x[j]) == this.sign(x[j - temoin]) || this.sign(x[j]) == 0) {
                    ++temoin;
                    continue;
                }
                n += (float)temoin;
                temoin = 1;
            }
            this.ZCR = n / (float)x.length;
            for (j = 2; j > 0; --j) {
                this.buffer[j] = this.buffer[j - 1];
            }
            this.buffer[0] = this.ZCR * this.power;
            if (this.first && this.ZCR * this.power < (float)this.levelofref) {
                this.start_time = mes.time;
            }
            float num_el = 0.0f;
            for (int j2 = 0; j2 < 3; ++j2) {
                num_el += this.buffer[j2];
            }
            if ((num_el /= 3.0f) < (float)this.levelofref) {
                this.confidence = 1.0f - num_el / (float)this.levelofref;
                this.tot_conf += this.confidence;
                this.first = false;
                this.start_sil = true;
                this.end_sil = false;
            } else {
                this.end_sil = true;
                this.first = true;
            }
            this.endOfSilence(mes);
            this.msglist.removeFirst();
        }
    }

    int sign(float x) {
        if (x > 0.0f) {
            return 1;
        }
        if (x < 0.0f) {
            return -1;
        }
        return 0;
    }
}

