/*
 * Decompiled with CFR 0.152.
 */
package it.univpm.deit.audio;

import de.crysandt.audio.mpeg7audio.msgs.Msg;
import de.crysandt.audio.mpeg7audio.msgs.MsgAudioFundamentalFrequency;
import de.crysandt.audio.mpeg7audio.msgs.MsgAudioSpectrum;
import de.crysandt.audio.mpeg7audio.msgs.MsgHarmonicPeaks;
import de.crysandt.audio.mpeg7audio.msgs.MsgListener;
import de.crysandt.audio.mpeg7audio.msgs.MsgSpeaker;
import java.util.ArrayList;

public class HarmonicPeaks
extends MsgSpeaker
implements MsgListener {
    private float nonHarmonicity;
    private float thresold;
    private ArrayList<float[]> peaks = new ArrayList();
    private float[] signalSpectrum;
    private int spectrumLength;
    private float dF;

    public HarmonicPeaks(float nonHarmonicity, float thresold) {
        this.nonHarmonicity = nonHarmonicity;
        this.thresold = thresold;
    }

    public void receivedMsg(Msg msg) {
        if (msg instanceof MsgAudioSpectrum) {
            MsgAudioSpectrum mas = (MsgAudioSpectrum)msg;
            this.signalSpectrum = mas.getAudioSpectrum();
            this.spectrumLength = mas.getAudioSpectrumLength();
            this.dF = mas.deltaF;
        }
        if (msg instanceof MsgAudioFundamentalFrequency) {
            MsgAudioFundamentalFrequency maff = (MsgAudioFundamentalFrequency)msg;
            float fundamental = maff.fundfreq;
            if (fundamental == 0.0f) {
                return;
            }
            int mafftime = maff.time;
            int maffduration = maff.duration;
            ArrayList<Integer> a = new ArrayList<Integer>();
            ArrayList<Integer> b = new ArrayList<Integer>();
            int h = 1;
            while (Math.floor(fundamental * (float)h / this.dF) < (double)this.spectrumLength) {
                int sx = (int)Math.floor(((float)h - this.nonHarmonicity) * (fundamental / this.dF));
                int dx = (int)Math.ceil(((float)h + this.nonHarmonicity) * (fundamental / this.dF));
                if (dx < this.spectrumLength) {
                    a.add(new Integer(sx));
                    b.add(new Integer(dx));
                }
                ++h;
            }
            for (int j = 0; j < a.size(); ++j) {
                int index = (Integer)a.get(j) - 1;
                float maxAmp = this.signalSpectrum[index];
                for (int k = index + 1; k < (Integer)b.get(j); ++k) {
                    if (!(this.signalSpectrum[k] > maxAmp)) continue;
                    maxAmp = this.signalSpectrum[k];
                    index = k;
                }
                float[] peakData = new float[]{this.dF * (float)index, this.signalSpectrum[index]};
                this.peaks.add(peakData);
            }
            float[] pd = this.peaks.get(0);
            float maxPeak = pd[1];
            for (int z = 1; z < this.peaks.size(); ++z) {
                pd = this.peaks.get(z);
                if (!(pd[1] >= maxPeak)) continue;
                maxPeak = pd[1];
            }
            int h2 = 0;
            while (h2 < this.peaks.size()) {
                pd = this.peaks.get(h2);
                if (pd[1] < this.thresold * maxPeak) {
                    this.peaks.remove(h2);
                    continue;
                }
                ++h2;
            }
            this.peaks.trimToSize();
            this.send(new MsgHarmonicPeaks(mafftime, maffduration, this.peaks));
            this.peaks.clear();
        }
    }
}

