/*
 * Decompiled with CFR 0.152.
 */
package de.crysandt.util;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class FileFilterExtension
extends FileFilter {
    public static final String[] AUDIO = new String[]{"wav", "au", "aiff", "mp3"};
    public static final String[] MP7 = new String[]{"mp7", "xml"};
    private final String[] extension;

    public FileFilterExtension(String[] extension) {
        this.extension = extension;
    }

    public String getDescription() {
        StringBuffer buffer = new StringBuffer("*." + this.extension[0]);
        for (int i = 1; i < this.extension.length; ++i) {
            buffer.append(", *." + this.extension[i]);
        }
        return buffer.toString();
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String ext = this.getExtension(file);
        if (ext != null) {
            for (int i = 0; i < this.extension.length; ++i) {
                if (!ext.equals(this.extension[i])) continue;
                return true;
            }
        }
        return false;
    }

    String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }
}

