/*
 * Decompiled with CFR 0.152.
 */
package de.crysandt.math;

import de.crysandt.math.Function;
import de.crysandt.math.LUDecomposition;

public final class LinAlg {
    public static double det(float[][] matrix) {
        return LinAlg.det(LinAlg.toDouble(matrix));
    }

    public static double det(double[][] matrix) {
        LUDecomposition lud = new LUDecomposition(matrix);
        return lud.det();
    }

    public static float[][] inv(float[][] matrix) throws IllegalArgumentException {
        int rows = matrix.length;
        double[][] matrix_double = new double[rows][];
        for (int r = 0; r < rows; ++r) {
            matrix_double[r] = LinAlg.toDouble(matrix[r]);
        }
        double[][] matrix_double_inv = LinAlg.inv(matrix_double);
        float[][] matrix_inv = new float[rows][];
        for (int r = 0; r < rows; ++r) {
            matrix_inv[r] = LinAlg.toFloat(matrix_double_inv[r]);
        }
        return matrix_inv;
    }

    public static double[][] inv(double[][] matrix) throws IllegalArgumentException {
        int rows = matrix.length;
        double[][] matrix_copy = new double[rows][rows];
        for (int r = 0; r < rows; ++r) {
            System.arraycopy(matrix[r], 0, matrix_copy[r], 0, rows);
        }
        double[][] matrix_inv = new double[rows][rows];
        for (int n = 0; n < rows; ++n) {
            matrix_inv[n][n] = 1.0;
        }
        LinAlg.inv(rows, matrix_copy, matrix_inv);
        return matrix_inv;
    }

    public static double[] toDouble(float[] vector) {
        double[] tmp = new double[vector.length];
        for (int i = 0; i < vector.length; ++i) {
            tmp[i] = vector[i];
        }
        return tmp;
    }

    public static double[][] toDouble(float[][] matrix) {
        double[][] tmp = new double[matrix.length][];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = LinAlg.toDouble(matrix[i]);
        }
        return tmp;
    }

    public static float[] toFloat(double[] vector) {
        float[] tmp = new float[vector.length];
        for (int i = 0; i < vector.length; ++i) {
            tmp[i] = (float)vector[i];
        }
        return tmp;
    }

    public static float[][] toFloat(double[][] matrix) {
        float[][] tmp = new float[matrix.length][];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = LinAlg.toFloat(matrix[i]);
        }
        return tmp;
    }

    public static void inv(int rows, double[][] matrix, double[][] matrix_inv) throws IllegalArgumentException {
        for (int c = 0; c < rows - 1; ++c) {
            double max = Math.abs(matrix[c][c]);
            int max_index = c;
            for (int r = c + 1; r < rows; ++r) {
                assert (matrix[r].length == rows);
                if (!(Math.abs(matrix[r][c]) > max)) continue;
                max_index = r;
                max = Math.abs(matrix[r][c]);
            }
            if (max == 0.0) {
                throw new IllegalArgumentException("Matrix is singular");
            }
            if (max_index != c) {
                double[] swap = matrix[c];
                matrix[c] = matrix[max_index];
                matrix[max_index] = swap;
                swap = matrix_inv[c];
                matrix_inv[c] = matrix_inv[max_index];
                matrix_inv[max_index] = swap;
            }
            double scal = 1.0 / matrix[c][c];
            LinAlg.mul(matrix[c], c, scal);
            LinAlg.mul(matrix_inv[c], 0, scal);
            for (int i = c + 1; i < rows; ++i) {
                double factor = matrix[i][c];
                LinAlg.mulsub(matrix_inv[i], matrix_inv[c], 0, factor);
                LinAlg.mulsub(matrix[i], matrix[c], c, factor);
            }
        }
        if (matrix[rows - 1][rows - 1] == 0.0) {
            throw new IllegalArgumentException("Matrix is singular");
        }
        LinAlg.mul(matrix_inv[rows - 1], 0, 1.0 / matrix[rows - 1][rows - 1]);
        matrix[rows - 1][rows - 1] = 1.0;
        for (int r = rows - 2; r >= 0; --r) {
            for (int index = r + 1; index < rows; ++index) {
                LinAlg.mulsub(matrix_inv[r], matrix_inv[index], 0, matrix[r][index]);
                LinAlg.mulsub(matrix[r], matrix[index], r, matrix[r][index]);
            }
        }
    }

    private static void mul(double[] x, int index, double alpha) {
        while (index < x.length) {
            int n = index++;
            x[n] = x[n] * alpha;
        }
    }

    private static void mulsub(double[] x, double[] y, int index, double alpha) {
        while (index < x.length) {
            int n = index;
            x[n] = x[n] - alpha * y[index];
            ++index;
        }
    }

    public static float[][] cov(float[][] matrix) {
        int rows = matrix.length;
        int cols = matrix[0].length;
        assert (rows >= cols);
        float[] mean = Function.mean_arith(matrix);
        double[][] sum = new double[cols][cols];
        float[] diff = new float[cols];
        for (int r = 0; r < rows; ++r) {
            int i;
            float[] row = matrix[r];
            for (i = 0; i < cols; ++i) {
                diff[i] = row[i] - mean[i];
            }
            for (i = 0; i < cols; ++i) {
                double[] cov_sum_i = sum[i];
                float diff_i = diff[i];
                for (int j = i; j < cols; ++j) {
                    int n = j;
                    cov_sum_i[n] = cov_sum_i[n] + (double)(diff_i * (row[j] - mean[j]));
                }
            }
        }
        float[][] cov = new float[cols][cols];
        for (int i = 0; i < cols; ++i) {
            cov[i][i] = (float)sum[i][i] / (float)rows;
            for (int j = i + 1; j < cols; ++j) {
                float f = (float)sum[i][j] / (float)rows;
                cov[i][j] = f;
                cov[j][i] = f;
            }
        }
        return cov;
    }

    public static float[][] transpose(float[][] matrix) {
        float[][] transposed = new float[matrix[0].length][matrix.length];
        for (float[] row : matrix) {
            for (float transposed[j][i] : row) {
            }
        }
        return transposed;
    }

    public static float dot(float[] a, float[] b) {
        assert (a.length == b.length);
        double sum = 0.0;
        int i = a.length;
        while (i > 0) {
            sum += (double)(a[--i] * b[i]);
        }
        return (float)sum;
    }

    public static double dot(double[] a, double[] b) {
        assert (a.length == b.length);
        double sum = 0.0;
        int i = a.length;
        while (i > 0) {
            sum += a[--i] * b[i];
        }
        return sum;
    }

    public static float[][] mult(float[][] M1, float[][] M2) {
        M2 = LinAlg.transpose(M2);
        float[][] prod = new float[M1.length][M2.length];
        for (int i = 0; i < prod.length; ++i) {
            float[] row = prod[i];
            float[] M1i = M1[i];
            for (int j = 0; j < row.length; ++j) {
                assert (M1i.length == M2[j].length);
                row[j] = LinAlg.dot(M1i, M2[j]);
            }
        }
        return prod;
    }
}

