/*
 * Decompiled with CFR 0.152.
 */
package de.crysandt.hmm;

import java.util.Arrays;

class Alpha {
    private final double[][] alpha;
    private final double[] alpha_scal;

    Alpha(double[][] dist_prob, float[] init, float[][] trans) {
        int i;
        int T = dist_prob.length;
        int N = dist_prob[0].length;
        this.alpha = new double[T][N];
        this.alpha_scal = new double[T];
        Arrays.fill(this.alpha_scal, 0.0);
        double[] alpha_0 = this.alpha[0];
        for (i = 0; i < N; ++i) {
            alpha_0[i] = dist_prob[0][i];
        }
        if (init != null) {
            for (i = 0; i < N; ++i) {
                int n = i;
                alpha_0[n] = alpha_0[n] * (double)init[i];
            }
        }
        for (i = 0; i < N; ++i) {
            alpha_0[i] = Math.max((double)1.435E-42f, alpha_0[i]);
            this.alpha_scal[0] = this.alpha_scal[0] + alpha_0[i];
        }
        i = 0;
        while (i < N) {
            int n = i++;
            alpha_0[n] = alpha_0[n] / this.alpha_scal[0];
        }
        for (int t = 1; t < T; ++t) {
            int j;
            double[] alpha_t = this.alpha[t];
            double[] alpha_t1 = this.alpha[t - 1];
            double[] dist_prob_t = dist_prob[t];
            double alpha_scal_t = 0.0;
            for (j = 0; j < N; ++j) {
                double sum = 0.0;
                for (int i2 = 0; i2 < N; ++i2) {
                    sum += alpha_t1[i2] * (double)trans[i2][j];
                }
                alpha_t[j] = Math.max((double)1.435E-42f, sum * dist_prob_t[j]);
                alpha_scal_t += alpha_t[j];
                assert (!Double.isNaN(alpha_t[j]));
            }
            j = 0;
            while (j < N) {
                int n = j++;
                this.alpha_scal[t] = alpha_scal_t;
                alpha_t[n] = alpha_t[n] / this.alpha_scal[t];
            }
        }
        assert (Alpha.testAlpha(this.alpha, this.alpha_scal));
    }

    private static boolean testAlpha(double[][] alpha, double[] alpha_scal) {
        int t_max = alpha.length;
        for (int t = 0; t < t_max; ++t) {
            assert (!Double.isNaN(alpha_scal[t]));
            assert (!Double.isInfinite(alpha_scal[t]));
            assert (alpha_scal[t] >= (double)1.4E-45f);
            double[] alpha_t = alpha[t];
            int i_max = alpha_t.length;
            for (int i = 0; i < i_max; ++i) {
                assert (!Double.isNaN(alpha_t[i]));
                assert (!Double.isInfinite(alpha_t[i]));
            }
        }
        return true;
    }

    public double[][] getAlpha() {
        return this.alpha;
    }

    public double[] getAlphaScal() {
        return this.alpha_scal;
    }
}

