/*
 * Decompiled with CFR 0.152.
 */
package de.crysandt.audio.mpeg7audio.mci;

import de.crysandt.audio.mpeg7audio.mci.DescriptorI;
import java.awt.Rectangle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MediaTranscodingHints
implements DescriptorI {
    private Rectangle motion_hint_range = null;
    private Float motion_hint_uncompensability = null;
    private Float motion_hint_intensity = null;
    private Float shape_hint_shape_change = null;
    private Float shape_hint_num_of_non_transp_blocks = null;
    private Float coding_hint_avg_quant_scale = null;
    private Integer coding_hint_intra_frame_distance = null;
    private Integer coding_hint_anchor_frame_distance = null;
    private Float difficulty = null;
    private Float importance = null;
    private Float spatial_resolution_hint = null;

    public Element toXML(Document doc, String name) {
        Element hints_ele = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", name);
        hints_ele.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "MediaTranscodingHintsType");
        if (this.motion_hint_range != null || this.motion_hint_uncompensability != null || this.motion_hint_intensity != null) {
            Element motion_hint_ele = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "MotionHint");
            hints_ele.appendChild(motion_hint_ele);
            if (this.motion_hint_range != null) {
                Element motion_hint_range_ele = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "MotionRange");
                motion_hint_ele.appendChild(motion_hint_range_ele);
                motion_hint_range_ele.setAttribute("xLeft", Integer.toString(this.motion_hint_range.x));
                motion_hint_range_ele.setAttribute("xRight", Integer.toString(this.motion_hint_range.x + this.motion_hint_range.width));
                motion_hint_range_ele.setAttribute("yDown", Integer.toString(this.motion_hint_range.y));
                motion_hint_range_ele.setAttribute("yUp", Integer.toString(this.motion_hint_range.y + this.motion_hint_range.height));
            }
            if (this.motion_hint_uncompensability != null) {
                motion_hint_ele.setAttribute("uncompensability", this.motion_hint_uncompensability.toString());
            }
            if (this.motion_hint_intensity != null) {
                motion_hint_ele.setAttribute("intensity", this.motion_hint_intensity.toString());
            }
        }
        if (this.shape_hint_shape_change != null || this.shape_hint_num_of_non_transp_blocks != null) {
            Element shape_hint_ele = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "ShapeHint");
            hints_ele.appendChild(shape_hint_ele);
            if (this.shape_hint_shape_change != null) {
                shape_hint_ele.setAttribute("shapeChange", this.shape_hint_shape_change.toString());
            }
            if (this.shape_hint_num_of_non_transp_blocks != null) {
                shape_hint_ele.setAttribute("numOfNonTranspBlocks", this.shape_hint_num_of_non_transp_blocks.toString());
            }
        }
        if (this.coding_hint_avg_quant_scale != null || this.coding_hint_intra_frame_distance != null || this.coding_hint_anchor_frame_distance != null) {
            Element coding_hint_ele = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "CodingHints");
            hints_ele.appendChild(coding_hint_ele);
            if (this.coding_hint_avg_quant_scale != null) {
                coding_hint_ele.setAttribute("avgQuantScale", this.coding_hint_avg_quant_scale.toString());
            }
            if (this.coding_hint_intra_frame_distance != null) {
                coding_hint_ele.setAttribute("intraFrameDistance", this.coding_hint_intra_frame_distance.toString());
            }
            if (this.coding_hint_anchor_frame_distance != null) {
                coding_hint_ele.setAttribute("anchorFrameDistance", this.coding_hint_anchor_frame_distance.toString());
            }
        }
        if (this.difficulty != null) {
            hints_ele.setAttribute("difficulty", this.difficulty.toString());
        }
        if (this.importance != null) {
            hints_ele.setAttribute("importance", this.importance.toString());
        }
        if (this.spatial_resolution_hint != null) {
            hints_ele.setAttribute("spatialResolutionHint", this.spatial_resolution_hint.toString());
        }
        return hints_ele;
    }

    public int getCodingHintAnchorFrameDistance() {
        return this.coding_hint_anchor_frame_distance;
    }

    public float getCodingHintAvgQuantScale() {
        return this.coding_hint_avg_quant_scale.floatValue();
    }

    public int getCodingHintIntraFrameDistance() {
        return this.coding_hint_intra_frame_distance;
    }

    public float getDifficulty() {
        return this.difficulty.floatValue();
    }

    public float getImportance() {
        return this.importance.floatValue();
    }

    public float getMotionHintIntensity() {
        return this.motion_hint_intensity.floatValue();
    }

    public Rectangle getMotionHintRange() {
        return this.motion_hint_range;
    }

    public float getMotionHintUncompensability() {
        return this.motion_hint_uncompensability.floatValue();
    }

    public float getShapeHintNumOfNonTranspBlocks() {
        return this.shape_hint_num_of_non_transp_blocks.floatValue();
    }

    public float getShapeHintShapeChange() {
        return this.shape_hint_shape_change.floatValue();
    }

    public float getSpatialResolutionHint() {
        return this.spatial_resolution_hint.floatValue();
    }

    public void setCodingHintAnchorFrameDistance(int distance) {
        this.coding_hint_anchor_frame_distance = new Integer(distance);
    }

    public void setCodingHintAvgQuantScale(float scale) {
        this.coding_hint_avg_quant_scale = new Float(scale);
    }

    public void setCodingHintIntraFrameDistance(int distance) {
        this.coding_hint_intra_frame_distance = new Integer(distance);
    }

    public void setDifficulty(float difficulty) {
        this.difficulty = new Float(difficulty);
    }

    public void setImportance(float importance) {
        this.importance = new Float(importance);
    }

    public void setMotionHintIntensity(float intensity) {
        this.motion_hint_intensity = new Float(intensity);
    }

    public void setMotionHintRange(Rectangle rectangle) {
        this.motion_hint_range = rectangle;
    }

    public void setMotionHintUncompensability(float uncompensability) {
        this.motion_hint_uncompensability = new Float(uncompensability);
    }

    public void setShapeHintNumOfNonTranspBlocks(float blocks) {
        this.shape_hint_num_of_non_transp_blocks = new Float(blocks);
    }

    public void setShapeHintShapeChange(float change) {
        this.shape_hint_shape_change = new Float(change);
    }

    public void setSpatialResolutionHint(float hint) {
        this.spatial_resolution_hint = new Float(hint);
    }
}

