/*
 * Decompiled with CFR 0.152.
 */
package de.crysandt.audio.mpeg7audio.mci;

import de.crysandt.audio.mpeg7audio.mci.ControlledTermUse;
import de.crysandt.audio.mpeg7audio.mci.DescriptorI;
import de.crysandt.audio.mpeg7audio.mci.MFAudioCoding;
import de.crysandt.audio.mpeg7audio.mci.MFContent;
import de.crysandt.audio.mpeg7audio.mci.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MediaFormat
implements DescriptorI {
    private MFContent content;
    private ControlledTermUse medium;
    private ControlledTermUse file_format;
    private Long file_size;
    private ControlledTermUse system;
    private Float bandwidth;
    private Integer bit_rate;
    private Boolean bit_rate_variable;
    private Integer bit_rate_minimum;
    private Integer bit_rate_average;
    private Integer bit_rate_maximum;
    private Integer target_channel_bit_rate;
    private MFAudioCoding audio_coding;
    private ControlledTermUse scene_coding_format;
    private ControlledTermUse graphics_coding_format;
    private ControlledTermUse other_coding_format;

    public MediaFormat(MFContent content) {
        this.content = content;
        this.medium = null;
        this.file_format = null;
        this.file_size = null;
        this.system = null;
        this.bandwidth = null;
        this.bit_rate = null;
        this.bit_rate_variable = null;
        this.bit_rate_minimum = null;
        this.bit_rate_average = null;
        this.bit_rate_maximum = null;
        this.target_channel_bit_rate = null;
        this.audio_coding = null;
        this.scene_coding_format = null;
        this.graphics_coding_format = null;
        this.other_coding_format = null;
    }

    public Element toXML(Document doc, String name) {
        Element format_ele = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", name);
        format_ele.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "MediaFormatType");
        format_ele.appendChild(this.content.toXML(doc, "Content"));
        if (this.medium != null) {
            format_ele.appendChild(this.medium.toXML(doc, "Medium"));
        }
        if (this.file_format != null) {
            format_ele.appendChild(this.file_format.toXML(doc, "FileFormat"));
        }
        if (this.file_size != null) {
            Element file_size_ele = doc.createElement("FileSize");
            Utils.setContent(doc, file_size_ele, this.file_size.toString());
            format_ele.appendChild(file_size_ele);
        }
        if (this.system != null) {
            format_ele.appendChild(this.system.toXML(doc, "System"));
        }
        if (this.bandwidth != null) {
            Element bandwidth_ele = doc.createElement("Bandwidth");
            Utils.setContent(doc, bandwidth_ele, this.bandwidth.toString());
            format_ele.appendChild(bandwidth_ele);
        }
        if (this.bit_rate != null || this.bit_rate_variable != null || this.bit_rate_minimum != null || this.bit_rate_average != null || this.bit_rate_maximum != null) {
            Element rate_ele = doc.createElement("BitRate");
            format_ele.appendChild(rate_ele);
            if (this.bit_rate_variable != null) {
                rate_ele.setAttribute("variable", this.bit_rate_variable.toString());
            }
            if (this.bit_rate_minimum != null) {
                rate_ele.setAttribute("minimum", this.bit_rate_minimum.toString());
            }
            if (this.bit_rate_average != null) {
                rate_ele.setAttribute("average", this.bit_rate_average.toString());
            }
            if (this.bit_rate_maximum != null) {
                rate_ele.setAttribute("maximum", this.bit_rate_maximum.toString());
            }
            if (this.bit_rate != null) {
                Utils.setContent(doc, rate_ele, this.bit_rate.toString());
            }
        }
        if (this.target_channel_bit_rate != null) {
            Element tc_rate_ele = doc.createElement("TargetChannelBitRate");
            Utils.setContent(doc, tc_rate_ele, this.target_channel_bit_rate.toString());
            format_ele.appendChild(tc_rate_ele);
        }
        if (this.audio_coding != null) {
            format_ele.appendChild(this.audio_coding.toXML(doc, "AudioCoding"));
        }
        if (this.scene_coding_format != null) {
            format_ele.appendChild(this.scene_coding_format.toXML(doc, "SceneCodingFormat"));
        }
        if (this.graphics_coding_format != null) {
            format_ele.appendChild(this.graphics_coding_format.toXML(doc, "GraphicsCodingFormat"));
        }
        if (this.other_coding_format != null) {
            format_ele.appendChild(this.other_coding_format.toXML(doc, "OtherCodingFormat"));
        }
        return format_ele;
    }

    public MFAudioCoding getAudioCoding() {
        return this.audio_coding;
    }

    public float getBandwidth() {
        return this.bandwidth.floatValue();
    }

    public int getBitRate() {
        return this.bit_rate;
    }

    public int getBitRateAverage() {
        return this.bit_rate_average;
    }

    public int getBitRateMaximum() {
        return this.bit_rate_maximum;
    }

    public int getBitRateMinimum() {
        return this.bit_rate_minimum;
    }

    public boolean getBitRateVariable() {
        return this.bit_rate_variable;
    }

    public MFContent getContent() {
        return this.content;
    }

    public ControlledTermUse getFileFormat() {
        return this.file_format;
    }

    public long getFileSize() {
        return this.file_size;
    }

    public ControlledTermUse getGraphicsCodingFormat() {
        return this.graphics_coding_format;
    }

    public ControlledTermUse getMedium() {
        return this.medium;
    }

    public ControlledTermUse getOtherCodingFormat() {
        return this.other_coding_format;
    }

    public ControlledTermUse getSceneCodingFormat() {
        return this.scene_coding_format;
    }

    public ControlledTermUse getSystem() {
        return this.system;
    }

    public int getTargetChannelBitRate() {
        return this.target_channel_bit_rate;
    }

    public void setAudioCoding(MFAudioCoding coding) {
        this.audio_coding = coding;
    }

    public void setBandwidth(float bandwidth) {
        this.bandwidth = new Float(bandwidth);
    }

    public void setBitRate(int rate) {
        this.bit_rate = new Integer(rate);
    }

    public void setBitRateAverage(int rate) {
        this.bit_rate_average = new Integer(rate);
    }

    public void setBitRateMaximum(int rate) {
        this.bit_rate_maximum = new Integer(rate);
    }

    public void setBitRateMinimum(int rate) {
        this.bit_rate_minimum = new Integer(rate);
    }

    public void setBitRateVariable(boolean variable) {
        this.bit_rate_variable = new Boolean(variable);
    }

    public void setContent(MFContent content) {
        this.content = content;
    }

    public void setFileFormat(ControlledTermUse format) {
        this.file_format = format;
    }

    public void setFileSize(long size) {
        this.file_size = new Long(size);
    }

    public void setGraphicsCodingFormat(ControlledTermUse format) {
        this.graphics_coding_format = format;
    }

    public void setMedium(ControlledTermUse medium) {
        this.medium = medium;
    }

    public void setOtherCodingFormat(ControlledTermUse format) {
        this.other_coding_format = format;
    }

    public void setSceneCodingFormat(ControlledTermUse format) {
        this.scene_coding_format = format;
    }

    public void setSystem(ControlledTermUse system) {
        this.system = system;
    }

    public void setTargetChannelBitRate(int rate) {
        this.target_channel_bit_rate = new Integer(rate);
    }
}

