/*
 * Decompiled with CFR 0.152.
 */
package de.crysandt.audio.mpeg7audio.mci;

import de.crysandt.audio.mpeg7audio.mci.Classification;
import de.crysandt.audio.mpeg7audio.mci.Creation;
import de.crysandt.audio.mpeg7audio.mci.CreationHelper;
import de.crysandt.audio.mpeg7audio.mci.DescriptionSchemeI;
import de.crysandt.audio.mpeg7audio.mci.RelatedMaterial;
import de.crysandt.util.Debug;
import de.crysandt.util.VectorTyped;
import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CreationInformation
implements DescriptionSchemeI {
    private Creation creation;
    private Classification classification;
    private VectorTyped related_materials;

    public CreationInformation(Creation creation) {
        this.creation = creation;
        this.classification = null;
        this.related_materials = new VectorTyped(RelatedMaterial.class);
    }

    public Element toXML(Document doc, String name) {
        Element info_ele = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", name);
        info_ele.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "CreationInformationType");
        info_ele.appendChild(this.creation.toXML(doc, "Creation"));
        if (this.classification != null) {
            info_ele.appendChild(this.classification.toXML(doc, "Classification"));
        }
        for (int i = 0; i < this.related_materials.size(); ++i) {
            info_ele.appendChild(((RelatedMaterial)this.related_materials.get(i)).toXML(doc, "RelatedMaterial"));
        }
        return info_ele;
    }

    public Creation getCreation() {
        return this.creation;
    }

    public void setCreation(Creation creation) {
        this.creation = creation;
    }

    public Classification getClassification() {
        return this.classification;
    }

    public void setClassification(Classification classification) {
        this.classification = classification;
    }

    public VectorTyped getRelatedMaterials() {
        return this.related_materials;
    }

    public static void main(String[] args) {
        try {
            CreationInformation creation_info = CreationHelper.createCreationInformation();
            CreationHelper.setAlbumTitle(creation_info, "The Dark Side Of The Moon");
            CreationHelper.setSongTitle(creation_info, "Time");
            CreationHelper.setArtistGroup(creation_info, "Pink Floyd");
            CreationHelper.addArtistGroupMember(creation_info, "David", "Gilmour");
            CreationHelper.addArtistGroupMember(creation_info, "Nick", "Mason");
            CreationHelper.addArtistGroupMember(creation_info, "Richard", "Wright");
            CreationHelper.addArtistGroupMember(creation_info, "Roger", "Waters");
            CreationHelper.setCreationTimePoint(creation_info, "1972");
            CreationHelper.setGenre(creation_info, 1);
            DocumentBuilderFactory doc_factory = DocumentBuilderFactory.newInstance();
            doc_factory.setNamespaceAware(true);
            DocumentBuilder doc_builder = doc_factory.newDocumentBuilder();
            Document doc = doc_builder.newDocument();
            doc.appendChild(creation_info.toXML(doc, "CreationInformation"));
            TransformerFactory trans_factory = TransformerFactory.newInstance();
            Transformer trans = trans_factory.newTransformer();
            trans.setOutputProperty("method", "xml");
            trans.setOutputProperty("indent", "yes");
            trans.transform(new DOMSource(doc), new StreamResult(new File("testCI.mp7")));
        }
        catch (Exception exc) {
            Debug.printStackTrace(System.err, exc);
        }
    }
}

