/*
 * Decompiled with CFR 0.152.
 */
package de.crysandt.audio.mpeg7audio.mci;

import de.crysandt.audio.mpeg7audio.mci.ClGenre;
import de.crysandt.audio.mpeg7audio.mci.Classification;
import de.crysandt.audio.mpeg7audio.mci.ControlledTermUse;
import de.crysandt.audio.mpeg7audio.mci.CrCreationCoordinate;
import de.crysandt.audio.mpeg7audio.mci.Creation;
import de.crysandt.audio.mpeg7audio.mci.CreationInformation;
import de.crysandt.audio.mpeg7audio.mci.Creator;
import de.crysandt.audio.mpeg7audio.mci.Person;
import de.crysandt.audio.mpeg7audio.mci.PersonGroup;
import de.crysandt.audio.mpeg7audio.mci.PersonName;
import de.crysandt.audio.mpeg7audio.mci.Time;
import de.crysandt.audio.mpeg7audio.mci.TimePoint;
import de.crysandt.audio.mpeg7audio.mci.Title;
import de.crysandt.util.VectorTyped;

public class CreationHelper {
    public static CreationInformation createCreationInformation() {
        return new CreationInformation(new Creation());
    }

    public static void setSongTitle(CreationInformation creation_info, String song_title) {
        CreationHelper.getSongTitle(creation_info).setTitle(song_title);
    }

    public static void setAlbumTitle(CreationInformation creation_info, String album_title) {
        CreationHelper.getAlbumTitle(creation_info).setTitle(album_title);
    }

    public static void setArtistPerson(CreationInformation creation_info, String given_name, String family_name) {
        PersonName person_name = CreationHelper.getArtistPersonName(creation_info);
        person_name.setGivenName(given_name);
        person_name.setFamilyName(family_name);
    }

    public static void setArtistGroup(CreationInformation creation_info, String group_name) {
        PersonGroup person_group = CreationHelper.getArtistGroup(creation_info);
        person_group.getNames().clear();
        person_group.getNames().add(group_name);
    }

    public static void clearArtistGroupMembers(CreationInformation creation_info) {
        PersonGroup person_group = CreationHelper.getArtistGroup(creation_info);
        person_group.getMembers().clear();
    }

    public static void addArtistGroupMember(CreationInformation creation_info, String given_name, String family_name) {
        PersonGroup person_group = CreationHelper.getArtistGroup(creation_info);
        person_group.getMembers().add(new Person(new PersonName(given_name, family_name)));
    }

    public static void setGenre(CreationInformation creation_info, int genre) {
        CreationHelper.getGenre(creation_info).setGenre(genre);
    }

    public static void setCreationTimePoint(CreationInformation creation_info, String time) {
        CreationHelper.getCreationTimePoint(creation_info).setTimePoint(time);
    }

    private static Creation getCreation(CreationInformation creation_info) {
        if (creation_info.getCreation() == null) {
            creation_info.setCreation(new Creation());
        }
        return creation_info.getCreation();
    }

    private static Title getSongTitle(CreationInformation creation_info) {
        return CreationHelper.getTitle(creation_info, "songTitle");
    }

    private static Title getAlbumTitle(CreationInformation creation_info) {
        return CreationHelper.getTitle(creation_info, "albumTitle");
    }

    private static Title getTitle(CreationInformation creation_info, String title_type) {
        int i;
        VectorTyped titles = CreationHelper.getCreation(creation_info).getTitles();
        for (i = 0; i < titles.size() && !((Title)titles.get(i)).getType().equals(title_type); ++i) {
        }
        if (i == titles.size()) {
            Title title = new Title("", title_type);
            titles.add(title);
        }
        return (Title)titles.get(i);
    }

    private static Creator getCreator(CreationInformation creation_info) {
        Creation creation = CreationHelper.getCreation(creation_info);
        if (creation.getCreators().size() == 0) {
            creation.getCreators().add(new Creator());
        }
        return (Creator)creation.getCreators().get(0);
    }

    private static Person getArtistPerson(CreationInformation creation_info) {
        Creator creator = CreationHelper.getCreator(creation_info);
        if (creator.getAgents().size() == 0) {
            Person person = new Person(new PersonName(""));
            creator.getAgents().add(person);
        } else if (!creator.getAgents().get(0).getClass().equals(Person.class)) {
            creator.getAgents().clear();
            Person person = new Person(new PersonName(""));
            creator.getAgents().add(person);
        }
        if (creator.getRoles().size() == 0) {
            creator.getRoles().add(new ControlledTermUse("urn:mpeg:mpeg7:RoleCS:2001:PERFORMER"));
        }
        return (Person)creator.getAgents().get(0);
    }

    private static PersonName getArtistPersonName(CreationInformation creation_info) {
        Person person = CreationHelper.getArtistPerson(creation_info);
        if (person.getNames().size() == 0) {
            person.getNames().add(new PersonName(""));
        }
        return (PersonName)person.getNames().get(0);
    }

    private static PersonGroup getArtistGroup(CreationInformation creation_info) {
        Creator creator = CreationHelper.getCreator(creation_info);
        if (creator.getAgents().size() == 0) {
            PersonGroup person_group = new PersonGroup("");
            creator.getAgents().add(person_group);
        } else if (!creator.getAgents().get(0).getClass().equals(PersonGroup.class)) {
            creator.getAgents().clear();
            PersonGroup person_group = new PersonGroup("");
            creator.getAgents().add(person_group);
        }
        if (creator.getRoles().size() == 0) {
            creator.getRoles().add(new ControlledTermUse("urn:mpeg:mpeg7:RoleCS:2001:PERFORMER"));
        }
        return (PersonGroup)creator.getAgents().get(0);
    }

    private static Classification getClassification(CreationInformation creation_info) {
        if (creation_info.getClassification() == null) {
            creation_info.setClassification(new Classification());
        }
        return creation_info.getClassification();
    }

    private static ClGenre getGenre(CreationInformation creation_info) {
        Classification classification = CreationHelper.getClassification(creation_info);
        if (classification.getGenres().size() == 0) {
            classification.getGenres().add(new ClGenre(12));
        }
        return (ClGenre)classification.getGenres().get(0);
    }

    private static CrCreationCoordinate getCreationCoordinate(CreationInformation creation_info) {
        Creation creation = CreationHelper.getCreation(creation_info);
        if (creation.getCoordinates().size() == 0) {
            creation.getCoordinates().add(new CrCreationCoordinate());
        }
        return (CrCreationCoordinate)creation.getCoordinates().get(0);
    }

    private static Time getCreationTime(CreationInformation creation_info) {
        CrCreationCoordinate coord = CreationHelper.getCreationCoordinate(creation_info);
        if (coord.getDates().size() == 0) {
            coord.getDates().add(new Time(new TimePoint("")));
        }
        return (Time)coord.getDates().get(0);
    }

    private static TimePoint getCreationTimePoint(CreationInformation creation_info) {
        Time time = CreationHelper.getCreationTime(creation_info);
        if (time.getTimePoint() == null) {
            time.setTimePoint(new TimePoint(""));
        }
        return time.getTimePoint();
    }
}

