/*
 * Decompiled with CFR 0.152.
 */
package de.crysandt.audio.mpeg7audio;

import de.crysandt.audio.AudioInFloat;
import de.crysandt.audio.AudioInFloatSampled;
import de.crysandt.audio.mpeg7audio.Config;
import de.crysandt.audio.mpeg7audio.ConfigXML;
import de.crysandt.audio.mpeg7audio.Encoder;
import de.crysandt.audio.mpeg7audio.Ticker;
import de.crysandt.audio.mpeg7audio.mci.CreationInformation;
import de.crysandt.audio.mpeg7audio.mci.MediaHelper;
import de.crysandt.audio.mpeg7audio.mci.MediaInformation;
import de.crysandt.audio.mpeg7audio.msgs.Msg;
import de.crysandt.audio.mpeg7audio.msgs.MsgAudioFundamentalFrequency;
import de.crysandt.audio.mpeg7audio.msgs.MsgAudioHarmonicity;
import de.crysandt.audio.mpeg7audio.msgs.MsgAudioPower;
import de.crysandt.audio.mpeg7audio.msgs.MsgAudioSignature;
import de.crysandt.audio.mpeg7audio.msgs.MsgAudioSpectrumBasisProjection;
import de.crysandt.audio.mpeg7audio.msgs.MsgAudioSpectrumCentroid;
import de.crysandt.audio.mpeg7audio.msgs.MsgAudioSpectrumDistribution;
import de.crysandt.audio.mpeg7audio.msgs.MsgAudioSpectrumEnvelope;
import de.crysandt.audio.mpeg7audio.msgs.MsgAudioSpectrumFlatness;
import de.crysandt.audio.mpeg7audio.msgs.MsgAudioSpectrumSpread;
import de.crysandt.audio.mpeg7audio.msgs.MsgAudioTempoType;
import de.crysandt.audio.mpeg7audio.msgs.MsgAudioWaveform;
import de.crysandt.audio.mpeg7audio.msgs.MsgBackgroundNoiseLevel;
import de.crysandt.audio.mpeg7audio.msgs.MsgBandWidth;
import de.crysandt.audio.mpeg7audio.msgs.MsgClick;
import de.crysandt.audio.mpeg7audio.msgs.MsgDcOffset;
import de.crysandt.audio.mpeg7audio.msgs.MsgDigitalClip;
import de.crysandt.audio.mpeg7audio.msgs.MsgDigitalZero;
import de.crysandt.audio.mpeg7audio.msgs.MsgHarmonicSpectralCentroid;
import de.crysandt.audio.mpeg7audio.msgs.MsgHarmonicSpectralDeviation;
import de.crysandt.audio.mpeg7audio.msgs.MsgHarmonicSpectralSpread;
import de.crysandt.audio.mpeg7audio.msgs.MsgHarmonicSpectralVariation;
import de.crysandt.audio.mpeg7audio.msgs.MsgListener;
import de.crysandt.audio.mpeg7audio.msgs.MsgLogAttackTime;
import de.crysandt.audio.mpeg7audio.msgs.MsgResizer;
import de.crysandt.audio.mpeg7audio.msgs.MsgSampleHold;
import de.crysandt.audio.mpeg7audio.msgs.MsgSilence;
import de.crysandt.audio.mpeg7audio.msgs.MsgSoundModel;
import de.crysandt.audio.mpeg7audio.msgs.MsgSpectralCentroid;
import de.crysandt.audio.mpeg7audio.msgs.MsgTemporalCentroid;
import de.crysandt.hmm.GaussianDistribution;
import de.crysandt.hmm.HMM;
import java.io.File;
import java.io.FileReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.sound.sampled.AudioInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MP7DocumentBuilder
implements MsgListener {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String SPACE = " ";
    private static final String NEXT_BLOCK = "Next Block";
    private final TreeMap<String, String> schema_location = new TreeMap();
    private int duration = 0;
    private List<Msg> listAP = new ArrayList<Msg>();
    private List<Msg> listASBP = new ArrayList<Msg>();
    private List<Msg> listASC = new ArrayList<Msg>();
    private List<Msg> listASD = new ArrayList<Msg>();
    private List<Msg> listASE = new ArrayList<Msg>();
    private List<Msg> listASF = new ArrayList<Msg>();
    private List<Msg> listASS = new ArrayList<Msg>();
    private List<Msg> listAW = new ArrayList<Msg>();
    private List<Msg> listAH = new ArrayList<Msg>();
    private List<Msg> listAFF = new ArrayList<Msg>();
    private List<Msg> listDC = new ArrayList<Msg>();
    private List<Msg> listDZ = new ArrayList<Msg>();
    private List<Msg> listSH = new ArrayList<Msg>();
    private List<Msg> listCK = new ArrayList<Msg>();
    private List<Msg> listBNL = new ArrayList<Msg>();
    private List<Msg> listDCO = new ArrayList<Msg>();
    private List<Msg> listBW = new ArrayList<Msg>();
    private MsgHarmonicSpectralCentroid msgHSC = null;
    private MsgHarmonicSpectralDeviation msgHSD = null;
    private MsgHarmonicSpectralSpread msgHSS = null;
    private MsgHarmonicSpectralVariation msgHSV = null;
    private MsgLogAttackTime msgLAT = null;
    private MsgSpectralCentroid msgSC = null;
    private MsgTemporalCentroid msgTC = null;
    private List<Msg> listAS = new ArrayList<Msg>();
    private List<Msg> listSI = new ArrayList<Msg>();
    private List<Msg> listBPM = new ArrayList<Msg>();
    private MsgSoundModel msg_sound_model = null;
    private MediaInformation media_information = null;
    private CreationInformation creation_information = null;

    public void setMediaInformation(MediaInformation mi) {
        this.media_information = mi;
    }

    public void setCreationInformation(CreationInformation ci) {
        this.creation_information = ci;
    }

    protected Element createFrame(Document doc) {
        Element mpeg7 = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Mpeg7");
        mpeg7.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:mpeg:mpeg7:schema:2001");
        mpeg7.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:mpeg7", "urn:mpeg:mpeg7:schema:2001");
        mpeg7.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        doc.appendChild(mpeg7);
        Element description = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Description");
        description.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "ContentEntityType");
        mpeg7.appendChild(description);
        Element mm_content = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "MultimediaContent");
        mm_content.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "AudioType");
        description.appendChild(mm_content);
        Element audio_segment = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Audio");
        audio_segment.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "AudioSegmentType");
        mm_content.appendChild(audio_segment);
        return audio_segment;
    }

    public Document getDocument() throws ParserConfigurationException {
        DocumentBuilderFactory doc_factory = DocumentBuilderFactory.newInstance();
        doc_factory.setNamespaceAware(true);
        DocumentBuilder doc_builder = doc_factory.newDocumentBuilder();
        Document doc = doc_builder.newDocument();
        Element audio_segment = this.createFrame(doc);
        this.addMediaInformation(doc, audio_segment);
        this.addCreationInformation(doc, audio_segment);
        this.addAFF(doc, audio_segment);
        this.addAH(doc, audio_segment);
        this.addAP(doc, audio_segment);
        this.addASBP(doc, audio_segment);
        this.addASC(doc, audio_segment);
        this.addASD(doc, audio_segment);
        this.addASE(doc, audio_segment);
        this.addASF(doc, audio_segment);
        this.addASS(doc, audio_segment);
        this.addAW(doc, audio_segment);
        this.addLAT(doc, audio_segment);
        this.addSC(doc, audio_segment);
        this.addTC(doc, audio_segment);
        this.addHSC(doc, audio_segment);
        this.addHSD(doc, audio_segment);
        this.addHSS(doc, audio_segment);
        this.addHSV(doc, audio_segment);
        this.addASQ(doc, audio_segment);
        this.addAS(doc, audio_segment);
        this.addSoundModel(doc);
        if (!this.schema_location.isEmpty()) {
            StringBuffer buffer = new StringBuffer();
            for (String key : this.schema_location.keySet()) {
                String value = this.schema_location.get(key);
                buffer.append(key.toString()).append(SPACE);
                buffer.append(value.toString()).append(SPACE);
            }
            ((Element)doc.getFirstChild()).setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", buffer.toString());
        }
        doc.normalize();
        return doc;
    }

    public void addSchemaLocation(String schema, String location) {
        this.schema_location.put(schema, location);
    }

    public void receivedMsg(Msg msg) {
        if (msg instanceof MsgResizer) {
            this.setDuration((MsgResizer)msg);
        } else if (msg instanceof MsgDigitalClip) {
            this.listDC.add(msg);
        } else if (msg instanceof MsgDigitalZero) {
            this.listDZ.add(msg);
        } else if (msg instanceof MsgSampleHold) {
            this.listSH.add(msg);
        } else if (msg instanceof MsgClick) {
            this.listCK.add(msg);
        } else if (msg instanceof MsgBackgroundNoiseLevel) {
            this.listBNL.add(msg);
        } else if (msg instanceof MsgDcOffset) {
            this.listDCO.add(msg);
        } else if (msg instanceof MsgBandWidth) {
            this.listBW.add(msg);
        } else if (msg instanceof MsgAudioSignature) {
            this.listAS.add(msg);
        } else if (msg instanceof MsgAudioSpectrumBasisProjection) {
            this.listASBP.add(msg);
        } else if (msg instanceof MsgAudioSpectrumCentroid) {
            this.listASC.add(msg);
        } else if (msg instanceof MsgAudioSpectrumSpread) {
            this.listASS.add(msg);
        } else if (msg instanceof MsgAudioPower) {
            this.listAP.add(msg);
        } else if (msg instanceof MsgAudioSpectrumDistribution) {
            this.listASD.add(msg);
        } else if (msg instanceof MsgAudioSpectrumEnvelope) {
            this.listASE.add(msg);
        } else if (msg instanceof MsgAudioSpectrumFlatness) {
            this.listASF.add(msg);
        } else if (msg instanceof MsgAudioWaveform) {
            this.listAW.add(msg);
        } else if (msg instanceof MsgAudioFundamentalFrequency) {
            this.listAFF.add(msg);
        } else if (msg instanceof MsgAudioHarmonicity) {
            this.listAH.add(msg);
        } else if (msg instanceof MsgSilence) {
            this.listSI.add(msg);
        } else if (msg instanceof MsgAudioTempoType) {
            this.listBPM.add(msg);
        } else if (msg instanceof MsgHarmonicSpectralCentroid) {
            assert (this.msgHSC == null);
            this.msgHSC = (MsgHarmonicSpectralCentroid)msg;
        } else if (msg instanceof MsgHarmonicSpectralDeviation) {
            assert (this.msgHSD == null);
            this.msgHSD = (MsgHarmonicSpectralDeviation)msg;
        } else if (msg instanceof MsgHarmonicSpectralSpread) {
            assert (this.msgHSS == null);
            this.msgHSS = (MsgHarmonicSpectralSpread)msg;
        } else if (msg instanceof MsgHarmonicSpectralVariation) {
            assert (this.msgHSV == null);
            this.msgHSV = (MsgHarmonicSpectralVariation)msg;
        } else if (msg instanceof MsgSoundModel) {
            assert (this.msg_sound_model == null);
            this.msg_sound_model = (MsgSoundModel)msg;
        }
    }

    private void addMediaInformation(Document doc, Element audio_segment) {
        if (this.media_information == null) {
            return;
        }
        audio_segment.appendChild(this.media_information.toXML(doc, "MediaInformation"));
    }

    private void addCreationInformation(Document doc, Element audio_segment) {
        if (this.creation_information == null) {
            return;
        }
        audio_segment.appendChild(this.creation_information.toXML(doc, "CreationInformation"));
    }

    private void setDuration(MsgResizer msg) {
        this.duration = Math.max(this.duration, msg.time + msg.duration);
    }

    private void addASQ(Document doc, Element audio_segment) {
        Element vector;
        DecimalFormat df;
        StringBuffer numberch;
        if (this.listDC.isEmpty() && this.listDZ.isEmpty() && this.listSH.isEmpty() && this.listCK.isEmpty() && this.listBNL.isEmpty() && this.listDCO.isEmpty() && this.listBW.isEmpty()) {
            return;
        }
        Element audio_descriptor = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "AudioDescriptor");
        audio_descriptor.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "AudioSignalQuality");
        audio_segment.appendChild(audio_descriptor);
        if (!this.listBNL.isEmpty()) {
            Collections.sort(this.listBNL);
            MsgBackgroundNoiseLevel msgBackgroundNoiseLevel = (MsgBackgroundNoiseLevel)this.listBNL.get(0);
            numberch = new StringBuffer();
            StringBuffer buffer_bnl = new StringBuffer();
            df = new DecimalFormat("0.####");
            for (MsgBackgroundNoiseLevel msgBackgroundNoiseLevel2 : this.listBNL) {
                numberch.append(msgBackgroundNoiseLevel2.channel);
                if (msgBackgroundNoiseLevel2.bnl == 100.0) {
                    buffer_bnl.append("-Infinity");
                    continue;
                }
                buffer_bnl.append(df.format(msgBackgroundNoiseLevel2.bnl));
            }
            Element bnl = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "BackgroundNoiseLevel");
            audio_descriptor.appendChild(bnl);
            bnl.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "channels", numberch.toString());
            vector = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Vector");
            bnl.appendChild(vector);
            vector.appendChild(doc.createTextNode(buffer_bnl.toString()));
        }
        if (!this.listDCO.isEmpty()) {
            Collections.sort(this.listDCO);
            MsgDcOffset msgDcOffset = (MsgDcOffset)this.listDCO.get(0);
            numberch = new StringBuffer();
            StringBuffer buffer_dco = new StringBuffer();
            df = new DecimalFormat("0.####");
            for (MsgDcOffset msgDcOffset2 : this.listDCO) {
                numberch.append(msgDcOffset2.channel);
                buffer_dco.append(df.format(msgDcOffset2.dco));
            }
            Element dco = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "DcOffset");
            audio_descriptor.appendChild(dco);
            dco.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "channels", numberch.toString());
            vector = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Vector");
            dco.appendChild(vector);
            vector.appendChild(doc.createTextNode(buffer_dco.toString()));
        }
        if (!this.listBW.isEmpty()) {
            Collections.sort(this.listBW);
            MsgBandWidth msgBandWidth = (MsgBandWidth)this.listBW.get(0);
            numberch = new StringBuffer();
            StringBuffer buffer_bw = new StringBuffer();
            df = new DecimalFormat("0.####");
            for (MsgBandWidth msgBandWidth2 : this.listBW) {
                numberch.append(msgBandWidth2.channel);
                buffer_bw.append(df.format(msgBandWidth2.bw));
            }
            Element bw = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "BandWidth");
            audio_descriptor.appendChild(bw);
            bw.setAttribute("channels", numberch.toString());
            vector = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Vector");
            bw.appendChild(vector);
            vector.appendChild(doc.createTextNode(buffer_bw.toString()));
        }
        if (!(this.listDC.isEmpty() && this.listDZ.isEmpty() && this.listCK.isEmpty() && this.listSH.isEmpty())) {
            Element free;
            Element comm;
            Element status;
            Element det;
            Element rel;
            Element time_duration;
            Element time_point;
            Element time;
            Element channel_no;
            Element name;
            Element er_class;
            Element ev;
            int k;
            StringBuffer numberch2;
            StringBuffer cp;
            StringBuffer mtb;
            StringBuffer mtu;
            Element element = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "ErrorEventList");
            audio_descriptor.appendChild(element);
            if (!this.listCK.isEmpty()) {
                Collections.sort(this.listCK);
                for (MsgClick msg3 : this.listCK) {
                    int how_many_clicks = msg3.getClicksnumber();
                    StringBuffer numberch22 = new StringBuffer();
                    mtu = new StringBuffer();
                    mtb = new StringBuffer();
                    mtu.append("PT1N" + (int)msg3.SAMPLE_RATE + "F");
                    mtb.append("../../MediaLocator[1]");
                    numberch22.append(msg3.channel);
                    for (int w = 0; w < how_many_clicks; ++w) {
                        cp = new StringBuffer();
                        cp.append(msg3.getClickposition(w));
                        Element ev2 = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "ErrorEvent");
                        element.appendChild(ev2);
                        Element er_class2 = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "ErrorClass");
                        ev2.appendChild(er_class2);
                        er_class2.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "href", "urn:mpeg:mpeg7:cs:ErrorClassCS:click");
                        Element name2 = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Name");
                        er_class2.appendChild(name2);
                        name2.appendChild(doc.createTextNode("Click"));
                        Element channel_no2 = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "ChannelNo");
                        ev2.appendChild(channel_no2);
                        channel_no2.appendChild(doc.createTextNode(numberch22.toString()));
                        Element time2 = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "TimeStamp");
                        ev2.appendChild(time2);
                        Element time_point2 = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "MediaRelIncrTimePoint");
                        time2.appendChild(time_point2);
                        time_point2.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "mediaTimeUnit", mtu.toString());
                        time_point2.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "mediaTimeBase", mtb.toString());
                        time_point2.appendChild(doc.createTextNode(cp.toString()));
                        Element rel2 = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Relevance");
                        ev2.appendChild(rel2);
                        rel2.appendChild(doc.createTextNode("0"));
                        Element det2 = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "DetectionProcess");
                        ev2.appendChild(det2);
                        det2.appendChild(doc.createTextNode("automatic"));
                        Element status2 = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Status");
                        ev2.appendChild(status2);
                        status2.appendChild(doc.createTextNode("checked"));
                        Element comm2 = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Comment");
                        ev2.appendChild(comm2);
                        Element free2 = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "FreeTextAnnotation");
                        comm2.appendChild(free2);
                        free2.appendChild(doc.createTextNode("any comment"));
                    }
                }
            }
            if (!this.listDC.isEmpty()) {
                Collections.sort(this.listDC);
                for (Msg msg : this.listDC) {
                    int how_many_clips = ((MsgDigitalClip)msg).getClipsnumber();
                    numberch2 = new StringBuffer();
                    mtu = new StringBuffer();
                    mtb = new StringBuffer();
                    mtu.append("PT1N" + (int)((MsgDigitalClip)msg).SAMPLE_RATE + "F");
                    mtb.append("../../MediaLocator[1]");
                    numberch2.append(((MsgDigitalClip)msg).channel);
                    for (k = 0; k < how_many_clips; ++k) {
                        cp = new StringBuffer();
                        cp.append(((MsgDigitalClip)msg).getClipposition(k));
                        StringBuffer cd = new StringBuffer();
                        cd.append(((MsgDigitalClip)msg).getCliplength(k));
                        ev = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "ErrorEvent");
                        element.appendChild(ev);
                        er_class = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "ErrorClass");
                        ev.appendChild(er_class);
                        er_class.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "href", "urn:mpeg:mpeg7:cs:ErrorClassCS:digitalclip");
                        name = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Name");
                        er_class.appendChild(name);
                        name.appendChild(doc.createTextNode("DigitalClip"));
                        channel_no = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "ChannelNo");
                        ev.appendChild(channel_no);
                        channel_no.appendChild(doc.createTextNode(numberch2.toString()));
                        time = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "TimeStamp");
                        ev.appendChild(time);
                        time_point = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "MediaRelIncrTimePoint");
                        time.appendChild(time_point);
                        time_point.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "mediaTimeUnit", mtu.toString());
                        time_point.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "mediaTimeBase", mtb.toString());
                        time_point.appendChild(doc.createTextNode(cp.toString()));
                        time_duration = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "MediaIncrDuration");
                        time.appendChild(time_duration);
                        time_duration.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "mediaTimeUnit", mtu.toString());
                        time_duration.appendChild(doc.createTextNode(cd.toString()));
                        rel = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Relevance");
                        ev.appendChild(rel);
                        rel.appendChild(doc.createTextNode("0"));
                        det = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "DetectionProcess");
                        ev.appendChild(det);
                        det.appendChild(doc.createTextNode("automatic"));
                        status = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Status");
                        ev.appendChild(status);
                        status.appendChild(doc.createTextNode("checked"));
                        comm = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Comment");
                        ev.appendChild(comm);
                        free = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "FreeTextAnnotation");
                        comm.appendChild(free);
                        free.appendChild(doc.createTextNode("any comment"));
                    }
                }
            }
            if (!this.listDZ.isEmpty()) {
                Collections.sort(this.listDZ);
                for (Msg msg : this.listDZ) {
                    int how_many_zeros = ((MsgDigitalZero)msg).getZerosnumber();
                    numberch2 = new StringBuffer();
                    mtu = new StringBuffer();
                    mtb = new StringBuffer();
                    mtu.append("PT1N" + (int)((MsgDigitalZero)msg).SAMPLE_RATE + "F");
                    mtb.append("../../MediaLocator[1]");
                    numberch2.append(((MsgDigitalZero)msg).channel);
                    for (k = 0; k < how_many_zeros; ++k) {
                        StringBuffer zp = new StringBuffer();
                        zp.append(((MsgDigitalZero)msg).getZeroposition(k));
                        StringBuffer zd = new StringBuffer();
                        zd.append(((MsgDigitalZero)msg).getZerolength(k));
                        ev = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "ErrorEvent");
                        element.appendChild(ev);
                        er_class = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "ErrorClass");
                        ev.appendChild(er_class);
                        er_class.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "href", "urn:mpeg:mpeg7:cs:ErrorClassCS:digitalzero");
                        name = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Name");
                        er_class.appendChild(name);
                        name.appendChild(doc.createTextNode("DigitalZero"));
                        channel_no = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "ChannelNo");
                        ev.appendChild(channel_no);
                        channel_no.appendChild(doc.createTextNode(numberch2.toString()));
                        time = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "TimeStamp");
                        ev.appendChild(time);
                        time_point = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "MediaRelIncrTimePoint");
                        time.appendChild(time_point);
                        time_point.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "mediaTimeUnit", mtu.toString());
                        time_point.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "mediaTimeBase", mtb.toString());
                        time_point.appendChild(doc.createTextNode(zp.toString()));
                        time_duration = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "MediaIncrDuration");
                        time.appendChild(time_duration);
                        time_duration.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "mediaTimeUnit", mtu.toString());
                        time_duration.appendChild(doc.createTextNode(zd.toString()));
                        rel = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Relevance");
                        ev.appendChild(rel);
                        rel.appendChild(doc.createTextNode("0"));
                        det = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "DetectionProcess");
                        ev.appendChild(det);
                        det.appendChild(doc.createTextNode("automatic"));
                        status = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Status");
                        ev.appendChild(status);
                        status.appendChild(doc.createTextNode("checked"));
                        comm = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Comment");
                        ev.appendChild(comm);
                        free = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "FreeTextAnnotation");
                        comm.appendChild(free);
                        free.appendChild(doc.createTextNode("any comment"));
                    }
                }
            }
            if (!this.listSH.isEmpty()) {
                Collections.sort(this.listSH);
                for (Msg msg : this.listSH) {
                    int how_many_s_holds = ((MsgSampleHold)msg).getShnumber();
                    numberch2 = new StringBuffer();
                    mtu = new StringBuffer();
                    mtb = new StringBuffer();
                    mtu.append("PT1N" + (int)((MsgSampleHold)msg).SAMPLE_RATE + "F");
                    mtb.append("../../MediaLocator[1]");
                    numberch2.append(((MsgSampleHold)msg).channel);
                    for (k = 0; k < how_many_s_holds; ++k) {
                        StringBuffer shp = new StringBuffer();
                        shp.append(((MsgSampleHold)msg).getshposition(k));
                        StringBuffer shd = new StringBuffer();
                        shd.append(((MsgSampleHold)msg).getshlength(k));
                        ev = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "ErrorEvent");
                        element.appendChild(ev);
                        er_class = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "ErrorClass");
                        ev.appendChild(er_class);
                        er_class.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "href", "urn:mpeg:mpeg7:cs:ErrorClassCS:samplehold");
                        name = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Name");
                        er_class.appendChild(name);
                        name.appendChild(doc.createTextNode("SampleHold"));
                        channel_no = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "ChannelNo");
                        ev.appendChild(channel_no);
                        channel_no.appendChild(doc.createTextNode(numberch2.toString()));
                        time = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "TimeStamp");
                        ev.appendChild(time);
                        time_point = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "MediaRelIncrTimePoint");
                        time.appendChild(time_point);
                        time_point.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "mediaTimeUnit", mtu.toString());
                        time_point.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "mediaTimeBase", mtb.toString());
                        time_point.appendChild(doc.createTextNode(shp.toString()));
                        time_duration = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "MediaIncrDuration");
                        time.appendChild(time_duration);
                        time_duration.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "mediaTimeUnit", mtu.toString());
                        time_duration.appendChild(doc.createTextNode(shd.toString()));
                        rel = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Relevance");
                        ev.appendChild(rel);
                        rel.appendChild(doc.createTextNode("0"));
                        det = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "DetectionProcess");
                        ev.appendChild(det);
                        det.appendChild(doc.createTextNode("automatic"));
                        status = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Status");
                        ev.appendChild(status);
                        status.appendChild(doc.createTextNode("checked"));
                        comm = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Comment");
                        ev.appendChild(comm);
                        free = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "FreeTextAnnotation");
                        comm.appendChild(free);
                        free.appendChild(doc.createTextNode("any comment"));
                    }
                }
            }
        }
    }

    private void addAFF(Document doc, Element audio_segment) {
        if (this.listAFF.isEmpty()) {
            return;
        }
        Collections.sort(this.listAFF);
        MsgAudioFundamentalFrequency msgAudioFundamentalFrequency = (MsgAudioFundamentalFrequency)this.listAFF.get(0);
        Element audio_descriptor = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "AudioDescriptor");
        audio_descriptor.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "AudioFundamentalFrequencyType");
        audio_descriptor.setAttribute("loLimit", "" + msgAudioFundamentalFrequency.lolimit);
        audio_descriptor.setAttribute("hiLimit", "" + msgAudioFundamentalFrequency.hilimit);
        audio_segment.appendChild(audio_descriptor);
        Element sos_aff = MP7DocumentBuilder.getSeriesOfScalar(doc, msgAudioFundamentalFrequency.hopsize, this.listAFF.size());
        audio_descriptor.appendChild(sos_aff);
        Element raw_aff = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Raw");
        sos_aff.appendChild(raw_aff);
        StringBuffer buffer_aff = new StringBuffer();
        for (MsgAudioFundamentalFrequency msgAudioFundamentalFrequency2 : this.listAFF) {
            buffer_aff.append(msgAudioFundamentalFrequency2.fundfreq).append(SPACE);
        }
        raw_aff.appendChild(doc.createTextNode(buffer_aff.toString()));
    }

    private void addAH(Document doc, Element audio_segment) {
        if (this.listAH.isEmpty()) {
            return;
        }
        Collections.sort(this.listAH);
        MsgAudioHarmonicity msgAudioHarmonicity = (MsgAudioHarmonicity)this.listAH.get(0);
        Element audio_descriptor = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "AudioDescriptor");
        audio_descriptor.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "AudioHarmonicityType");
        audio_segment.appendChild(audio_descriptor);
        Element hr = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "HarmonicRatio");
        audio_descriptor.appendChild(hr);
        Element ul = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "UpperLimitOfHarmonicity");
        audio_descriptor.appendChild(ul);
        Element sos_hr = MP7DocumentBuilder.getSeriesOfScalar(doc, msgAudioHarmonicity.hopsize, this.listAH.size());
        hr.appendChild(sos_hr);
        Element raw_hr = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Raw");
        sos_hr.appendChild(raw_hr);
        Element sos_ul = MP7DocumentBuilder.getSeriesOfScalar(doc, msgAudioHarmonicity.hopsize, this.listAH.size());
        ul.appendChild(sos_ul);
        Element raw_ul = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Raw");
        sos_ul.appendChild(raw_ul);
        StringBuffer buffer_hr = new StringBuffer();
        StringBuffer buffer_ul = new StringBuffer();
        for (MsgAudioHarmonicity msgAudioHarmonicity2 : this.listAH) {
            buffer_hr.append(msgAudioHarmonicity2.harmonicratio).append(SPACE);
            buffer_ul.append(msgAudioHarmonicity2.upperlimit).append(SPACE);
        }
        raw_hr.appendChild(doc.createTextNode(buffer_hr.toString()));
        raw_ul.appendChild(doc.createTextNode(buffer_ul.toString()));
    }

    private void addAP(Document doc, Element audio_segment) {
        if (this.listAP.isEmpty()) {
            return;
        }
        Collections.sort(this.listAP);
        MsgAudioPower msg = (MsgAudioPower)this.listAP.get(0);
        Element audio_descriptor = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "AudioDescriptor");
        audio_descriptor.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "AudioPowerType");
        if (msg.db_scale) {
            audio_descriptor.setAttribute("dbScale", "true");
            this.schema_location.put("urn:mpeg:mpeg7:schema:2001", "http://www.ient.rwth-aachen.de/team/crysandt/mpeg7mds/mpeg7patched.xml");
        }
        audio_segment.appendChild(audio_descriptor);
        Element sos = MP7DocumentBuilder.getSeriesOfScalar(doc, msg.hopsize, this.listAP.size());
        audio_descriptor.appendChild(sos);
        StringBuffer buffer = new StringBuffer();
        Iterator<Msg> i = this.listAP.iterator();
        while (i.hasNext()) {
            buffer.append(MP7DocumentBuilder.format(((MsgAudioPower)i.next()).power));
            buffer.append(SPACE);
        }
        Element raw = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Raw");
        sos.appendChild(raw);
        raw.appendChild(doc.createTextNode(buffer.toString().trim()));
    }

    private void addASBP(Document doc, Element audio_segment) {
        if (this.listASBP.isEmpty()) {
            return;
        }
        Collections.sort(this.listASBP);
        MsgAudioSpectrumBasisProjection msg = (MsgAudioSpectrumBasisProjection)this.listASBP.get(0);
        Element audio_descriptor_basis = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "AudioDescriptor");
        audio_descriptor_basis.setAttribute("loEdge", "" + msg.lo_edge);
        audio_descriptor_basis.setAttribute("hiEdge", "" + msg.hi_edge);
        audio_descriptor_basis.setAttribute("octaveResolution", msg.resolution >= 1.0f ? "" + Math.round(msg.resolution) : "1/" + Math.round(msg.resolution));
        audio_descriptor_basis.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "AudioSpectrumBasisType");
        audio_segment.appendChild(audio_descriptor_basis);
        float[][] basis = msg.getBasis();
        int basis_rows = basis.length;
        int basis_cols = basis[0].length;
        Element sov_basis = MP7DocumentBuilder.getSeriesOfVector(doc, msg.hopsize, basis_rows, basis_cols);
        audio_descriptor_basis.appendChild(sov_basis);
        Element raw_basis = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Raw");
        raw_basis.setAttributeNS("urn:mpeg:mpeg7:schema:2001", "mpeg7:dim", this.listASBP.size() + SPACE + basis_rows + SPACE + basis_cols);
        sov_basis.appendChild(raw_basis);
        raw_basis.appendChild(doc.createTextNode(MP7DocumentBuilder.append(new StringBuffer(), basis).toString()));
        Element audio_descriptor_projection = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "AudioDescriptor");
        audio_descriptor_projection.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "AudioSpectrumProjectionType");
        audio_segment.appendChild(audio_descriptor_projection);
        float[][] projection = msg.getProjection();
        int projection_rows = projection.length;
        int projection_cols = projection[0].length;
        Element sov_projection = MP7DocumentBuilder.getSeriesOfVector(doc, msg.hopsize, projection_rows, projection_cols);
        audio_descriptor_projection.appendChild(sov_projection);
        Element raw_projection = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Raw");
        raw_projection.setAttributeNS("urn:mpeg:mpeg7:schema:2001", "mpeg7:dim", this.listASBP.size() + SPACE + projection_rows + SPACE + projection_cols);
        sov_projection.appendChild(raw_projection);
        raw_projection.appendChild(doc.createTextNode(MP7DocumentBuilder.append(new StringBuffer(), projection).toString()));
        if (this.listASBP.size() > 1) {
            Iterator<Msg> i = this.listASBP.iterator();
            i.next();
            while (i.hasNext()) {
                msg = (MsgAudioSpectrumBasisProjection)i.next();
                raw_basis.appendChild(doc.createComment(NEXT_BLOCK));
                raw_basis.appendChild(doc.createTextNode(MP7DocumentBuilder.append(new StringBuffer(NEWLINE), msg.getBasis()).toString()));
                raw_projection.appendChild(doc.createComment(NEXT_BLOCK));
                raw_projection.appendChild(doc.createTextNode(MP7DocumentBuilder.append(new StringBuffer(NEWLINE), msg.getProjection()).toString()));
            }
        }
    }

    private void addASC(Document doc, Element audio_segment) {
        if (this.listASC.isEmpty()) {
            return;
        }
        Collections.sort(this.listASC);
        MsgAudioSpectrumCentroid msg = (MsgAudioSpectrumCentroid)this.listASC.get(0);
        Element audio_descriptor = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "AudioDescriptor");
        audio_descriptor.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "AudioSpectrumCentroidType");
        audio_segment.appendChild(audio_descriptor);
        Element sos = MP7DocumentBuilder.getSeriesOfScalar(doc, msg.hopsize, this.listASC.size());
        audio_descriptor.appendChild(sos);
        Element raw = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Raw");
        sos.appendChild(raw);
        StringBuffer buffer = new StringBuffer();
        Iterator<Msg> i = this.listASC.iterator();
        while (i.hasNext()) {
            buffer.append("" + MP7DocumentBuilder.format(((MsgAudioSpectrumCentroid)i.next()).centroid));
            buffer.append(SPACE);
        }
        raw.appendChild(doc.createTextNode(buffer.toString()));
    }

    private void addASS(Document doc, Element audio_segment) {
        if (this.listASS.isEmpty()) {
            return;
        }
        Collections.sort(this.listASS);
        MsgAudioSpectrumSpread msg = (MsgAudioSpectrumSpread)this.listASS.get(0);
        Element audio_descriptor = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "AudioDescriptor");
        audio_descriptor.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "AudioSpectrumSpreadType");
        audio_segment.appendChild(audio_descriptor);
        Element sos = MP7DocumentBuilder.getSeriesOfScalar(doc, msg.hopsize, this.listASS.size());
        audio_descriptor.appendChild(sos);
        Element raw = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Raw");
        sos.appendChild(raw);
        StringBuffer buffer = new StringBuffer();
        Iterator<Msg> i = this.listASS.iterator();
        while (i.hasNext()) {
            buffer.append("" + MP7DocumentBuilder.format(((MsgAudioSpectrumSpread)i.next()).spread));
            buffer.append(SPACE);
        }
        raw.appendChild(doc.createTextNode(buffer.toString()));
    }

    private void addASD(Document doc, Element audio_segment) {
        if (this.listASD.isEmpty()) {
            return;
        }
        doc.getDocumentElement().setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:mpeg7hc", "de:crysandt:mpeg7");
        this.schema_location.put("de:crysandt:mpeg7", "http://www.ient.rwth-aachen.de/team/crysandt/mpeg7mds/mpeg7hc.xsd");
        Collections.sort(this.listASD);
        MsgAudioSpectrumDistribution msg = (MsgAudioSpectrumDistribution)this.listASD.get(0);
        Element audio_descriptor = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "AudioDescriptor");
        audio_descriptor.setAttribute("loEdge", "" + msg.lo_edge);
        audio_descriptor.setAttribute("hiEdge", "" + msg.hi_edge);
        audio_descriptor.setAttribute("octaveResolution", MP7DocumentBuilder.getOctaveResolution(msg.resolution));
        audio_descriptor.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "mpeg7hc:AudioSpectrumDistributionType");
        audio_segment.appendChild(audio_descriptor);
        int rows = this.listASD.size();
        int cols = msg.getDistributionLength();
        Element sov = MP7DocumentBuilder.getSeriesOfVector(doc, msg.hopsize, rows, cols);
        audio_descriptor.appendChild(sov);
        Element raw = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Raw");
        raw.setAttributeNS("urn:mpeg:mpeg7:schema:2001", "mpeg7:dim", rows + SPACE + cols);
        sov.appendChild(raw);
        StringBuffer buffer = new StringBuffer();
        Iterator<Msg> i = this.listASD.iterator();
        while (i.hasNext()) {
            float[] distribution = ((MsgAudioSpectrumDistribution)i.next()).getDistribution();
            assert (distribution.length == cols);
            MP7DocumentBuilder.append(buffer, distribution);
            buffer.append(NEWLINE);
        }
        raw.appendChild(doc.createTextNode(buffer.toString()));
    }

    private void addASE(Document doc, Element audio_segment) {
        if (this.listASE.isEmpty()) {
            return;
        }
        Collections.sort(this.listASE);
        MsgAudioSpectrumEnvelope msg = (MsgAudioSpectrumEnvelope)this.listASE.get(0);
        Element audio_descriptor = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "AudioDescriptor");
        audio_descriptor.setAttribute("loEdge", "" + msg.lo_edge);
        audio_descriptor.setAttribute("hiEdge", "" + msg.hi_edge);
        audio_descriptor.setAttribute("octaveResolution", MP7DocumentBuilder.getOctaveResolution(msg.resolution));
        audio_descriptor.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "AudioSpectrumEnvelopeType");
        if (msg.db_scale) {
            audio_descriptor.setAttribute("dbScale", "true");
        }
        switch (msg.normalize) {
            case 0: {
                break;
            }
            case 2: {
                audio_descriptor.setAttribute("normalize", "power");
                break;
            }
            case 1: {
                audio_descriptor.setAttribute("normalize", "norm2");
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (msg.db_scale || msg.normalize != 0) {
            this.schema_location.put("urn:mpeg:mpeg7:schema:2001", "http://www.ient.rwth-aachen.de/team/crysandt/mpeg7mds/mpeg7patched.xml");
        }
        audio_segment.appendChild(audio_descriptor);
        int rows = this.listASE.size();
        int cols = msg.getEnvelopeLength();
        Element sov = MP7DocumentBuilder.getSeriesOfVector(doc, msg.hopsize, rows, cols);
        audio_descriptor.appendChild(sov);
        Element raw = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Raw");
        raw.setAttributeNS("urn:mpeg:mpeg7:schema:2001", "mpeg7:dim", rows + SPACE + cols);
        sov.appendChild(raw);
        StringBuffer buffer = new StringBuffer();
        Iterator<Msg> i = this.listASE.iterator();
        while (i.hasNext()) {
            float[] envelope = ((MsgAudioSpectrumEnvelope)i.next()).getEnvelope();
            assert (envelope.length == cols);
            for (int c = 0; c < cols; ++c) {
                buffer.append(envelope[c]);
                buffer.append(SPACE);
            }
            buffer.append(NEWLINE);
        }
        raw.appendChild(doc.createTextNode(buffer.toString()));
    }

    private void addASF(Document doc, Element audio_segment) {
        if (this.listASF.isEmpty()) {
            return;
        }
        Collections.sort(this.listASF);
        MsgAudioSpectrumFlatness msg = (MsgAudioSpectrumFlatness)this.listASF.get(0);
        Element audio_descriptor = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "AudioDescriptor");
        audio_descriptor.setAttribute("loEdge", "" + msg.lo_edge);
        audio_descriptor.setAttribute("hiEdge", "" + msg.hi_edge);
        audio_descriptor.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "AudioSpectrumFlatnessType");
        audio_segment.appendChild(audio_descriptor);
        int rows = this.listASF.size();
        int cols = msg.getFlatnessLength();
        Element sov = MP7DocumentBuilder.getSeriesOfVector(doc, msg.hopsize, rows, cols);
        audio_descriptor.appendChild(sov);
        Element raw = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Raw");
        raw.setAttributeNS("urn:mpeg:mpeg7:schema:2001", "mpeg7:dim", rows + SPACE + cols);
        sov.appendChild(raw);
        StringBuffer buffer = new StringBuffer();
        Iterator<Msg> i = this.listASF.iterator();
        while (i.hasNext()) {
            float[] flatness = ((MsgAudioSpectrumFlatness)i.next()).getFlatness();
            assert (flatness.length == cols);
            for (int c = 0; c < cols; ++c) {
                buffer.append(flatness[c]);
                buffer.append(SPACE);
            }
            buffer.append(NEWLINE);
        }
        raw.appendChild(doc.createTextNode(buffer.toString()));
    }

    private void addAW(Document doc, Element audio_segment) {
        if (this.listAW.isEmpty()) {
            return;
        }
        Collections.sort(this.listAW);
        MsgAudioWaveform msgAudioWaveform = (MsgAudioWaveform)this.listAW.get(0);
        Element audio_descriptor = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "AudioDescriptor");
        audio_descriptor.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "AudioWaveformType");
        audio_segment.appendChild(audio_descriptor);
        Element sos = MP7DocumentBuilder.getSeriesOfScalar(doc, msgAudioWaveform.hopsize, this.listAW.size());
        audio_descriptor.appendChild(sos);
        StringBuffer buffer_min = new StringBuffer();
        StringBuffer buffer_max = new StringBuffer();
        for (MsgAudioWaveform msgAudioWaveform2 : this.listAW) {
            buffer_min.append(MP7DocumentBuilder.format(msgAudioWaveform2.min));
            buffer_min.append(SPACE);
            buffer_max.append(MP7DocumentBuilder.format(msgAudioWaveform2.max));
            buffer_max.append(SPACE);
        }
        Element min = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Min");
        min.appendChild(doc.createTextNode(buffer_min.toString().trim()));
        sos.appendChild(min);
        Element max = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Max");
        max.appendChild(doc.createTextNode(buffer_max.toString().trim()));
        sos.appendChild(max);
    }

    private void addHSC(Document doc, Element audio_segment) {
        if (this.msgHSC == null) {
            return;
        }
        this.addHS(doc, audio_segment, "HarmonicSpectralCentroidType", this.msgHSC.hsc);
    }

    private void addHSD(Document doc, Element audio_segment) {
        if (this.msgHSD == null) {
            return;
        }
        this.addHS(doc, audio_segment, "HarmonicSpectralDeviationType", this.msgHSD.hsd);
    }

    private void addHSS(Document doc, Element audio_segment) {
        if (this.msgHSS == null) {
            return;
        }
        this.addHS(doc, audio_segment, "HarmonicSpectralSpreadType", this.msgHSS.hss);
    }

    private void addHSV(Document doc, Element audio_segment) {
        if (this.msgHSV == null) {
            return;
        }
        this.addHS(doc, audio_segment, "HarmonicSpectralVariationType", this.msgHSV.hsv);
    }

    private void addHS(Document doc, Element audio_segment, String type, float value) {
        Element audio_descriptor = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "AudioDescriptor");
        audio_descriptor.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", type);
        audio_segment.appendChild(audio_descriptor);
        Element scalar = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Scalar");
        audio_descriptor.appendChild(scalar);
        scalar.appendChild(doc.createTextNode("" + value));
    }

    private void addAS(Document doc, Element audio_segment) {
        if (this.listAS.isEmpty()) {
            return;
        }
        Collections.sort(this.listAS);
        MsgAudioSignature msgAudioSignature = (MsgAudioSignature)this.listAS.get(0);
        Element audio_ds = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "AudioDescriptionScheme");
        audio_ds.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "AudioSignatureType");
        audio_segment.appendChild(audio_ds);
        Element flatness = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Flatness");
        flatness.setAttribute("loEdge", "" + msgAudioSignature.lo_edge);
        flatness.setAttribute("hiEdge", "" + msgAudioSignature.hi_edge);
        audio_ds.appendChild(flatness);
        Element sov = MP7DocumentBuilder.getSeriesOfVector(doc, msgAudioSignature.hopsize, this.listAS.size(), msgAudioSignature.getLength());
        flatness.appendChild(sov);
        Element scaling = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Scaling");
        scaling.setAttribute("numOfElements", "" + this.listAS.size());
        scaling.setAttribute("ratio", "" + msgAudioSignature.decimation);
        sov.appendChild(scaling);
        Element mean = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Mean");
        Element var = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Variance");
        String dim = this.listAS.size() + SPACE + msgAudioSignature.getLength();
        mean.setAttributeNS("urn:mpeg:mpeg7:schema:2001", "mpeg7:dim", dim);
        var.setAttributeNS("urn:mpeg:mpeg7:schema:2001", "mpeg7:dim", dim);
        sov.appendChild(mean);
        sov.appendChild(var);
        StringBuffer buffer_mean = new StringBuffer();
        StringBuffer buffer_var = new StringBuffer();
        for (MsgAudioSignature msgAudioSignature2 : this.listAS) {
            float[] m = msgAudioSignature2.getFlatnessMean();
            float[] v = msgAudioSignature2.getFlatnessVariance();
            for (int n = 0; n < m.length; ++n) {
                buffer_mean.append(MP7DocumentBuilder.format(m[n])).append(SPACE);
                buffer_var.append(MP7DocumentBuilder.format(v[n])).append(SPACE);
            }
            buffer_mean.append(NEWLINE);
            buffer_var.append(NEWLINE);
        }
        mean.appendChild(doc.createTextNode(buffer_mean.toString()));
        var.appendChild(doc.createTextNode(buffer_var.toString()));
    }

    private void addSoundModel(Document doc) {
        int i;
        if (this.msg_sound_model == null) {
            return;
        }
        Element mpeg7 = doc.getDocumentElement();
        assert (mpeg7.getNodeName().equals("Mpeg7"));
        Element description = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Description");
        description.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "ModelDescriptionType");
        mpeg7.appendChild(description);
        HMM hmm = this.msg_sound_model.hmm;
        Element sound_model = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Model");
        sound_model.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "SoundModelType");
        sound_model.setAttribute("numOfStates", "" + hmm.N);
        description.appendChild(sound_model);
        float[] init = hmm.getInit();
        if (init != null) {
            Element initial = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Initial");
            sound_model.appendChild(initial);
            initial.setAttributeNS("urn:mpeg:mpeg7:schema:2001", "mpeg7:dim", "1 " + init.length);
            StringBuffer buffer = new StringBuffer();
            for (int i2 = 0; i2 < init.length; ++i2) {
                buffer.append(init[i2]).append(SPACE);
            }
            initial.appendChild(doc.createTextNode(buffer.toString()));
        }
        float[][] trans = hmm.getTransitions();
        Element transitions = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Transitions");
        transitions.setAttributeNS("urn:mpeg:mpeg7:schema:2001", "mpeg7:dim", trans.length + SPACE + trans.length);
        sound_model.appendChild(transitions);
        StringBuffer buffer_trans = new StringBuffer();
        for (i = 0; i < trans.length; ++i) {
            float[] row = trans[i];
            for (int j = 0; j < row.length; ++j) {
                buffer_trans.append(row[j]).append(SPACE);
            }
            buffer_trans.append(NEWLINE);
        }
        transitions.appendChild(doc.createTextNode(buffer_trans.toString()));
        int i_max = init.length;
        for (i = 0; i < i_max; ++i) {
            Element state = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "State");
            sound_model.appendChild(state);
            Element label = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Label");
            state.appendChild(label);
            String state_i = "State" + i;
            Element term = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Term");
            term.setAttribute("termID", state_i);
            label.appendChild(term);
            Element name = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Name");
            name.appendChild(doc.createTextNode(state_i));
            term.appendChild(name);
        }
        Element descriptor_model = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "DescriptorModel");
        sound_model.appendChild(descriptor_model);
        Element descriptor = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Descriptor");
        descriptor.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "AudioSpectrumProjectionType");
        descriptor_model.appendChild(descriptor);
        Element sov = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "SeriesOfVector");
        sov.setAttribute("totalNumOfSamples", "1");
        descriptor.appendChild(sov);
        Element field = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Field");
        field.appendChild(doc.createTextNode("SeriesOfVector"));
        descriptor_model.appendChild(field);
        int i_max2 = hmm.N;
        for (int i3 = 0; i3 < i_max2; ++i3) {
            Element od = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "ObservationDistribution");
            od.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "GaussianDistributionType");
            sound_model.appendChild(od);
            GaussianDistribution gd = hmm.getDist(i3);
            float[] gd_mean = gd.getCenter();
            Element mean = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Mean");
            mean.setAttributeNS("urn:mpeg:mpeg7:schema:2001", "mpeg7:dim", "1 " + gd_mean.length);
            od.appendChild(mean);
            StringBuffer buffer_mean = new StringBuffer();
            int size = gd.getLength();
            for (int n = 0; n < size; ++n) {
                buffer_mean.append(gd_mean[n]).append(SPACE);
            }
            mean.appendChild(doc.createTextNode(buffer_mean.toString()));
            float[][] gd_cov_inv = gd.getCovarianceInverse();
            Element cov_inv = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "CovarianceInverse");
            cov_inv.setAttributeNS("urn:mpeg:mpeg7:schema:2001", "mpeg7:dim", gd_cov_inv.length + SPACE + gd_cov_inv.length);
            od.appendChild(cov_inv);
            StringBuffer buffer_cov_inv = new StringBuffer();
            for (int n = 0; n < gd_cov_inv.length; ++n) {
                float[] row = gd_cov_inv[n];
                for (int m = 0; m < row.length; ++m) {
                    buffer_cov_inv.append(row[m]).append(SPACE);
                }
                buffer_cov_inv.append(NEWLINE);
            }
            cov_inv.appendChild(doc.createTextNode(buffer_cov_inv.toString()));
        }
        Element sound_class_label = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "SoundClassLabel");
        sound_model.appendChild(sound_class_label);
        Element name = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Name");
        name.appendChild(doc.createTextNode(this.msg_sound_model.label));
        sound_class_label.appendChild(name);
        Element spectrum_basis = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "SpectrumBasis");
        spectrum_basis.setAttribute("loEdge", "" + this.msg_sound_model.lo_edge);
        spectrum_basis.setAttribute("hiEdge", "" + this.msg_sound_model.hi_edge);
        String resolution = this.msg_sound_model.resolution >= 1.0f ? "" + (int)this.msg_sound_model.resolution : "1/" + (int)(1.0f / this.msg_sound_model.resolution);
        spectrum_basis.setAttribute("octaveResolution", resolution);
        sound_model.appendChild(spectrum_basis);
        sov = MP7DocumentBuilder.getSeriesOfVector(doc, this.msg_sound_model.hopsize, 1, 1);
        spectrum_basis.appendChild(sov);
        float[][] basis = this.msg_sound_model.audio_spectrum_basis;
        Element raw = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Raw");
        int rows = basis.length;
        int cols = basis[0].length;
        raw.setAttributeNS("urn:mpeg:mpeg7:schema:2001", "mpeg7:dim", rows + SPACE + cols);
        sov.appendChild(raw);
        StringBuffer buffer_raw = new StringBuffer();
        for (int m = 0; m < basis.length; ++m) {
            float[] row = basis[m];
            for (int n = 0; n < row.length; ++n) {
                buffer_raw.append(row[n]).append(SPACE);
            }
            buffer_raw.append(NEWLINE);
        }
        raw.appendChild(doc.createTextNode(buffer_raw.toString()));
    }

    private void addLAT(Document doc, Element audio_segment) {
        if (this.msgLAT == null) {
            return;
        }
        Element audio_descriptor = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "AudioDescriptor");
        audio_descriptor.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "LogAttackTimeType");
        audio_segment.appendChild(audio_descriptor);
        Element scalar = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Scalar");
        audio_descriptor.appendChild(scalar);
        scalar.appendChild(doc.createTextNode(MP7DocumentBuilder.format(this.msgLAT.lat)));
    }

    private void addSC(Document doc, Element audio_segment) {
        if (this.msgSC == null) {
            return;
        }
        Element audio_descriptor = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "AudioDescriptor");
        audio_descriptor.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "SpectralCentroidType");
        audio_segment.appendChild(audio_descriptor);
        Element scalar = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Scalar");
        audio_descriptor.appendChild(scalar);
        scalar.appendChild(doc.createTextNode(MP7DocumentBuilder.format(this.msgSC.spectralCentroid)));
    }

    private void addTC(Document doc, Element audio_segment) {
        if (this.msgTC == null) {
            return;
        }
        Element audio_descriptor = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "AudioDescriptor");
        audio_descriptor.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "TemporalCentroidType");
        audio_segment.appendChild(audio_descriptor);
        Element scalar = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "Scalar");
        audio_descriptor.appendChild(scalar);
        scalar.appendChild(doc.createTextNode(MP7DocumentBuilder.format(this.msgTC.temporalCentroid)));
    }

    public static Element getSeriesOfScalar(Document doc, int hop_size, int num_of_samples) {
        Element sos = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "SeriesOfScalar");
        sos.setAttribute("hopSize", MP7DocumentBuilder.getMediaDuration(hop_size));
        sos.setAttribute("totalNumOfSamples", "" + num_of_samples);
        return sos;
    }

    public static Element getSeriesOfVector(Document doc, int hop_size, int rows, int cols) {
        Element sov = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "SeriesOfVector");
        sov.setAttribute("hopSize", MP7DocumentBuilder.getMediaDuration(hop_size));
        sov.setAttribute("totalNumOfSamples", "" + rows * cols);
        sov.setAttribute("vectorSize", "" + cols);
        return sov;
    }

    private static String getMediaDuration(int time) {
        assert (time > 0);
        int msec = time % 1000;
        int sec = (time /= 1000) % 60;
        int min = (time /= 60) % 60;
        StringBuffer duration = new StringBuffer("PT");
        if (min > 0) {
            duration.append(min);
            duration.append("M");
        }
        if (sec > 0 || min > 0) {
            duration.append(sec);
            duration.append("S");
        }
        if (msec > 0) {
            duration.append(msec);
            duration.append("N1000F");
        }
        return duration.toString();
    }

    private static String getOctaveResolution(float resolution) {
        if (resolution >= 1.0f) {
            return "" + Math.round(resolution);
        }
        return "1/" + Math.round(1.0f / resolution);
    }

    private static StringBuffer append(StringBuffer buffer, float[] vector) {
        if (vector != null && vector.length > 0) {
            buffer.append(vector[0]);
            for (int i = 1; i < vector.length; ++i) {
                buffer.append(SPACE).append(vector[i]);
            }
        }
        return buffer;
    }

    private static StringBuffer append(StringBuffer buffer, float[][] matrix) {
        if (matrix != null && matrix.length > 0) {
            for (int i = 0; i < matrix.length; ++i) {
                MP7DocumentBuilder.append(buffer, matrix[i]);
                buffer.append(NEWLINE);
            }
        }
        return buffer;
    }

    private static String format(float x) {
        return "" + x;
    }

    public static Document encode(AudioInputStream ais, Config config) throws ParserConfigurationException {
        float[] audio;
        AudioInFloatSampled audioin = new AudioInFloatSampled(ais);
        MP7DocumentBuilder mp7out = new MP7DocumentBuilder();
        Encoder encoder = new Encoder(audioin.getSampleRate(), mp7out, config);
        while ((audio = audioin.get()) != null) {
            if (!audioin.isMono()) {
                audio = AudioInFloat.getMono(audio);
            }
            encoder.put(audio);
        }
        encoder.flush();
        return mp7out.getDocument();
    }

    public static void main(String[] args) {
        try {
            float[] audio;
            File file = new File(args[0]);
            AudioInFloatSampled audioin = new AudioInFloatSampled(file);
            MP7DocumentBuilder mp7out = new MP7DocumentBuilder();
            mp7out.addSchemaLocation("urn:mpeg:mpeg7:schema:2001", "http://www.ient.rwth-aachen.de/team/crysandt/mpeg7mds/mpeg7ver1.xsd");
            MediaInformation mi = MediaHelper.createMediaInformation();
            MediaHelper.setMediaLocation(mi, file.toURI());
            mp7out.setMediaInformation(mi);
            Encoder encoder = null;
            if (args.length == 2) {
                Config config = ConfigXML.parse(new FileReader(args[1]));
                encoder = new Encoder(audioin.getSampleRate(), mp7out, config);
            } else {
                encoder = new Encoder(audioin.getSampleRate(), mp7out);
            }
            encoder.addTimeElapsedListener(new Ticker(System.err));
            while ((audio = audioin.get()) != null) {
                if (!audioin.isMono()) {
                    audio = AudioInFloat.getMono(audio);
                }
                encoder.put(audio);
            }
            encoder.flush();
            Document mp7 = mp7out.getDocument();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(mp7), new StreamResult(System.out));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.exit(-1);
        }
    }
}

