/*
 * Decompiled with CFR 0.152.
 */
package de.crysandt.audio.mpeg7audio;

import de.crysandt.audio.mpeg7audio.msgs.Msg;
import de.crysandt.audio.mpeg7audio.msgs.MsgAudioSpectrumBasisProjection;
import de.crysandt.audio.mpeg7audio.msgs.MsgAudioSpectrumEnvelope;
import de.crysandt.audio.mpeg7audio.msgs.MsgListener;
import de.crysandt.audio.mpeg7audio.msgs.MsgSpeaker;
import de.crysandt.math.Function;
import de.crysandt.math.LinAlg;
import de.crysandt.math.SVD;
import java.util.ArrayList;

public class AudioSpectrumBasisProjection
extends MsgSpeaker
implements MsgListener {
    private final int NUM_FRAMES;
    private final int NUM_IC;
    private final ArrayList<float[]> ase_list = new ArrayList();
    private MsgAudioSpectrumEnvelope msg_first = null;

    AudioSpectrumBasisProjection(int frames, int num_ic) {
        this.NUM_FRAMES = frames;
        this.NUM_IC = num_ic;
    }

    public void receivedMsg(Msg m) {
        if (m instanceof MsgAudioSpectrumEnvelope) {
            this.receivedMsg((MsgAudioSpectrumEnvelope)m);
        }
    }

    private void receivedMsg(MsgAudioSpectrumEnvelope m) {
        if (this.msg_first == null) {
            this.msg_first = m;
        }
        this.ase_list.add(m.getEnvelope());
        if (this.NUM_FRAMES > 0 && this.ase_list.size() == this.NUM_FRAMES) {
            this.calculate();
        }
    }

    private void calculate() {
        if (this.ase_list.isEmpty()) {
            return;
        }
        float[] first = this.ase_list.get(0);
        if (first.length > this.ase_list.size()) {
            return;
        }
        Calculate calc = new Calculate();
        this.ase_list.clear();
        this.send(new MsgAudioSpectrumBasisProjection(this.msg_first.time, this.msg_first.hopsize * this.NUM_FRAMES, this.msg_first.hopsize, this.msg_first.lo_edge, this.msg_first.hi_edge, this.msg_first.resolution, calc.getBasis(), calc.getProjection()));
    }

    public void flush() {
        if (this.NUM_FRAMES <= 0) {
            this.calculate();
        }
        this.ase_list.clear();
        super.flush();
    }

    public static float[][] getASP(float[][] asb, float[][] ase) {
        int j;
        float[][] ase_log = new float[ase.length][];
        float[] ase_log_sum = new float[ase.length];
        for (int i = 0; i < ase.length; ++i) {
            float[] row = ase[i];
            ase_log[i] = new float[row.length];
            float[] row_log = ase_log[i];
            double sum = 0.0;
            for (j = 0; j < row.length; ++j) {
                float row_log_j = row_log[j] = 10.0f / (float)Function.LOG10 * (float)Math.log(row[j] + Float.MIN_VALUE);
                sum += (double)(row_log_j * row_log_j);
            }
            sum = Math.sqrt(sum);
            ase_log_sum[i] = (float)sum;
            j = 0;
            while (j < row_log.length) {
                int n = j++;
                row_log[n] = (float)((double)row_log[n] / sum);
            }
        }
        asb = LinAlg.transpose(asb);
        int cols = asb.length;
        float[][] asp = new float[ase.length][cols + 1];
        for (int i = 0; i < asp.length; ++i) {
            float[] ase_log_row = ase_log[i];
            float[] asp_row = asp[i];
            asp_row[0] = ase_log_sum[i];
            for (j = 0; j < asb.length; ++j) {
                asp_row[j + 1] = LinAlg.dot(ase_log_row, asb[j]);
            }
        }
        return asp;
    }

    private class Calculate {
        private float[][] basisFunctionMatrix;
        private float[][] projectionMatrix;

        public Calculate() {
            int i;
            int m = AudioSpectrumBasisProjection.this.ase_list.size();
            int n = ((float[])AudioSpectrumBasisProjection.this.ase_list.get(0)).length;
            float[][] X = new float[m][];
            float[][] ase = new float[m][];
            AudioSpectrumBasisProjection.this.ase_list.toArray((T[])ase);
            float[] l2NormValues = new float[m];
            for (int row = 0; row < ase.length; ++row) {
                int i2;
                float[] ase_row = ase[row];
                X[row] = new float[ase_row.length];
                float[] X_row = X[row];
                float norm = 0.0f;
                for (i2 = 0; i2 < X_row.length; ++i2) {
                    X_row[i2] = 10.0f * Function.log10(ase_row[i2] + Float.MIN_VALUE);
                    norm += X_row[i2] * X_row[i2];
                }
                l2NormValues[row] = norm = (float)Math.sqrt(norm);
                i2 = 0;
                while (i2 < X_row.length) {
                    int n2 = i2++;
                    X_row[n2] = X_row[n2] / norm;
                }
            }
            SVD svd = new SVD(X, m, n);
            float[][] S = svd.getS();
            float[][] V = svd.getV();
            float sumFull = 0.0f;
            float sumReduced = 0.0f;
            for (i = 0; i < n; ++i) {
                if (i < AudioSpectrumBasisProjection.this.NUM_IC) {
                    sumReduced += S[i][i];
                }
                sumFull += S[i][i];
            }
            this.basisFunctionMatrix = new float[n][AudioSpectrumBasisProjection.this.NUM_IC];
            for (i = 0; i < n; ++i) {
                System.arraycopy(V[i], 0, this.basisFunctionMatrix[i], 0, AudioSpectrumBasisProjection.this.NUM_IC);
            }
            this.projectionMatrix = AudioSpectrumBasisProjection.getASP(this.basisFunctionMatrix, ase);
        }

        public float[][] getBasis() {
            return this.basisFunctionMatrix;
        }

        public float[][] getProjection() {
            return this.projectionMatrix;
        }
    }
}

