/*
 * Decompiled with CFR 0.152.
 */
package de.crysandt.audio;

import javax.sound.sampled.AudioFormat;

public abstract class AudioInFloat {
    public boolean isStereo() {
        return !this.isMono();
    }

    public static float[] getLeft(float[] signal) {
        float[] left = new float[signal.length / 2];
        int i = 0;
        int j = 0;
        while (i < left.length) {
            left[i] = signal[j];
            ++i;
            j += 2;
        }
        return left;
    }

    public static float[] getRight(float[] signal) {
        float[] right = new float[(signal.length + 1) / 2];
        int i = 0;
        int j = 1;
        while (i < right.length) {
            right[i] = signal[j];
            ++i;
            j += 2;
        }
        return right;
    }

    public static float[] getMono(float[] signal) {
        float[] mono = new float[signal.length / 2];
        int i = 0;
        int j = 0;
        while (i < mono.length) {
            mono[i] = 0.5f * (signal[j] + signal[j + 1]);
            ++i;
            j += 2;
        }
        return mono;
    }

    public abstract float[] get();

    public abstract float getSampleRate();

    public abstract boolean isMono();

    public abstract AudioFormat getSourceFormat();
}

