/*
 * Decompiled with CFR 0.152.
 */
package org.spantus.mpeg7.io;

import de.crysandt.audio.mpeg7audio.MP7DocumentBuilder;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.spantus.core.extractor.IExtractorConfig;
import org.spantus.exception.ProcessingException;
import org.spantus.mpeg7.config.Mpeg7ConfigUtil;
import org.spantus.mpeg7.io.Mpeg7Writer;
import org.w3c.dom.Document;

public class Mpeg7WriterImpl
implements Mpeg7Writer {
    public void write(URL inUrl, File outFile, IExtractorConfig conf) throws ProcessingException {
        try {
            Document mpeg7doc = MP7DocumentBuilder.encode(AudioSystem.getAudioInputStream(inUrl), Mpeg7ConfigUtil.getConfig(conf));
            MP7DocumentBuilder mp7out = new MP7DocumentBuilder();
            mp7out.addSchemaLocation("urn:mpeg:mpeg7:schema:2001", "http://www.ient.rwth-aachen.de/team/crysandt/mpeg7mds/mpeg7ver1.xsd");
            this.write(mpeg7doc, outFile);
        }
        catch (ParserConfigurationException e) {
            throw new ProcessingException((Throwable)e);
        }
        catch (UnsupportedAudioFileException e) {
            throw new ProcessingException((Throwable)e);
        }
        catch (IOException e) {
            throw new ProcessingException((Throwable)e);
        }
    }

    public void write(Document mpeg7doc, File outFile) throws ProcessingException {
        Transformer transformer;
        MP7DocumentBuilder mp7out = new MP7DocumentBuilder();
        mp7out.addSchemaLocation("urn:mpeg:mpeg7:schema:2001", "http://www.ient.rwth-aachen.de/team/crysandt/mpeg7mds/mpeg7ver1.xsd");
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        StreamResult result = null;
        result = outFile == null ? new StreamResult(System.out) : new StreamResult(outFile);
        try {
            transformer.transform(new DOMSource(mpeg7doc), result);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }
}

