/*
 * Decompiled with CFR 0.152.
 */
package org.spantus.mpeg7.extractors.impl;

import java.util.List;
import org.spantus.core.FrameValues;
import org.spantus.core.FrameVectorValues;
import org.spantus.core.extractor.IExtractorConfig;
import org.spantus.mpeg7.extractors.AbstractMpeg7Extractor;

public class AudioWaveformExtractor
extends AbstractMpeg7Extractor {
    public static final String EXTRACTOR_NAME = "AudioWaveform";

    public FrameVectorValues calculateWindow(FrameValues window) {
        FrameVectorValues calculatedValues = this.createFrameValueVector();
        Float min = null;
        Float max = null;
        for (Float val : window) {
            min = this.min(min, val);
            max = this.max(max, val);
        }
        FrameValues fv = new FrameValues();
        fv.add(min);
        fv.add(max);
        calculatedValues.add((List)fv);
        return calculatedValues;
    }

    Float min(Float a, Float b) {
        if (a == null && b == null) {
            return null;
        }
        if (a == null && b != null) {
            return a;
        }
        if (a != null && b == null) {
            return b;
        }
        return Float.valueOf(Math.min(a.floatValue(), b.floatValue()));
    }

    Float max(Float a, Float b) {
        if (a == null && b == null) {
            return null;
        }
        if (a == null && b != null) {
            return a;
        }
        if (a != null && b == null) {
            return b;
        }
        return Float.valueOf(Math.max(a.floatValue(), b.floatValue()));
    }

    public String getName() {
        return EXTRACTOR_NAME;
    }

    public IExtractorConfig getConfig() {
        return null;
    }

    public float getExtractorSampleRate() {
        return 0.0f;
    }

    public void setConfig(IExtractorConfig config) {
    }
}

