/*
 * Decompiled with CFR 0.152.
 */
package org.spantus.mpeg7.config;

import de.crysandt.audio.mpeg7audio.ConfigDefault;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.spantus.core.extractor.IExtractorConfig;
import org.spantus.core.extractor.IExtractorInputReader;
import org.spantus.mpeg7.Mpeg7ExtractorEnum;
import org.spantus.mpeg7.config.Mpeg7ExtractorConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Mpeg7ConfigUtil {
    static Map<Mpeg7ExtractorEnum, String> enumMapping = new HashMap<Mpeg7ExtractorEnum, String>();

    public static ConfigDefault getConfig(IExtractorConfig mp7conf) {
        ConfigDefault conf = new ConfigDefault();
        if (mp7conf == null) {
            return conf;
        }
        conf.enableAll(false);
        conf.setValue("AudioPower", "logScale", true);
        for (Mpeg7ExtractorEnum extractor : Mpeg7ExtractorEnum.values()) {
            conf.setValue(Mpeg7ConfigUtil.getEnumMapping(extractor), "enable", mp7conf.getExtractors().contains(extractor.name()));
        }
        if (mp7conf.getExtractors().contains(Mpeg7ExtractorEnum.AudioSpectrumBasis.name())) {
            conf.setValue(Mpeg7ConfigUtil.getEnumMapping(Mpeg7ExtractorEnum.AudioSpectrumBasis), "enable", true);
        } else if (mp7conf.getExtractors().contains(Mpeg7ExtractorEnum.AudioSpectrumProjection.name())) {
            conf.setValue(Mpeg7ConfigUtil.getEnumMapping(Mpeg7ExtractorEnum.AudioSpectrumProjection), "enable", true);
        }
        if (mp7conf.getExtractors().contains(Mpeg7ExtractorEnum.AudioSpectrumCentroid.name())) {
            conf.setValue(Mpeg7ConfigUtil.getEnumMapping(Mpeg7ExtractorEnum.AudioSpectrumCentroid), "enable", true);
        } else if (mp7conf.getExtractors().contains(Mpeg7ExtractorEnum.AudioSpectrumSpread.name())) {
            conf.setValue(Mpeg7ConfigUtil.getEnumMapping(Mpeg7ExtractorEnum.AudioSpectrumSpread), "enable", true);
        }
        if (mp7conf.getExtractors().contains(Mpeg7ExtractorEnum.AudioHarmonicityUpperLimit.name())) {
            conf.setValue(Mpeg7ConfigUtil.getEnumMapping(Mpeg7ExtractorEnum.AudioHarmonicityHarmonicRatio), "enable", true);
        } else if (mp7conf.getExtractors().contains(Mpeg7ExtractorEnum.AudioHarmonicityHarmonicRatio.name())) {
            conf.setValue(Mpeg7ConfigUtil.getEnumMapping(Mpeg7ExtractorEnum.AudioHarmonicityHarmonicRatio), "enable", true);
        }
        return conf;
    }

    public static String getEnumMapping(Mpeg7ExtractorEnum extractor) {
        if (enumMapping.containsKey((Object)extractor)) {
            return enumMapping.get((Object)extractor);
        }
        return extractor.name();
    }

    public static IExtractorConfig createConfig(Mpeg7ExtractorEnum[] extractors) {
        Mpeg7ExtractorConfig conf = new Mpeg7ExtractorConfig();
        for (Mpeg7ExtractorEnum mpeg7extrEnum : extractors) {
            conf.getExtractors().add(mpeg7extrEnum.name());
        }
        return conf;
    }

    public static IExtractorConfig createConfig(Collection<Mpeg7ExtractorEnum> extractors) {
        Mpeg7ExtractorConfig conf = new Mpeg7ExtractorConfig();
        for (Mpeg7ExtractorEnum mpeg7extrEnum : extractors) {
            conf.getExtractors().add(mpeg7extrEnum.name());
        }
        return conf;
    }

    public static Set<Mpeg7ExtractorEnum> convertExtractorsEnum(Set<String> extrStrs) {
        HashSet<Mpeg7ExtractorEnum> mp7extrs = new HashSet<Mpeg7ExtractorEnum>();
        for (String string : extrStrs) {
            mp7extrs.add(Mpeg7ExtractorEnum.valueOf(string));
        }
        return mp7extrs;
    }

    public static Set<String> convertExtractors(Set<Mpeg7ExtractorEnum> mp7extrs) {
        HashSet<String> extrStrs = new HashSet<String>();
        for (Mpeg7ExtractorEnum mp7extr : mp7extrs) {
            extrStrs.add(mp7extr.name());
        }
        return extrStrs;
    }

    public static void postprocess(IExtractorInputReader reader, IExtractorConfig conf) {
        Set<Mpeg7ExtractorEnum> extrs = Mpeg7ConfigUtil.convertExtractorsEnum(conf.getExtractors());
        if (extrs.contains((Object)Mpeg7ExtractorEnum.AudioSpectrumBasis) && !extrs.contains((Object)Mpeg7ExtractorEnum.AudioSpectrumProjection)) {
            reader.getExtractorRegister3D().remove(reader.getExtractorRegister3D().toArray()[0]);
        } else if (!extrs.contains((Object)Mpeg7ExtractorEnum.AudioSpectrumBasis) && extrs.contains((Object)Mpeg7ExtractorEnum.AudioSpectrumProjection)) {
            reader.getExtractorRegister3D().remove(reader.getExtractorRegister3D().toArray()[1]);
        }
        if (extrs.contains((Object)Mpeg7ExtractorEnum.AudioSpectrumSpread) && !extrs.contains((Object)Mpeg7ExtractorEnum.AudioSpectrumCentroid)) {
            reader.getExtractorRegister().remove(reader.getExtractorRegister().toArray()[0]);
        } else if (!extrs.contains((Object)Mpeg7ExtractorEnum.AudioSpectrumSpread) && extrs.contains((Object)Mpeg7ExtractorEnum.AudioSpectrumCentroid)) {
            reader.getExtractorRegister().remove(reader.getExtractorRegister().toArray()[1]);
        }
        if (extrs.contains((Object)Mpeg7ExtractorEnum.AudioHarmonicityHarmonicRatio) && !extrs.contains((Object)Mpeg7ExtractorEnum.AudioHarmonicityUpperLimit)) {
            reader.getExtractorRegister().remove(reader.getExtractorRegister().toArray()[1]);
        } else if (!extrs.contains((Object)Mpeg7ExtractorEnum.AudioHarmonicityHarmonicRatio) && extrs.contains((Object)Mpeg7ExtractorEnum.AudioHarmonicityUpperLimit)) {
            reader.getExtractorRegister().remove(reader.getExtractorRegister().toArray()[0]);
        }
    }

    static {
        enumMapping.put(Mpeg7ExtractorEnum.AudioSpectrumBasis, "AudioSpectrumBasisProjection");
        enumMapping.put(Mpeg7ExtractorEnum.AudioSpectrumProjection, "AudioSpectrumBasisProjection");
        enumMapping.put(Mpeg7ExtractorEnum.AudioSpectrumCentroid, "AudioSpectrumCentroidSpread");
        enumMapping.put(Mpeg7ExtractorEnum.AudioSpectrumSpread, "AudioSpectrumCentroidSpread");
        enumMapping.put(Mpeg7ExtractorEnum.AudioHarmonicityUpperLimit, "AudioHarmonicity");
        enumMapping.put(Mpeg7ExtractorEnum.AudioHarmonicityHarmonicRatio, "AudioHarmonicity");
    }
}

