/*
 * Decompiled with CFR 0.152.
 */
package it.univpm.deit.audio;

import de.crysandt.audio.mpeg7audio.msgs.Msg;
import de.crysandt.audio.mpeg7audio.msgs.MsgEndOfSignal;
import de.crysandt.audio.mpeg7audio.msgs.MsgHarmonicPeaks;
import de.crysandt.audio.mpeg7audio.msgs.MsgHarmonicSpectralCentroid;
import de.crysandt.audio.mpeg7audio.msgs.MsgHarmonicSpectralSpread;
import de.crysandt.audio.mpeg7audio.msgs.MsgListener;
import de.crysandt.audio.mpeg7audio.msgs.MsgSpeaker;
import java.util.ArrayList;

public class HarmonicSpectralCentroidSpread
extends MsgSpeaker
implements MsgListener {
    private float num_hsc = 0.0f;
    private float num_hss;
    private float hsc = 0.0f;
    private float hss = 0.0f;
    private int nb_frames = 0;

    public void receivedMsg(Msg msg) {
        if (msg instanceof MsgHarmonicPeaks) {
            this.receivedMsg((MsgHarmonicPeaks)msg);
        }
        if (msg instanceof MsgEndOfSignal) {
            this.receivedMsg((MsgEndOfSignal)msg);
        }
    }

    public void receivedMsg(MsgHarmonicPeaks mhp) {
        float num_ihsc = 0.0f;
        float den_ihsc = 0.0f;
        float num_ihss = 0.0f;
        float den_ihss = 0.0f;
        ArrayList peaks = mhp.getPeaks();
        for (float[] pd : peaks) {
            num_ihsc += pd[1] * pd[0];
            den_ihsc += pd[1];
        }
        float ihsc = num_ihsc / den_ihsc;
        for (float[] pd : peaks) {
            num_ihss = (float)((double)num_ihss + Math.sqrt(Math.pow(pd[1], 2.0) * Math.pow(pd[0] - ihsc, 2.0)));
            den_ihss = (float)((double)den_ihss + Math.sqrt(Math.pow(pd[1], 2.0)));
        }
        float ihss = 1.0f / ihsc * (num_ihss / den_ihss);
        this.num_hsc += ihsc;
        this.num_hss += ihss;
        ++this.nb_frames;
        this.hss = this.num_hss / (float)this.nb_frames;
        this.hsc = this.num_hsc / (float)this.nb_frames;
    }

    public void receivedMsg(MsgEndOfSignal meos) {
        int time = meos.time;
        int duration = meos.duration;
        this.send(new MsgHarmonicSpectralCentroid(time, duration, this.hsc));
        this.send(new MsgHarmonicSpectralSpread(time, duration, this.hss));
        this.send(meos);
    }
}

