/*
 * Decompiled with CFR 0.152.
 */
package it.univpm.deit.audio;

import de.crysandt.audio.mpeg7audio.msgs.Msg;
import de.crysandt.audio.mpeg7audio.msgs.MsgDigitalZero;
import de.crysandt.audio.mpeg7audio.msgs.MsgEndOfSignal;
import de.crysandt.audio.mpeg7audio.msgs.MsgListener;
import de.crysandt.audio.mpeg7audio.msgs.MsgResizer;
import de.crysandt.audio.mpeg7audio.msgs.MsgSpeaker;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

public class DigitalZero
extends MsgSpeaker
implements MsgListener {
    private static final int LENGTH_FRAME = 40;
    private final float SAMPLE_RATE;
    private LinkedList msglist = new LinkedList();
    private int channel = 1;
    private ArrayList zeros = new ArrayList();
    private int position = 1;
    private int zeroposition = 1;
    private int length_remember = 0;
    private boolean found = false;
    private double tresh = 3.1E-5;

    public DigitalZero(float samplerate) {
        this.SAMPLE_RATE = samplerate;
    }

    public void receivedMsg(Msg m) {
        if (m instanceof MsgResizer) {
            this.receivedMsg((MsgResizer)m);
        }
        if (m instanceof MsgEndOfSignal) {
            this.receivedMsg((MsgEndOfSignal)m);
        }
    }

    private void receivedMsg(MsgResizer m) {
        this.msglist.addLast(m);
        if (this.msglist.size() * m.duration == 40) {
            int k;
            int length = 0;
            Iterator iter = this.msglist.iterator();
            while (iter.hasNext()) {
                length += ((MsgResizer)iter.next()).getSignalLength();
            }
            float[] s = new float[length];
            iter = this.msglist.iterator();
            int index = 0;
            while (iter.hasNext()) {
                float[] source = ((MsgResizer)iter.next()).getSignal();
                System.arraycopy(source, 0, s, index, source.length);
                index += source.length;
            }
            Float zero = new Float(0.0f);
            Float[] o = new Float[s.length];
            for (int j = 0; j <= s.length - 1; ++j) {
                o[j] = new Float(s[j]);
                if (!((double)o[j].floatValue() <= this.tresh) || !((double)o[j].floatValue() >= -this.tresh)) continue;
                o[j] = zero;
            }
            int zerolength = this.length_remember;
            for (k = 0; k <= o.length - 1; ++k) {
                if (o[k].equals(zero)) {
                    if (this.found) {
                        ++zerolength;
                    } else {
                        ++zerolength;
                        this.zeroposition = this.position + k;
                        this.found = true;
                    }
                } else {
                    this.found = false;
                    if (zerolength > 1) {
                        this.zeros.add(new Zero(this.zeroposition, zerolength));
                    }
                    zerolength = 0;
                    this.length_remember = 0;
                }
                if (!this.found || k != o.length - 1) continue;
                this.length_remember = zerolength;
            }
            this.position += k;
            this.msglist.clear();
        }
    }

    public void receivedMsg(MsgEndOfSignal meos) {
        int time = meos.time;
        int duration = meos.duration;
        this.send(new MsgDigitalZero(time, duration, this.zeros, this.channel, this.SAMPLE_RATE));
        this.send(meos);
    }

    public class Zero {
        public int zeroposition;
        public int zerolength;

        public Zero(int zeroposition, int zerolength) {
            this.zeroposition = zeroposition;
            this.zerolength = zerolength;
        }
    }
}

