/*
 * Decompiled with CFR 0.152.
 */
package it.univpm.deit.audio;

import de.crysandt.audio.mpeg7audio.msgs.Msg;
import de.crysandt.audio.mpeg7audio.msgs.MsgDigitalClip;
import de.crysandt.audio.mpeg7audio.msgs.MsgEndOfSignal;
import de.crysandt.audio.mpeg7audio.msgs.MsgListener;
import de.crysandt.audio.mpeg7audio.msgs.MsgResizer;
import de.crysandt.audio.mpeg7audio.msgs.MsgSpeaker;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

public class DigitalClip
extends MsgSpeaker
implements MsgListener {
    private static final int LENGTH_FRAME = 50;
    private final float SAMPLE_RATE;
    private LinkedList msglist = new LinkedList();
    private int channel = 1;
    private ArrayList clips = new ArrayList();
    private int position = 1;
    private int clipposition = 1;
    private int length_remember = 0;
    private boolean found = false;
    private double tresh = 3.1E-5;

    public DigitalClip(float samplerate) {
        this.SAMPLE_RATE = samplerate;
    }

    public void receivedMsg(Msg m) {
        if (m instanceof MsgResizer) {
            this.receivedMsg((MsgResizer)m);
        }
        if (m instanceof MsgEndOfSignal) {
            this.receivedMsg((MsgEndOfSignal)m);
        }
    }

    private void receivedMsg(MsgResizer m) {
        this.msglist.addLast(m);
        if (this.msglist.size() * m.duration == 50) {
            int k;
            int length = 0;
            Iterator iter = this.msglist.iterator();
            while (iter.hasNext()) {
                length += ((MsgResizer)iter.next()).getSignalLength();
            }
            float[] s = new float[length];
            iter = this.msglist.iterator();
            int index = 0;
            while (iter.hasNext()) {
                float[] source = ((MsgResizer)iter.next()).getSignal();
                System.arraycopy(source, 0, s, index, source.length);
                index += source.length;
            }
            Float[] o = new Float[s.length];
            Float uno = new Float(1.0f);
            Float muno = new Float(-1.0f);
            for (int j = 0; j < s.length; ++j) {
                o[j] = new Float(s[j]);
                if ((double)o[j].floatValue() >= 1.0 - this.tresh) {
                    o[j] = uno;
                }
                if (!((double)o[j].floatValue() <= -(1.0 - this.tresh))) continue;
                o[j] = muno;
            }
            int cliplength = this.length_remember;
            for (k = 0; k <= o.length - 1; ++k) {
                if (o[k].equals(uno) || o[k].equals(muno)) {
                    if (this.found) {
                        ++cliplength;
                    } else {
                        ++cliplength;
                        this.clipposition = this.position + k;
                        this.found = true;
                    }
                } else {
                    this.found = false;
                    if (cliplength > 1) {
                        this.clips.add(new ClipData(this.clipposition, cliplength));
                    }
                    cliplength = 0;
                    this.length_remember = 0;
                }
                if (!this.found || k != o.length - 1) continue;
                this.length_remember = cliplength;
            }
            this.position += k;
            this.msglist.clear();
        }
    }

    public void receivedMsg(MsgEndOfSignal meos) {
        int time = meos.time;
        int duration = meos.duration;
        this.send(new MsgDigitalClip(time, duration, this.clips, this.channel, this.SAMPLE_RATE));
        this.send(meos);
    }

    public class ClipData {
        public int clipposition;
        public int cliplength;

        public ClipData(int clipposition, int cliplength) {
            this.clipposition = clipposition;
            this.cliplength = cliplength;
        }
    }
}

