/*
 * Decompiled with CFR 0.152.
 */
package it.univpm.deit.audio;

import de.crysandt.audio.mpeg7audio.msgs.Msg;
import de.crysandt.audio.mpeg7audio.msgs.MsgDcOffset;
import de.crysandt.audio.mpeg7audio.msgs.MsgEndOfSignal;
import de.crysandt.audio.mpeg7audio.msgs.MsgListener;
import de.crysandt.audio.mpeg7audio.msgs.MsgResizer;
import de.crysandt.audio.mpeg7audio.msgs.MsgSpeaker;

public class DcOffset
extends MsgSpeaker
implements MsgListener {
    private int channel = 1;
    private int signal_length = 0;
    private float signal_max = -5.0f;
    private float mean = -5.0f;
    private float sum = 0.0f;
    private float dco = -3.0f;

    public void receivedMsg(Msg m) {
        if (m instanceof MsgResizer) {
            this.receivedMsg((MsgResizer)m);
        }
        if (m instanceof MsgEndOfSignal) {
            this.receivedMsg((MsgEndOfSignal)m);
        }
    }

    private void receivedMsg(MsgResizer m) {
        float[] s = m.getSignal();
        this.signal_length += s.length;
        for (int i = 0; i < s.length; ++i) {
            this.sum += s[i];
            s[i] = Math.abs(s[i]);
            if (!(s[i] > this.signal_max)) continue;
            this.signal_max = s[i];
        }
    }

    public void receivedMsg(MsgEndOfSignal meos) {
        int time = meos.time;
        int duration = meos.duration;
        this.mean = this.sum / (float)this.signal_length;
        this.dco = this.mean / this.signal_max;
        if (this.dco < -1.0f) {
            this.dco = -1.0f;
        }
        if (this.dco > 1.0f) {
            this.dco = 1.0f;
        }
        this.send(new MsgDcOffset(time, duration, this.channel, this.dco));
        this.send(meos);
    }
}

