/*
 * Decompiled with CFR 0.152.
 */
package it.univpm.deit.audio;

import de.crysandt.audio.mpeg7audio.msgs.Msg;
import de.crysandt.audio.mpeg7audio.msgs.MsgBackgroundNoiseLevel;
import de.crysandt.audio.mpeg7audio.msgs.MsgEndOfSignal;
import de.crysandt.audio.mpeg7audio.msgs.MsgListener;
import de.crysandt.audio.mpeg7audio.msgs.MsgResizer;
import de.crysandt.audio.mpeg7audio.msgs.MsgSpeaker;
import de.crysandt.math.Function;

public class BackgroundNoiseLevel
extends MsgSpeaker
implements MsgListener {
    private final float samplerate;
    private static final int BLOCK_SIZE = 5;
    private int channel = 1;
    private double signal_max = 0.0;
    private double maxpeak_dB = 0.0;
    private double minpow_dB = 0.0;
    private double minpow = 0.0;
    private float bnl = 1.0f;

    public BackgroundNoiseLevel(float samplerate) {
        this.samplerate = samplerate;
    }

    public void receivedMsg(Msg m) {
        if (m instanceof MsgResizer) {
            this.receivedMsg((MsgResizer)m);
        }
        if (m instanceof MsgEndOfSignal) {
            this.receivedMsg((MsgEndOfSignal)m);
        }
    }

    private void receivedMsg(MsgResizer m) {
        float[] s = m.getSignal();
        double[] d = new double[s.length];
        for (int i = 0; i < s.length; ++i) {
            d[i] = s[i];
        }
        int block_size = (int)((double)(this.samplerate * 5.0f) * 0.001);
        int resto = d.length % block_size;
        while (resto > 0) {
            resto = d.length % --block_size;
        }
        double[] block = new double[block_size];
        for (int k = 0; k < s.length; ++k) {
            d[k] = Math.abs(d[k]);
            if (!(d[k] > this.signal_max)) continue;
            this.signal_max = d[k];
        }
        double local_minpow = 0.0;
        for (int i = 0; i < d.length - block_size; ++i) {
            if (i == 0 || (i + 1) % block_size == 0) {
                System.arraycopy(d, i, block, 0, block_size);
                for (int j = 0; j < block_size; ++j) {
                    local_minpow += block[j] * block[j] / (double)block_size;
                }
            }
            if (local_minpow == 0.0) {
                local_minpow = 1.0;
            }
            if (!(local_minpow < this.minpow) && this.minpow != 0.0) continue;
            this.minpow = local_minpow;
        }
    }

    public void receivedMsg(MsgEndOfSignal meos) {
        int time = meos.time;
        int duration = meos.duration;
        if (this.minpow == 0.0 || this.signal_max == 0.0) {
            this.bnl = 100.0f;
        } else {
            this.maxpeak_dB = 20.0f * Function.log10(this.signal_max);
            this.minpow_dB = 10.0f * Function.log10(this.minpow);
            this.bnl = (float)(this.minpow_dB - this.maxpeak_dB);
        }
        this.send(new MsgBackgroundNoiseLevel(time, duration, this.channel, this.samplerate, this.bnl));
        this.send(meos);
    }
}

