/*
 * Decompiled with CFR 0.152.
 */
package it.univpm.deit.audio;

import de.crysandt.audio.mpeg7audio.msgs.Msg;
import de.crysandt.audio.mpeg7audio.msgs.MsgAudioTempoType;
import de.crysandt.audio.mpeg7audio.msgs.MsgListener;
import de.crysandt.audio.mpeg7audio.msgs.MsgResizer;
import de.crysandt.audio.mpeg7audio.msgs.MsgSpeaker;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;

public class AudioTempoType
extends MsgSpeaker
implements MsgListener {
    private static LinkedList old_values = new LinkedList();
    private static LinkedList maximums = new LinkedList();
    static float fs;
    static final int k_dec = 16;
    final float a = 0.99f;
    int loLimit;
    int hiLimit;
    int attHopsize;
    static int minlag;
    static int maxlag;
    static float ceacfmax;
    float[] signal;

    public AudioTempoType() {
    }

    public AudioTempoType(int attHopsize, int loLimit, int hiLimit, float samplerate) {
        this.attHopsize = attHopsize;
        this.loLimit = loLimit;
        this.hiLimit = hiLimit;
        fs = samplerate;
    }

    public void receivedMsg(Msg msg) {
        if (msg instanceof MsgResizer) {
            this.receivedMsg((MsgResizer)msg);
        }
    }

    public void receivedMsg(MsgResizer mr) {
        int n;
        int i;
        int n2;
        this.signal = mr.getSignal();
        int length = mr.getSignalLength();
        int declength = length / 16;
        minlag = (int)Math.floor(60.0f * fs / (float)this.hiLimit / 16.0f);
        maxlag = (int)Math.floor(60.0f * fs / (float)this.loLimit / 16.0f);
        float[][] sigbands = new float[6][length];
        float[][] siglp = new float[6][length];
        float[][] sigdec = new float[6][declength];
        float[] signalenvelope = new float[declength - 4];
        float[] sigmeans = new float[6];
        float[] bandmax = new float[6];
        float[] bandmean = new float[6];
        float[] bandwf = new float[6];
        float[][] bandacf = new float[6][maxlag - minlag];
        float[] ceacf = new float[signalenvelope.length];
        if (fs == 44100.0f) {
            for (n2 = 4; n2 < length; ++n2) {
                sigbands[0][n2] = -2.0E-4f * sigbands[0][n2] - 4.0E-4f * sigbands[0][n2 - 1] - 2.0E-4f * sigbands[0][n2 - 2] + this.signal[n2] - 1.9597f * this.signal[n2 - 1] + 0.9605f * this.signal[n2 - 2];
                sigbands[1][n2] = -2.0E-4f * sigbands[1][n2] + 4.0E-4f * sigbands[1][n2 - 2] - 2.0E-4f * sigbands[1][n2 - 4] + this.signal[n2] - 3.9565f * this.signal[n2 - 1] + 5.8736f * this.signal[n2 - 2] - 3.8776f * this.signal[n2 - 3] + 0.9605f * this.signal[n2 - 4];
                sigbands[2][n2] = -8.0E-4f * sigbands[2][n2] + 0.0016f * sigbands[2][n2 - 2] - 8.0E-4f * sigbands[2][n2 - 4] + this.signal[n2] - 3.9076f * this.signal[n2 - 1] + 5.7365f * this.signal[n2 - 2] - 3.7524f * this.signal[n2 - 3] + 0.9226f * this.signal[n2 - 4];
                sigbands[3][n2] = -0.003f * sigbands[3][n2] + 0.006f * sigbands[3][n2 - 2] - 0.003f * sigbands[3][n2 - 4] + this.signal[n2] - 3.7893f * this.signal[n2 - 1] + 5.4342f * this.signal[n2 - 2] - 3.4954f * this.signal[n2 - 3] + 0.8511f * this.signal[n2 - 4];
                sigbands[4][n2] = -0.0112f * sigbands[4][n2] + 0.0223f * sigbands[4][n2 - 2] - 0.0112f * sigbands[4][n2 - 4] + this.signal[n2] - 3.4894f * this.signal[n2 - 1] + 4.7409f * this.signal[n2 - 2] - 2.9668f * this.signal[n2 - 3] + 0.7244f * this.signal[n2 - 4];
                sigbands[5][n2] = -0.7236f * sigbands[5][n2] + 1.4473f * sigbands[5][n2 - 1] - 0.7236f * sigbands[5][n2 - 2] + this.signal[n2] - 1.3694f * this.signal[n2 - 1] + 0.5252f * this.signal[n2 - 2];
            }
        } else if (fs == 22050.0f) {
            for (n2 = 4; n2 < length; ++n2) {
                sigbands[0][n2] = -8.0E-4f * sigbands[0][n2] - 0.0016f * sigbands[0][n2 - 1] - 8.0E-4f * sigbands[0][n2 - 2] + this.signal[n2] - 1.9196f * this.signal[n2 - 1] + 0.9227f * this.signal[n2 - 2];
                sigbands[1][n2] = -8.0E-4f * sigbands[1][n2] + 0.0016f * sigbands[1][n2 - 2] - 8.0E-4f * sigbands[1][n2 - 4] + this.signal[n2] - 3.9065f * this.signal[n2 - 1] + 5.7358f * this.signal[n2 - 2] - 3.7516f * this.signal[n2 - 3] + 0.9223f * this.signal[n2 - 4];
                sigbands[2][n2] = -0.003f * sigbands[2][n2] + 0.006f * sigbands[2][n2 - 2] - 0.003f * sigbands[2][n2 - 4] + this.signal[n2] - 3.7893f * this.signal[n2 - 1] + 5.4342f * this.signal[n2 - 2] - 3.4954f * this.signal[n2 - 3] + 0.8511f * this.signal[n2 - 4];
                sigbands[3][n2] = -0.0112f * sigbands[3][n2] + 0.0223f * sigbands[3][n2 - 2] - 0.0112f * sigbands[3][n2 - 4] + this.signal[n2] - 3.4894f * this.signal[n2 - 1] + 4.7409f * this.signal[n2 - 2] - 2.9668f * this.signal[n2 - 3] + 0.7244f * this.signal[n2 - 4];
                sigbands[4][n2] = -0.7236f * sigbands[4][n2] + 1.4473f * sigbands[4][n2 - 1] - 0.7236f * sigbands[4][n2 - 2] + this.signal[n2] - 1.3694f * this.signal[n2 - 1] + 0.5252f * this.signal[n2 - 2];
                sigbands[5][n2] = -0.5171f * sigbands[5][n2] + 1.0343f * sigbands[5][n2 - 1] - 0.5171f * sigbands[5][n2 - 2] + this.signal[n2] - 0.7856f * this.signal[n2 - 1] + 0.2829f * this.signal[n2 - 2];
            }
        }
        for (i = 0; i < 6; ++i) {
            for (n = 4; n < length; ++n) {
                if (!(sigbands[i][n] < 0.0f)) continue;
                sigbands[i][n] = Math.abs(sigbands[i][n]);
            }
            for (n = 4; n < length; ++n) {
                siglp[i][n] = 0.00999999f * sigbands[i][n] + 0.99f * siglp[i][n - 1];
            }
            for (n = 4; n < declength; ++n) {
                sigdec[i][n] = siglp[i][16 * n];
            }
        }
        for (i = 0; i < 6; ++i) {
            sigmeans[i] = AudioTempoType.findMean(sigdec[i]);
            n = 4;
            while (n < declength) {
                float[] fArray = sigdec[i];
                int n3 = n++;
                fArray[n3] = fArray[n3] - sigmeans[i];
            }
        }
        for (i = 0; i < 6; ++i) {
            for (int k = minlag; k < maxlag; ++k) {
                float c = 0.0f;
                float b = 0.0f;
                float a = 0.0f;
                for (int j = maxlag; j < declength; ++j) {
                    a += sigdec[i][j] * sigdec[i][j - k];
                    b += sigdec[i][j] * sigdec[i][j];
                    c += sigdec[i][j - k] * sigdec[i][j - k];
                }
                bandacf[i][k - AudioTempoType.minlag] = (float)((double)a / Math.sqrt(b * c));
            }
            bandmax[i] = AudioTempoType.findMax(bandacf[i]);
            bandmean[i] = AudioTempoType.findMean(bandacf[i]);
            bandwf[i] = bandmax[i] - bandmean[i];
            for (n = 4; n < declength; ++n) {
                float[] fArray = sigdec[i];
                int n4 = n;
                fArray[n4] = fArray[n4] * bandwf[i];
                int n5 = n - 4;
                signalenvelope[n5] = signalenvelope[n5] + sigdec[i][n];
            }
        }
        for (int k = minlag; k < maxlag; ++k) {
            float c = 0.0f;
            float b = 0.0f;
            float a = 0.0f;
            for (int j = maxlag; j < signalenvelope.length; ++j) {
                a += signalenvelope[j] * signalenvelope[j - k];
                b += signalenvelope[j] * signalenvelope[j];
                c += signalenvelope[j - k] * signalenvelope[j - k];
            }
            ceacf[k] = (float)((double)a / Math.sqrt(b * c));
        }
        ceacfmax = AudioTempoType.findMax(ceacf);
        float ceacfmean = AudioTempoType.findMean(ceacf);
        float ceacfwf = ceacfmax - ceacfmean;
        AudioTempoType.findPeaks(ceacf, ceacfwf);
        float[] result = AudioTempoType.newPeak().toArray();
        this.send(new MsgAudioTempoType(mr.time, mr.duration, this.attHopsize, this.loLimit, this.hiLimit, result[0], result[1], 1, 4));
    }

    static float findMax(float[] array) {
        float max = 0.0f;
        for (int i = 0; i < array.length - 1; ++i) {
            if (!(array[i + 1] > max)) continue;
            max = array[i + 1];
        }
        return max;
    }

    static float findMax() {
        if (!maximums.isEmpty()) {
            float max = ((RawAndWeight)AudioTempoType.maximums.getFirst()).acf_value;
            Iterator it = maximums.iterator();
            while (it.hasNext()) {
                if (!(((RawAndWeight)it.next()).acf_value > max)) continue;
                max = ((RawAndWeight)it.next()).acf_value;
            }
            return max;
        }
        return 0.0f;
    }

    static float findMean(float[] array) {
        int sum = 0;
        for (int i = 0; i < array.length - 1; ++i) {
            sum = (int)((float)sum + array[i]);
        }
        return sum / array.length;
    }

    static void findPeaks(float[] array, float wf) {
        int minind = (int)Math.floor(60.0f * fs / 160.0f / 16.0f);
        int maxind = (int)Math.floor(60.0f * fs / 60.0f / 16.0f);
        maximums.removeAll(maximums);
        AudioTempoType att = new AudioTempoType();
        block0: for (int index = minind; index < maxind; ++index) {
            for (int j = 1; j < 100 && array[index - j] < array[index] && array[index + j] < array[index]; ++j) {
                if (j != 99) continue;
                if (!maximums.isEmpty()) {
                    Iterator it = maximums.iterator();
                    while (it.hasNext()) {
                        float actual = ((RawAndWeight)it.next()).bpm;
                        if (!(60.0f * fs / (float)(16 * index) - 3.0f < actual / 2.0f) || !(60.0f * fs / (float)(16 * index) + 3.0f > actual / 2.0f)) continue;
                        continue block0;
                    }
                }
                AudioTempoType audioTempoType = att;
                audioTempoType.getClass();
                maximums.add(audioTempoType.new RawAndWeight(60.0f * fs / (float)(16 * index), array[index]));
            }
        }
        Collections.sort(maximums);
    }

    static RawAndWeight peakDecision() {
        AudioTempoType att = new AudioTempoType();
        int tollerance = 3;
        RawAndWeight result = null;
        Iterator it = maximums.iterator();
        if (maximums.isEmpty()) {
            AudioTempoType audioTempoType = att;
            audioTempoType.getClass();
            result = audioTempoType.new RawAndWeight(0.0f, 0.0f);
        }
        if (!old_values.isEmpty()) {
            while (it.hasNext()) {
                RawAndWeight peaknew = (RawAndWeight)it.next();
                for (RawAndWeight peakold : old_values) {
                    if (!(peaknew.bpm > peakold.bpm - (float)tollerance) || !(peaknew.bpm < peakold.bpm + (float)tollerance)) continue;
                    return peaknew;
                }
            }
            return AudioTempoType.newPeak();
        }
        return AudioTempoType.newPeak();
    }

    static RawAndWeight newPeak() {
        AudioTempoType att = new AudioTempoType();
        float newpeaktollerance = 0.03f;
        RawAndWeight result = null;
        if (maximums.isEmpty()) {
            AudioTempoType audioTempoType = att;
            audioTempoType.getClass();
            return audioTempoType.new RawAndWeight(0.0f, 0.0f);
        }
        result = (RawAndWeight)maximums.getFirst();
        for (RawAndWeight actual : maximums) {
            if (!(actual.acf_value > result.acf_value - newpeaktollerance)) continue;
            result = actual;
        }
        old_values.add(result);
        return result;
    }

    class RawAndWeight
    implements Comparable {
        float bpm;
        float acf_value;

        public RawAndWeight(float bpm, float acfval) {
            this.bpm = bpm;
            this.acf_value = acfval;
        }

        public int compareTo(Object rv) {
            float rvbpm = ((RawAndWeight)rv).bpm;
            return this.bpm < rvbpm ? -1 : (this.bpm == rvbpm ? 0 : 1);
        }

        public float[] toArray() {
            float[] res = new float[]{this.bpm, this.acf_value};
            return res;
        }
    }
}

