/*
 * Decompiled with CFR 0.152.
 */
package de.crysandt.math;

public final class LUDecomposition {
    private final int rows;
    private final int cols;
    private final double[][] LU;
    private final int[] piv;
    private int pivsign = 1;

    public LUDecomposition(double[][] matrix) {
        this.rows = matrix.length;
        this.cols = matrix[0].length;
        this.LU = new double[this.rows][this.cols];
        this.piv = new int[this.rows];
        for (int i = 0; i < this.rows; ++i) {
            System.arraycopy(matrix[i], 0, this.LU[i], 0, this.cols);
            this.piv[i] = i;
        }
        double[] LUcolj = new double[this.rows];
        for (int j = 0; j < this.cols; ++j) {
            int i;
            for (i = 0; i < this.rows; ++i) {
                LUcolj[i] = this.LU[i][j];
            }
            i = 0;
            while (i < this.rows) {
                double[] LUrowi = this.LU[i];
                double s = 0.0;
                int kmax = Math.min(i, j);
                for (int k = 0; k < kmax; ++k) {
                    s += LUrowi[k] * LUcolj[k];
                }
                int n = i++;
                double d = LUcolj[n] - s;
                LUcolj[n] = d;
                LUrowi[j] = d;
            }
            int p = j;
            for (int i2 = j + 1; i2 < this.rows; ++i2) {
                if (!(Math.abs(LUcolj[i2]) > Math.abs(LUcolj[p]))) continue;
                p = i2;
            }
            if (p != j) {
                int k;
                for (k = 0; k < this.cols; ++k) {
                    double t = this.LU[p][k];
                    this.LU[p][k] = this.LU[j][k];
                    this.LU[j][k] = t;
                }
                k = this.piv[p];
                this.piv[p] = this.piv[j];
                this.piv[j] = k;
                this.pivsign = -this.pivsign;
            }
            if (!(j < this.rows & this.LU[j][j] != 0.0)) continue;
            for (int i3 = j + 1; i3 < this.rows; ++i3) {
                double[] dArray = this.LU[i3];
                int n = j;
                dArray[n] = dArray[n] / this.LU[j][j];
            }
        }
    }

    public double[][] getL() {
        double[][] X = new double[this.rows][this.cols];
        for (int i = 0; i < this.rows; ++i) {
            double[] X_i = X[i];
            double[] LU_i = this.LU[i];
            int j_max = Math.min(i, this.cols);
            for (int j = 0; j < j_max; ++j) {
                X_i[j] = LU_i[j];
            }
            if (i >= this.cols) continue;
            X_i[i] = 1.0;
        }
        return X;
    }

    public double[][] getU() {
        double[][] X = new double[this.cols][this.cols];
        for (int i = 0; i < this.cols; ++i) {
            double[] X_i = X[i];
            double[] LU_i = this.LU[i];
            for (int j = i; j < this.cols; ++j) {
                X_i[j] = LU_i[j];
            }
        }
        return X;
    }

    public int[] getPiv() {
        int[] p = new int[this.piv.length];
        System.arraycopy(this.piv, 0, p, 0, p.length);
        return p;
    }

    public double det() {
        assert (this.rows == this.cols);
        double d = this.pivsign;
        for (int j = 0; j < this.cols; ++j) {
            d *= this.LU[j][j];
        }
        return d;
    }
}

