/*
 * Decompiled with CFR 0.152.
 */
package de.crysandt.audio.mpeg7audio.msgs;

import de.crysandt.audio.mpeg7audio.msgs.Flushable;
import de.crysandt.audio.mpeg7audio.msgs.Msg;
import de.crysandt.audio.mpeg7audio.msgs.MsgListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class MsgSpeaker
implements Flushable {
    private Set listeners = Collections.synchronizedSet(new HashSet());

    public void addMsgListener(MsgListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeMsgListener(MsgListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public int getNumberOfListeners() {
        return this.listeners.size();
    }

    public void flush() {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            try {
                ((Flushable)i.next()).flush();
            }
            catch (ClassCastException classCastException) {}
        }
        this.listeners.clear();
    }

    protected void send(Msg msg) {
        if (msg != null && !this.listeners.isEmpty()) {
            Iterator i = this.listeners.iterator();
            while (i.hasNext()) {
                ((MsgListener)i.next()).receivedMsg(msg);
            }
        }
    }
}

