/*
 * Decompiled with CFR 0.152.
 */
package de.crysandt.audio.mpeg7audio.mci;

import de.crysandt.audio.mpeg7audio.mci.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UniqueID {
    private String unique_id;
    private String type;
    private String organization;
    private String authority;
    private String encoding;
    private static long counter = 0L;

    public UniqueID() {
        String num = Long.toString(counter);
        ++counter;
        while (num.length() < 10) {
            num = "0" + num;
        }
        this.unique_id = "UniqueID" + num;
        this.type = null;
        this.organization = null;
        this.authority = null;
        this.encoding = null;
    }

    public UniqueID(String unique_id) {
        this.unique_id = unique_id;
        this.type = null;
        this.organization = null;
        this.authority = null;
        this.encoding = null;
    }

    public Element toXML(Document doc, String name) {
        Element id_ele = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", name);
        id_ele.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "UniqueIDType");
        Utils.setContent(doc, id_ele, this.unique_id);
        if (this.type != null) {
            id_ele.setAttribute("type", this.type);
        }
        if (this.organization != null) {
            id_ele.setAttribute("organization", this.organization);
        }
        if (this.authority != null) {
            id_ele.setAttribute("authority", this.authority);
        }
        if (this.encoding != null) {
            id_ele.setAttribute("encoding", this.encoding);
        }
        return id_ele;
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getType() {
        return this.type;
    }

    public String getUniqueId() {
        return this.unique_id;
    }

    public void setAuthority(String authority) {
        this.authority = authority;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setUniqueId(String unique_id) {
        this.unique_id = unique_id;
    }
}

