/*
 * Decompiled with CFR 0.152.
 */
package de.crysandt.audio.mpeg7audio.mci;

import de.crysandt.audio.mpeg7audio.mci.ControlledTermUse;
import de.crysandt.audio.mpeg7audio.mci.DescriptorI;
import de.crysandt.audio.mpeg7audio.mci.UniqueID;
import de.crysandt.util.VectorTyped;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MediaIdentification
implements DescriptorI {
    private UniqueID entity_identifier;
    private VectorTyped audio_domains;
    private VectorTyped video_domains;
    private VectorTyped image_domains;

    public MediaIdentification(UniqueID entity_identifier) {
        this.entity_identifier = entity_identifier;
        this.audio_domains = new VectorTyped(ControlledTermUse.class);
        this.video_domains = new VectorTyped(ControlledTermUse.class);
        this.image_domains = new VectorTyped(ControlledTermUse.class);
    }

    public Element toXML(Document doc, String name) {
        int i;
        Element iden_ele = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", name);
        iden_ele.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "MediaIdentificationType");
        iden_ele.appendChild(this.entity_identifier.toXML(doc, "EntityIdentifier"));
        for (i = 0; i < this.audio_domains.size(); ++i) {
            iden_ele.appendChild(((ControlledTermUse)this.audio_domains.get(i)).toXML(doc, "AudioDomain"));
        }
        for (i = 0; i < this.video_domains.size(); ++i) {
            iden_ele.appendChild(((ControlledTermUse)this.video_domains.get(i)).toXML(doc, "VideoDomain"));
        }
        for (i = 0; i < this.image_domains.size(); ++i) {
            iden_ele.appendChild(((ControlledTermUse)this.image_domains.get(i)).toXML(doc, "ImageDomain"));
        }
        return iden_ele;
    }

    public UniqueID getEntityIdentifier() {
        return this.entity_identifier;
    }

    public void setEntityIdentifier(UniqueID entity_identifier) {
        this.entity_identifier = entity_identifier;
    }

    public VectorTyped getAudioDomains() {
        return this.audio_domains;
    }

    public VectorTyped getVideoDomains() {
        return this.video_domains;
    }

    public VectorTyped getImageDomains() {
        return this.image_domains;
    }
}

