/*
 * Decompiled with CFR 0.152.
 */
package de.crysandt.audio.mpeg7audio.mci;

import de.crysandt.audio.mpeg7audio.mci.MFAudioCoding;
import de.crysandt.audio.mpeg7audio.mci.MFContent;
import de.crysandt.audio.mpeg7audio.mci.MediaFormat;
import de.crysandt.audio.mpeg7audio.mci.MediaInformation;
import de.crysandt.audio.mpeg7audio.mci.MediaInstance;
import de.crysandt.audio.mpeg7audio.mci.MediaLocator;
import de.crysandt.audio.mpeg7audio.mci.MediaProfile;
import de.crysandt.audio.mpeg7audio.mci.UniqueID;
import de.crysandt.util.Debug;
import java.net.URI;

public class MediaHelper {
    public static MediaInformation createMediaInformation() {
        return new MediaInformation(new MediaProfile());
    }

    public static void setMediaLocation(MediaInformation media_info, URI media_uri) {
        MediaHelper.getMediaLocator(media_info).setMediaUri(media_uri);
    }

    public static void setFileSize(MediaInformation media_info, long size) {
        MediaHelper.getMediaFormat(media_info).setFileSize(size);
    }

    public static void setContentType(MediaInformation media_info, int content_type) {
        MediaHelper.getContent(media_info).setContentType(content_type);
    }

    public static void setBandwidth(MediaInformation media_info, float bandwidth) {
        MediaHelper.getMediaFormat(media_info).setBandwidth(bandwidth);
    }

    public static void setBitRate(MediaInformation media_info, int bitrate) {
        MediaHelper.getMediaFormat(media_info).setBitRate(bitrate);
    }

    public static void setBitRateVariable(MediaInformation media_info, boolean variable) {
        MediaHelper.getMediaFormat(media_info).setBitRateVariable(variable);
    }

    public static void setBitRateMinimum(MediaInformation media_info, int minimum) {
        MediaHelper.getMediaFormat(media_info).setBitRateMinimum(minimum);
    }

    public static void setBitRateAverage(MediaInformation media_info, int average) {
        MediaHelper.getMediaFormat(media_info).setBitRateAverage(average);
    }

    public static void setBitRateMaximum(MediaInformation media_info, int maximum) {
        MediaHelper.getMediaFormat(media_info).setBitRateMaximum(maximum);
    }

    public static void setChannels(MediaInformation media_info, int channels) {
        MediaHelper.getAudioCoding(media_info).setAudioChannels(channels);
    }

    public static void setChannelsFront(MediaInformation media_info, int ch_front) {
        MediaHelper.getAudioCoding(media_info).setAudioChannelsFront(ch_front);
    }

    public static void setChannelsSide(MediaInformation media_info, int ch_side) {
        MediaHelper.getAudioCoding(media_info).setAudioChannelsSide(ch_side);
    }

    public static void setChannelsRear(MediaInformation media_info, int ch_rear) {
        MediaHelper.getAudioCoding(media_info).setAudioChannelsRear(ch_rear);
    }

    public static void setChannelsLFE(MediaInformation media_info, int ch_lfe) {
        MediaHelper.getAudioCoding(media_info).setAudioChannelsLfe(ch_lfe);
    }

    public static void setChannelsTrack(MediaInformation media_info, int tracks) {
        MediaHelper.getAudioCoding(media_info).setAudioChannelsTrack(tracks);
    }

    public static void setSampleRate(MediaInformation media_info, float rate) {
        MediaHelper.getAudioCoding(media_info).setSampleRate(rate);
    }

    public static void setBitsPerSample(MediaInformation media_info, int bits) {
        MediaHelper.getAudioCoding(media_info).setSampleBitsPer(bits);
    }

    private static MediaProfile getMediaProfile(MediaInformation media_info) {
        if (media_info.getMediaProfiles().size() == 0) {
            media_info.getMediaProfiles().add(new MediaProfile());
        }
        return (MediaProfile)media_info.getMediaProfiles().get(0);
    }

    private static MediaFormat getMediaFormat(MediaInformation media_info) {
        MediaProfile media_profile = MediaHelper.getMediaProfile(media_info);
        if (media_profile.getMediaFormat() == null) {
            media_profile.setMediaFormat(new MediaFormat(new MFContent()));
        }
        return media_profile.getMediaFormat();
    }

    private static MFAudioCoding getAudioCoding(MediaInformation media_info) {
        MediaFormat media_format = MediaHelper.getMediaFormat(media_info);
        if (media_format.getAudioCoding() == null) {
            media_format.setAudioCoding(new MFAudioCoding());
        }
        return media_format.getAudioCoding();
    }

    private static MediaInstance getMediaInstance(MediaInformation media_info) {
        MediaProfile media_profile = MediaHelper.getMediaProfile(media_info);
        try {
            if (media_profile.getMediaInstances().size() == 0) {
                media_profile.getMediaInstances().add(new MediaInstance(new UniqueID(), new MediaLocator(new URI(""))));
            }
        }
        catch (Exception exc) {
            Debug.printStackTrace(System.err, exc);
        }
        return (MediaInstance)media_profile.getMediaInstances().get(0);
    }

    private static MediaLocator getMediaLocator(MediaInformation media_info) {
        MediaInstance media_instance = MediaHelper.getMediaInstance(media_info);
        try {
            if (media_instance.getMediaLocator() == null) {
                media_instance.setMediaLocator(new MediaLocator(new URI("")));
            }
        }
        catch (Exception exc) {
            Debug.printStackTrace(System.err, exc);
        }
        return media_instance.getMediaLocator();
    }

    private static MFContent getContent(MediaInformation media_info) {
        MediaFormat media_format = MediaHelper.getMediaFormat(media_info);
        if (media_format.getContent() == null) {
            media_format.setContent(new MFContent());
        }
        return media_format.getContent();
    }
}

