/*
 * Decompiled with CFR 0.152.
 */
package de.crysandt.audio.mpeg7audio;

import de.crysandt.audio.mpeg7audio.msgs.Msg;
import de.crysandt.audio.mpeg7audio.msgs.MsgEndOfSignal;
import de.crysandt.audio.mpeg7audio.msgs.MsgListener;
import de.crysandt.audio.mpeg7audio.msgs.MsgRawSignal;
import de.crysandt.audio.mpeg7audio.msgs.MsgResizer;
import de.crysandt.audio.mpeg7audio.msgs.MsgSpeaker;

class Resizer
extends MsgSpeaker
implements MsgListener {
    private final float samplerate;
    private final int duration;
    private int index = 0;
    private float[] signal_old = null;
    private int totalsignalprocessed = 0;

    public Resizer(float samplerate, int duration) {
        this.samplerate = samplerate;
        this.duration = duration;
    }

    public void receivedMsg(Msg msg) {
        try {
            this.put(((MsgRawSignal)msg).signal);
        }
        catch (ClassCastException e) {
            this.send(new MsgEndOfSignal(Math.round((float)(1000 * this.totalsignalprocessed) / this.samplerate), 0));
        }
    }

    private void put(float[] signal) {
        float[] s;
        this.totalsignalprocessed += signal.length;
        if (this.signal_old != null) {
            s = new float[this.signal_old.length + signal.length];
            System.arraycopy(this.signal_old, 0, s, 0, this.signal_old.length);
            System.arraycopy(signal, 0, s, this.signal_old.length, signal.length);
        } else {
            s = signal;
        }
        int offset = 0;
        while (s.length - offset >= this.getBlockLength(this.index)) {
            float[] block = new float[this.getBlockLength(this.index)];
            System.arraycopy(s, offset, block, 0, block.length);
            offset += block.length;
            this.send(new MsgResizer(this.index * this.duration, this.duration, block));
            ++this.index;
        }
        int length = s.length - offset;
        if (length > 0) {
            this.signal_old = new float[length];
            System.arraycopy(s, offset, this.signal_old, 0, this.signal_old.length);
        } else {
            this.signal_old = null;
        }
    }

    private int getBlockLength(int i) {
        return (int)(Math.floor((double)((float)(i + 1) * this.samplerate * (float)this.duration) / 1000.0) - Math.floor((double)((float)i * this.samplerate * (float)this.duration) / 1000.0));
    }
}

