/*
 * Decompiled with CFR 0.152.
 */
package de.crysandt.audio.mpeg7audio;

import de.crysandt.audio.mpeg7audio.Config;
import de.crysandt.audio.mpeg7audio.ConfigDefault;
import de.crysandt.util.Debug;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;

class ConfigXMLContentHandler
implements ContentHandler,
ErrorHandler {
    private static final String XSI = "http://www.w3.org/2001/XMLSchema-instance";
    private final Config config;
    private String module = null;
    private String name = null;
    private StringBuffer buffer = null;

    public ConfigXMLContentHandler(Config config) {
        this.config = config;
    }

    public ConfigXMLContentHandler() {
        this(ConfigXMLContentHandler.getDefaultConfig());
    }

    public Config getConfig() {
        return this.config;
    }

    private static Config getDefaultConfig() {
        ConfigDefault config = new ConfigDefault();
        config.enableAll(false);
        return config;
    }

    public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) {
        if (localName.equals("Module")) {
            this.module = atts.getValue(XSI, "type");
            String enabled = atts.getValue("enable");
            if (enabled == null || enabled.equals("")) {
                enabled = "true";
            }
            this.config.setValue(this.module, "enable", enabled);
        } else if (this.module != null) {
            this.name = localName;
            this.buffer = new StringBuffer();
        }
    }

    public void endElement(String namspaceURI, String localName, String rawName) {
        if (localName.equals("Module")) {
            this.module = null;
        } else if (this.module != null) {
            assert (this.name.equals(localName));
            this.config.setValue(this.module, this.name, this.buffer.toString().trim());
            this.buffer = null;
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.buffer != null) {
            this.buffer.append(ch, start, length);
        }
    }

    public void error(SAXParseException e) throws SAXParseException {
        throw e;
    }

    public void fatalError(SAXParseException e) throws SAXParseException {
        throw e;
    }

    public void warning(SAXParseException e) {
        assert (Debug.println(System.err, "warning: " + e.getMessage()));
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    public void processingInstruction(String target, String data) {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String s) {
    }

    public void startPrefixMapping(String prefix, String uri) {
    }

    public void endPrefixMapping(String prefix) {
    }
}

