/*
 * Decompiled with CFR 0.152.
 */
package de.crysandt.audio.mpeg7audio;

import de.crysandt.audio.mpeg7audio.Config;
import de.crysandt.audio.mpeg7audio.ConfigDefault;
import de.crysandt.audio.mpeg7audio.ConfigXMLContentHandler;
import de.crysandt.util.Debug;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.Iterator;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ConfigXML {
    public static Config parse(Reader reader, Config config) throws SAXException, IOException {
        ConfigXMLContentHandler ch;
        XMLReader xml_reader;
        block6: {
            xml_reader = XMLReaderFactory.createXMLReader();
            ch = new ConfigXMLContentHandler(config);
            try {
                xml_reader.setFeature("http://apache.org/xml/features/validation/schema", true);
                xml_reader.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
                URL url = Thread.currentThread().getContextClassLoader().getResource("mpeg7audioenc.xsd");
                if (url != null) {
                    assert (Debug.println(System.err, "Using mpeg7audioenc.xsd included in CLASSPATH"));
                    xml_reader.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", url.openStream());
                } else assert (Debug.println(System.err, "Can't open local copy of mpeg7audioenc.xsd"));
            }
            catch (SAXNotRecognizedException e) {
                if ($assertionsDisabled || Debug.println(System.err, "SAXNotRecognizedException:" + e.getMessage())) break block6;
                throw new AssertionError();
            }
        }
        xml_reader.setContentHandler(ch);
        xml_reader.setErrorHandler(ch);
        xml_reader.parse(new InputSource(reader));
        return ch.getConfig();
    }

    public static Config parse(Reader reader) throws SAXException, IOException {
        ConfigDefault config = new ConfigDefault();
        config.enableAll(false);
        return ConfigXML.parse(reader, config);
    }

    public static Document toDocument(Config config) throws ParserConfigurationException {
        DocumentBuilderFactory doc_factory = DocumentBuilderFactory.newInstance();
        doc_factory.setNamespaceAware(true);
        DocumentBuilder doc_builder = doc_factory.newDocumentBuilder();
        Document doc = doc_builder.newDocument();
        Element root = doc.createElementNS("http://mpeg7audioenc.sf.net/mpeg7audioenc.xsd", "Config");
        doc.appendChild(root);
        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://mpeg7audioenc.sf.net/mpeg7audioenc.xsd");
        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:mp7ae", "http://mpeg7audioenc.sf.net/mpeg7audioenc.xsd");
        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        ConfigDefault config_default = new ConfigDefault();
        TreeSet keys = new TreeSet(config_default.config.keySet());
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            String module;
            String key = i.next().toString();
            if (!key.endsWith("_enable") || !config.getBoolean(module = key.substring(0, key.indexOf("_enable")), "enable")) continue;
            Element child = doc.createElementNS("http://mpeg7audioenc.sf.net/mpeg7audioenc.xsd", "Module");
            child.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", module);
            child.setAttributeNS("http://mpeg7audioenc.sf.net/mpeg7audioenc.xsd", "mp7ae:enable", Boolean.TRUE.toString());
            root.appendChild(child);
            Iterator j = keys.iterator();
            while (j.hasNext()) {
                String name;
                String module_name = j.next().toString();
                if (!module_name.startsWith(module) || (name = module_name.substring(module.length() + 1, module_name.length())).equals("enable")) continue;
                Element parameter = doc.createElement(name);
                parameter.appendChild(doc.createTextNode(config.getString(module, name)));
                child.appendChild(parameter);
            }
        }
        return doc;
    }
}

