/*
 * Decompiled with CFR 0.152.
 */
package de.crysandt.audio.mpeg7audio;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class Config
implements Cloneable {
    protected Map config = new HashMap();

    public Object clone() throws CloneNotSupportedException {
        Config cloned = (Config)super.clone();
        cloned.config = new HashMap();
        for (Object key : this.config.keySet()) {
            cloned.config.put(key, this.config.get(key));
        }
        return cloned;
    }

    public Object getValue(String module, String name) {
        return this.config.get(Config.key(module, name));
    }

    public String getString(String module, String name) {
        return this.getValue(module, name).toString();
    }

    public boolean getBoolean(String module, String name) {
        return this.getString(module, name).equals(Boolean.TRUE.toString());
    }

    public int getInt(String module, String name) {
        return Integer.parseInt(this.getValue(module, name).toString());
    }

    public long getLong(String module, String name) {
        return Long.parseLong(this.getString(module, name));
    }

    public float getFloat(String module, String name) {
        return Float.parseFloat(this.getString(module, name));
    }

    public double getDouble(String module, String name) {
        return Double.parseDouble(this.getString(module, name));
    }

    public void setValue(String module, String name, Object value) {
        this.config.put(Config.key(module, name), value);
    }

    public void setValue(String module, String name, boolean value) {
        this.setValue(module, name, "" + value);
    }

    public void setValue(String module, String name, int value) {
        this.setValue(module, name, "" + value);
    }

    public void setValue(String module, String name, long value) {
        this.setValue(module, name, "" + value);
    }

    public void setValue(String module, String name, float value) {
        this.setValue(module, name, "" + value);
    }

    public void setValue(String module, String name, double value) {
        this.setValue(module, name, "" + value);
    }

    public void enableAll(boolean enable) {
        TreeSet<String> keys = new TreeSet<String>();
        Iterator<Object> i = this.config.keySet().iterator();
        while (i.hasNext()) {
            String key = i.next().toString();
            if (!key.endsWith("enable")) continue;
            keys.add(key);
        }
        i = keys.iterator();
        while (i.hasNext()) {
            this.config.put(i.next(), "" + enable);
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        for (String key : new TreeSet(this.config.keySet())) {
            s.append(key + ": " + this.config.get(key) + "\n");
        }
        return s.toString();
    }

    private static String key(String module, String name) {
        return module + "_" + name;
    }
}

