/*
 * Decompiled with CFR 0.152.
 */
package de.crysandt.audio.mpeg7audio;

import de.crysandt.audio.mpeg7audio.msgs.Msg;
import de.crysandt.audio.mpeg7audio.msgs.MsgAudioSpectrum;
import de.crysandt.audio.mpeg7audio.msgs.MsgAudioSpectrumEnvelope;
import de.crysandt.audio.mpeg7audio.msgs.MsgListener;
import de.crysandt.audio.mpeg7audio.msgs.MsgSpeaker;
import de.crysandt.math.Function;

class AudioSpectrumEnvelope
extends MsgSpeaker
implements MsgListener {
    private static final float HAMMING_ENERGIE = 0.3974f;
    static final int NORMALIZE_OFF = 0;
    static final int NORMALIZE_NORM2 = 1;
    static final int NORMALIZE_POWER = 2;
    private final float RESOLUTION;
    private final float LO_EDGE;
    private final float HI_EDGE;
    private final boolean DB_SCALE;
    private final int normalize;

    public AudioSpectrumEnvelope(float resolution, float lo_edge, float hi_edge, boolean db_scale, String normalize) {
        this.RESOLUTION = resolution;
        this.LO_EDGE = lo_edge;
        this.HI_EDGE = hi_edge;
        this.DB_SCALE = db_scale;
        if ("off".equals(normalize)) {
            this.normalize = 0;
        } else if ("norm2".equals(normalize)) {
            this.normalize = 1;
        } else if ("power".equals(normalize)) {
            this.normalize = 2;
        } else {
            throw new IllegalArgumentException("Parameter nomalize must be \"off\", \"norm2\" or \"power\". ( is: " + normalize + ")");
        }
    }

    public void receivedMsg(Msg msg) {
        MsgAudioSpectrum m = (MsgAudioSpectrum)msg;
        double band_factor = Math.pow(2.0, this.RESOLUTION);
        float DF = m.deltaF;
        float[] spectrum = m.getAudioSpectrum();
        float scal = (float)(m.lengthFFT * m.lengthWindow) * 0.3974f;
        int i = 0;
        while (i < spectrum.length) {
            int n = i++;
            spectrum[n] = spectrum[n] / scal;
        }
        int num = 2 + (int)(Math.floor(0.5 + (double)Function.log2(this.HI_EDGE / this.LO_EDGE)) / (double)this.RESOLUTION);
        float[] envelope = new float[num];
        float freq = 0.0f;
        int i2 = 0;
        int index = 0;
        float band_edge_lo = -3.4028235E38f;
        float band_edge_hi = this.LO_EDGE;
        while (i2 < spectrum.length) {
            while (freq < band_edge_hi && i2 < spectrum.length) {
                float alpha_lo = Math.max(0.0f, 0.5f - (freq - band_edge_lo) / DF);
                float alpha_hi = Math.max(0.0f, 0.5f - (band_edge_hi - freq) / DF);
                if (alpha_lo != 0.0f || alpha_hi != 0.0f) {
                    if ((double)alpha_lo > 0.0) {
                        int n = index - 1;
                        envelope[n] = envelope[n] + spectrum[i2] * alpha_lo;
                    }
                    if ((double)alpha_hi > 0.0) {
                        int n = index + 1;
                        envelope[n] = envelope[n] + spectrum[i2] * alpha_hi;
                    }
                    int n = index;
                    envelope[n] = envelope[n] + spectrum[i2] * (1.0f - alpha_lo - alpha_hi);
                } else {
                    int n = index;
                    envelope[n] = envelope[n] + spectrum[i2];
                }
                ++i2;
                freq += DF;
            }
            if (index < envelope.length - 1) {
                ++index;
            }
            if (index < envelope.length - 1) {
                band_edge_lo = band_edge_hi;
                band_edge_hi = (float)((double)band_edge_hi * band_factor);
                continue;
            }
            band_edge_lo = this.HI_EDGE;
            band_edge_hi = Float.MAX_VALUE;
        }
        if (this.normalize == 2) {
            float power = Function.sum(envelope);
            int n = 0;
            while (n < envelope.length) {
                int n2 = n++;
                envelope[n2] = envelope[n2] / power;
            }
            envelope[0] = power;
        }
        if (this.DB_SCALE) {
            for (int n = 0; n < envelope.length; ++n) {
                envelope[n] = 10.0f / (float)Function.LOG10 * (float)Math.log(envelope[n] + Float.MIN_VALUE);
            }
        }
        if (this.normalize == 1) {
            int n;
            double norm2 = 0.0;
            for (n = 0; n < envelope.length; ++n) {
                norm2 += (double)(envelope[n] * envelope[n]);
            }
            norm2 = (float)Math.sqrt(norm2);
            n = 0;
            while (n < envelope.length) {
                int n3 = n++;
                envelope[n3] = (float)((double)envelope[n3] / norm2);
            }
        }
        this.send(new MsgAudioSpectrumEnvelope(m.time, m.duration, m.hopsize, envelope, this.LO_EDGE, this.HI_EDGE, this.RESOLUTION, this.DB_SCALE, this.normalize));
    }
}

