/*
 * Decompiled with CFR 0.152.
 */
package de.crysandt.audio.mpeg7audio;

import de.crysandt.audio.mpeg7audio.msgs.Msg;
import de.crysandt.audio.mpeg7audio.msgs.MsgAudioSpectrumDistribution;
import de.crysandt.audio.mpeg7audio.msgs.MsgAudioSpectrumEnvelope;
import de.crysandt.audio.mpeg7audio.msgs.MsgListener;
import de.crysandt.audio.mpeg7audio.msgs.MsgSpeaker;
import java.util.Arrays;

class AudioSpectrumDistribution
extends MsgSpeaker
implements MsgListener {
    AudioSpectrumDistribution() {
    }

    public void receivedMsg(Msg msg) {
        MsgAudioSpectrumEnvelope mase = (MsgAudioSpectrumEnvelope)msg;
        float[] envelope = mase.getEnvelope();
        double sum = 0.0;
        for (int i = 0; i < envelope.length; ++i) {
            sum += (double)envelope[i];
        }
        float[] distribution = new float[envelope.length];
        if (sum == 0.0) {
            Arrays.fill(distribution, 1.0f / (float)envelope.length);
        } else {
            for (int i = 0; i < envelope.length; ++i) {
                distribution[i] = (float)((double)envelope[i] / sum);
            }
        }
        this.send(new MsgAudioSpectrumDistribution(mase.time, mase.duration, mase.hopsize, distribution, mase.lo_edge, mase.hi_edge, mase.resolution));
    }
}

