/*
 * Decompiled with CFR 0.152.
 */
package de.crysandt.audio.mpeg7audio;

import de.crysandt.audio.mpeg7audio.msgs.Msg;
import de.crysandt.audio.mpeg7audio.msgs.MsgAudioSpectrum;
import de.crysandt.audio.mpeg7audio.msgs.MsgAudioSpectrumCentroid;
import de.crysandt.audio.mpeg7audio.msgs.MsgAudioSpectrumSpread;
import de.crysandt.audio.mpeg7audio.msgs.MsgListener;
import de.crysandt.audio.mpeg7audio.msgs.MsgSpeaker;
import de.crysandt.math.Function;

class AudioSpectrumCentroidSpread
extends MsgSpeaker
implements MsgListener {
    private static final float LIMIT_LO = 62.5f;
    private float[] f_log2 = null;

    AudioSpectrumCentroidSpread() {
    }

    public void receivedMsg(Msg m) {
        if (m instanceof MsgAudioSpectrum) {
            this.receivedMsg((MsgAudioSpectrum)m);
        }
    }

    public void receivedMsg(MsgAudioSpectrum mas) {
        float[] spectrum = mas.getAudioSpectrum();
        float delta_f = mas.deltaF;
        if (this.f_log2 == null) {
            this.f_log2 = new float[spectrum.length];
            for (int i = 0; i < this.f_log2.length; ++i) {
                this.f_log2[i] = (float)Math.log((float)i * delta_f / 1000.0f) / (float)Function.LOG2;
            }
        }
        float power = 0.0f;
        for (int i = 0; i < spectrum.length; ++i) {
            power += spectrum[i];
        }
        float centroid = 0.0f;
        float spread = 0.0f;
        if ((double)power > 0.0) {
            float f;
            int i_lo = 0;
            double power_lo = 0.0;
            for (f = 0.0f; f < 62.5f; f += delta_f) {
                power_lo += (double)spectrum[i_lo];
                ++i_lo;
            }
            double sum = power_lo * (double)Function.log2(0.03125);
            int i = i_lo;
            while (i < spectrum.length) {
                sum += (double)(spectrum[i] * this.f_log2[i]);
                ++i;
                f += delta_f;
            }
            centroid = (float)(sum / (double)power);
            f = (float)i_lo * delta_f;
            float tmp = Function.log2(0.03125) - centroid;
            sum = power_lo * (double)tmp * (double)tmp;
            int i2 = i_lo;
            while (i2 < spectrum.length) {
                tmp = this.f_log2[i2] - centroid;
                sum += (double)(spectrum[i2] * tmp * tmp);
                ++i2;
                f += delta_f;
            }
            spread = (float)Math.sqrt(sum / (double)power);
        }
        this.send(new MsgAudioSpectrumCentroid(mas.time, mas.duration, centroid));
        this.send(new MsgAudioSpectrumSpread(mas.time, mas.duration, spread));
    }
}

