/*
 * Decompiled with CFR 0.152.
 */
package de.crysandt.audio.mpeg7audio;

import de.crysandt.audio.mpeg7audio.msgs.Msg;
import de.crysandt.audio.mpeg7audio.msgs.MsgAudioSignature;
import de.crysandt.audio.mpeg7audio.msgs.MsgAudioSpectrumFlatness;
import de.crysandt.audio.mpeg7audio.msgs.MsgListener;
import de.crysandt.audio.mpeg7audio.msgs.MsgSpeaker;
import de.crysandt.math.Function;
import java.util.Iterator;
import java.util.LinkedList;

class AudioSignature
extends MsgSpeaker
implements MsgListener {
    private static final int HOP_SIZE = 30;
    private final int DECIMATION;
    private static final float LO_EDGE = 250.0f;
    private static final float HI_EDGE = 4000.0f;
    private LinkedList msglist = new LinkedList();

    public AudioSignature(int decimation) {
        this.DECIMATION = decimation;
    }

    public void receivedMsg(Msg msg) {
        if (msg instanceof MsgAudioSpectrumFlatness) {
            this.receivedMsg((MsgAudioSpectrumFlatness)msg);
        }
    }

    private void receivedMsg(MsgAudioSpectrumFlatness masf) {
        if (masf.time % 30 != 0) {
            return;
        }
        this.msglist.addLast(masf);
        if (this.msglist.size() == this.DECIMATION) {
            masf = (MsgAudioSpectrumFlatness)this.msglist.getFirst();
            int time = masf.time;
            int hopsize = masf.hopsize;
            float hi_edge = Math.min(masf.hi_edge, 4000.0f);
            int dim250 = 4 * Math.round(Function.log2(250.0f / masf.lo_edge));
            int length = 4 * Math.round(Function.log2(hi_edge / 250.0f));
            float[][] flatness = new float[this.DECIMATION][length];
            int index = 0;
            Iterator i = this.msglist.iterator();
            while (i.hasNext()) {
                System.arraycopy(((MsgAudioSpectrumFlatness)i.next()).getFlatness(), dim250, flatness[index], 0, length);
                ++index;
            }
            float[] mean = Function.mean_arith(flatness);
            float[] var = Function.variance(flatness, mean);
            this.send(new MsgAudioSignature(time, hopsize * this.DECIMATION, 30, mean, var, hi_edge, this.DECIMATION));
            this.msglist.clear();
        }
    }
}

