/*
 * Decompiled with CFR 0.152.
 */
package org.spantus.mpeg7.io;

import de.crysandt.audio.mpeg7audio.MP7DocumentBuilder;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.xml.parsers.ParserConfigurationException;
import org.spantus.core.FrameValues;
import org.spantus.core.FrameVectorValues;
import org.spantus.core.extractor.IExtractorConfig;
import org.spantus.core.extractor.IExtractorInputReader;
import org.spantus.core.extractor.IGeneralExtractor;
import org.spantus.core.extractor.SignalFormat;
import org.spantus.core.io.AudioReader;
import org.spantus.exception.ProcessingException;
import org.spantus.logger.Logger;
import org.spantus.mpeg7.config.Mpeg7ConfigUtil;
import org.spantus.mpeg7.extractors.AudioDescriptorExtractor;
import org.spantus.mpeg7.extractors.AudioDescriptorVectorExtractor;
import org.spantus.mpeg7.extractors.Mpeg7ExtractorInputReader;
import org.spantus.mpeg7.io.Mpeg7Utils;
import org.spantus.utils.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Mpeg7ReaderImpl
implements AudioReader {
    Logger log = Logger.getLogger(this.getClass());

    public AudioFileFormat getAudioFormat(URL url) {
        try {
            return AudioSystem.getAudioFileFormat(url);
        }
        catch (UnsupportedAudioFileException e) {
            throw new ProcessingException((Throwable)e);
        }
        catch (IOException e) {
            throw new ProcessingException((Throwable)e);
        }
    }

    public void readSignal(URL url, IExtractorInputReader reader) throws ProcessingException {
        try {
            this.readInternal(url, reader);
        }
        catch (IOException e) {
            throw new ProcessingException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new ProcessingException((Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new ProcessingException((Throwable)e);
        }
    }

    public void readInternal(URL url, IExtractorInputReader reader) throws IOException, ParserConfigurationException, URISyntaxException {
        IExtractorConfig conf = null;
        try {
            if (reader instanceof Mpeg7ExtractorInputReader) {
                conf = ((Mpeg7ExtractorInputReader)reader).getConfig();
            }
            Document mpeg7doc = MP7DocumentBuilder.encode(AudioSystem.getAudioInputStream(url), Mpeg7ConfigUtil.getConfig(conf));
            this.transform(reader, mpeg7doc);
            Mpeg7ConfigUtil.postprocess(reader, conf);
        }
        catch (UnsupportedAudioFileException e) {
            this.log.debug("Reading as audio file failed. It will try to read as xml");
            try {
                this.transform(reader, Mpeg7Utils.readDocument(url.toURI()));
            }
            catch (ProcessingException pe) {
                this.log.error("It is not possible read file as xml");
                this.log.error((Exception)((Object)pe));
            }
        }
    }

    public void transform(IExtractorInputReader reader, Document doc) {
        List<Element> audioDescs = Mpeg7Utils.getAudioDescriptors(doc);
        for (Element descriptor : audioDescs) {
            Mpeg7Utils.register(reader, this.readSeries(descriptor));
        }
    }

    protected IGeneralExtractor readSeries(Element descriptor) {
        String type = Mpeg7Utils.getAttr(descriptor, Mpeg7Utils.Mpeg7attrs.xsi_type);
        Assert.isTrue((!"".equals(type) ? 1 : 0) != 0, (String)"Type not found");
        FrameVectorValues vectorVals = new FrameVectorValues();
        FrameValues vals = new FrameValues();
        vectorVals = this.readSeriesOfScalar(descriptor);
        if (vectorVals != null) {
            if (vectorVals.size() == 1) {
                AudioDescriptorExtractor extractor = new AudioDescriptorExtractor();
                extractor.setName(type);
                extractor.putValues(0L, new FrameValues((Collection)vectorVals.getFirst()));
                extractor.getOutputValues().setSampleRate(vectorVals.getSampleRate());
                extractor.getConfig().setSampleRate(vectorVals.getSampleRate());
                return extractor;
            }
            AudioDescriptorVectorExtractor extractor = new AudioDescriptorVectorExtractor();
            extractor.setName(type);
            extractor.putValues(vectorVals);
            extractor.setSampleRate(vectorVals.getSampleRate());
            return extractor;
        }
        vectorVals = this.readSeriesOfVector(descriptor);
        if (vectorVals != null) {
            AudioDescriptorVectorExtractor extractor = new AudioDescriptorVectorExtractor();
            extractor.setName(type);
            extractor.putValues(vectorVals);
            extractor.setSampleRate(vectorVals.getSampleRate());
            return extractor;
        }
        vals = this.readScalar(descriptor);
        if (vals != null) {
            AudioDescriptorExtractor extractor = new AudioDescriptorExtractor();
            extractor.getConfig().setSampleRate(vals.getSampleRate());
            extractor.setName(type);
            extractor.putValues(0L, vals);
            extractor.getOutputValues().setSampleRate(vals.getSampleRate());
            return extractor;
        }
        StringBuilder bld = new StringBuilder();
        bld.append("Type: ").append(type).append(";").append(descriptor.toString());
        Mpeg7Utils.traverseDOMBranch(descriptor, bld);
        throw new ProcessingException("type not implemented: " + bld.toString());
    }

    protected FrameValues readScalar(Element descriptor) {
        Element scalar = Mpeg7Utils.getFirstElement(descriptor, Mpeg7Utils.Mpeg7nodes.Scalar);
        if (scalar == null) {
            return null;
        }
        Float float1 = Float.valueOf(0.0f);
        try {
            float1 = Float.valueOf(Mpeg7Utils.readScalar(scalar));
        }
        catch (NumberFormatException nfe) {
            this.log.error("Number format exception: " + nfe.getMessage());
        }
        FrameValues vals = new FrameValues();
        vals.add((Object)float1);
        return vals;
    }

    protected FrameVectorValues readSeriesOfScalar(Element descriptor) {
        Element seriesOfScalar = Mpeg7Utils.getFirstElement(descriptor, Mpeg7Utils.Mpeg7nodes.SeriesOfScalar);
        if (seriesOfScalar == null) {
            return null;
        }
        int totalNumOfSamples = Integer.valueOf(Mpeg7Utils.getAttr(seriesOfScalar, Mpeg7Utils.Mpeg7attrs.totalNumOfSamples));
        FrameValues vals = null;
        FrameVectorValues fv3 = new FrameVectorValues();
        vals = this.readRaw(seriesOfScalar, Mpeg7Utils.Mpeg7nodes.Raw);
        if (vals != null) {
            FrameValues valsWeight = this.readRaw(seriesOfScalar, Mpeg7Utils.Mpeg7nodes.Weight);
            Assert.isTrue((vals.size() == totalNumOfSamples ? 1 : 0) != 0, (String)("strs.length != totalNumOfSamples: " + vals.size() + "!=" + totalNumOfSamples));
            if (valsWeight != null) {
                fv3.add((List)valsWeight);
            } else {
                fv3.add((List)vals);
            }
        } else {
            vals = this.readRaw(seriesOfScalar, Mpeg7Utils.Mpeg7nodes.Mean);
            if (vals != null) {
                Assert.isTrue((vals.size() == totalNumOfSamples ? 1 : 0) != 0, (String)("strs.length != totalNumOfSamples: " + vals.size() + "!=" + totalNumOfSamples));
                fv3.add((List)vals);
            } else {
                vals = this.readRaw(seriesOfScalar, Mpeg7Utils.Mpeg7nodes.Min);
                if (vals != null) {
                    Assert.isTrue((vals.size() == totalNumOfSamples ? 1 : 0) != 0, (String)("strs.length != totalNumOfSamples: " + vals.size() + "!=" + totalNumOfSamples));
                    FrameValues valsMax = this.readRaw(seriesOfScalar, Mpeg7Utils.Mpeg7nodes.Max);
                    fv3 = Mpeg7ReaderImpl.readMinMax(vals, valsMax);
                }
            }
        }
        fv3.setSampleRate(this.readSampleRate(seriesOfScalar));
        return fv3;
    }

    protected FrameVectorValues readSeriesOfVector(Element element) {
        Element seriesOfVector = Mpeg7Utils.getFirstElement(element, Mpeg7Utils.Mpeg7nodes.SeriesOfVector);
        if (seriesOfVector == null) {
            return null;
        }
        int vectorSize = Integer.valueOf(Mpeg7Utils.getAttr(seriesOfVector, Mpeg7Utils.Mpeg7attrs.vectorSize));
        FrameVectorValues fv3 = null;
        fv3 = this.readVectors(seriesOfVector, Mpeg7Utils.Mpeg7nodes.Raw, vectorSize);
        Assert.isTrue((fv3 != null ? 1 : 0) != 0, (String)"samples not read");
        fv3.setSampleRate(this.readSampleRate(seriesOfVector));
        return fv3;
    }

    protected static FrameVectorValues readMinMax(FrameValues min, FrameValues max) {
        FrameVectorValues fv3 = new FrameVectorValues();
        Iterator maxIter = max.iterator();
        for (Float floatMin : min) {
            FrameValues fv = new FrameValues();
            Float floatMax = (Float)maxIter.next();
            fv.add((Object)floatMin);
            fv.add((Object)floatMax);
            fv3.add((List)fv);
        }
        return fv3;
    }

    protected FrameVectorValues readVectors(Element seriesOfValues, Mpeg7Utils.Mpeg7nodes node, int vectorSize) {
        String[] strs = Mpeg7Utils.readRaw(seriesOfValues, node);
        FrameVectorValues fv3 = new FrameVectorValues();
        FrameValues fv = new FrameValues();
        int i = 0;
        for (String float1 : strs) {
            if ("".equals(float1)) continue;
            fv.add((Object)Float.valueOf(float1));
            if (++i % vectorSize != 0) continue;
            fv3.add((List)fv);
            fv = new FrameValues();
        }
        fv3.setSampleRate(this.readSampleRate(seriesOfValues));
        return fv3;
    }

    protected FrameValues readRaw(Element seriesOfValues, Mpeg7Utils.Mpeg7nodes node) {
        return this.transformToFrameValue(Mpeg7Utils.readRaw(seriesOfValues, node));
    }

    protected float readSampleRate(Element series) {
        String type = Mpeg7Utils.getAttr((Element)series.getParentNode(), Mpeg7Utils.Mpeg7attrs.xsi_type);
        String hopSize = Mpeg7Utils.getAttr(series, Mpeg7Utils.Mpeg7attrs.hopSize);
        int mediaDuration = Mpeg7Utils.getMediaDuration(hopSize);
        if ("AudioSpectrumBasisType".equals(type)) {
            mediaDuration *= 5;
        }
        return 1000 / mediaDuration;
    }

    protected FrameValues transformToFrameValue(String[] strs) {
        if (strs == null) {
            return null;
        }
        FrameValues vals = new FrameValues();
        for (int i = 0; i < strs.length; ++i) {
            if ("".equals(strs[i])) continue;
            vals.add((Object)Float.valueOf(strs[i]));
        }
        return vals;
    }

    public SignalFormat getFormat(URL url) {
        return null;
    }

    public boolean isFormatSupported(URL url) {
        return false;
    }
}

