/*
 * Decompiled with CFR 0.152.
 */
package it.univpm.deit.audio;

import de.crysandt.audio.mpeg7audio.msgs.Msg;
import de.crysandt.audio.mpeg7audio.msgs.MsgListener;
import de.crysandt.audio.mpeg7audio.msgs.MsgSignalEnvelope;
import de.crysandt.audio.mpeg7audio.msgs.MsgSpeaker;
import de.crysandt.audio.mpeg7audio.msgs.MsgTemporalCentroid;
import java.util.ArrayList;

public class TemporalCentroid
extends MsgSpeaker
implements MsgListener {
    private final float samplerate;
    float num = 0.0f;
    float den = 0.0f;

    public TemporalCentroid(float samplerate) {
        this.samplerate = samplerate;
    }

    public void receivedMsg(Msg m) {
        if (m instanceof MsgSignalEnvelope) {
            this.receivedMsg((MsgSignalEnvelope)m);
        }
    }

    public void receivedMsg(MsgSignalEnvelope m) {
        float temporalCentroid = 0.0f;
        ArrayList signalEnv = m.signalEnv;
        for (int i = 1; i < signalEnv.size(); ++i) {
            this.num += (float)i / this.samplerate * (float)m.slide * ((Float)signalEnv.get(i)).floatValue();
            this.den += ((Float)signalEnv.get(i)).floatValue();
        }
        temporalCentroid = this.num / this.den;
        this.send(new MsgTemporalCentroid(m.time, m.duration, temporalCentroid));
    }
}

