/*
 * Decompiled with CFR 0.152.
 */
package it.univpm.deit.audio;

import de.crysandt.audio.mpeg7audio.msgs.Msg;
import de.crysandt.audio.mpeg7audio.msgs.MsgEndOfSignal;
import de.crysandt.audio.mpeg7audio.msgs.MsgListener;
import de.crysandt.audio.mpeg7audio.msgs.MsgResizer;
import de.crysandt.audio.mpeg7audio.msgs.MsgSignalEnvelope;
import de.crysandt.audio.mpeg7audio.msgs.MsgSpeaker;
import de.crysandt.math.Function;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

public class SignalEnvelope
extends MsgSpeaker
implements MsgListener {
    private static final int LENGTH_FRAME = 30;
    private ArrayList signalEnv = new ArrayList();
    private LinkedList msglist = new LinkedList();
    private int position = 0;
    private int windowlength;
    private int windowslide;

    public SignalEnvelope(int windowlength, int windowslide) {
        this.windowlength = windowlength;
        this.windowslide = windowslide;
    }

    public void receivedMsg(Msg m) {
        if (m instanceof MsgResizer) {
            this.receivedMsg((MsgResizer)m);
        }
        if (m instanceof MsgEndOfSignal) {
            this.receivedMsg((MsgEndOfSignal)m);
        }
    }

    private void receivedMsg(MsgResizer m) {
        this.msglist.addLast(m);
        if (this.position != 0) {
            this.position -= m.getSignalLength();
        }
        if (30 % m.duration != 0) {
            throw new AssertionError();
        }
        if (this.msglist.size() * m.duration == 30) {
            int k;
            int length = 0;
            Iterator i = this.msglist.iterator();
            while (i.hasNext()) {
                length += ((MsgResizer)i.next()).getSignalLength();
            }
            float[] s = new float[length];
            i = this.msglist.iterator();
            int index = 0;
            while (i.hasNext()) {
                float[] source = ((MsgResizer)i.next()).getSignal();
                System.arraycopy(source, 0, s, index, source.length);
                index += source.length;
            }
            for (k = this.position; k <= s.length - this.windowlength; k += this.windowslide) {
                int j;
                float irms = 0.0f;
                for (j = k; j < k + this.windowlength; ++j) {
                    irms += Function.square(s[j]);
                }
                irms /= (float)(j - k);
                irms = (float)Math.sqrt(irms);
                this.signalEnv.add(new Float(irms));
            }
            this.position = k;
            this.msglist.removeFirst();
        }
        this.signalEnv.trimToSize();
    }

    public void receivedMsg(MsgEndOfSignal meos) {
        int time = meos.time;
        int duration = meos.duration;
        this.send(new MsgSignalEnvelope(time, duration, this.signalEnv, this.windowslide));
        this.send(meos);
    }
}

