/*
 * Decompiled with CFR 0.152.
 */
package it.univpm.deit.audio;

import de.crysandt.audio.mpeg7audio.msgs.Msg;
import de.crysandt.audio.mpeg7audio.msgs.MsgListener;
import de.crysandt.audio.mpeg7audio.msgs.MsgLogAttackTime;
import de.crysandt.audio.mpeg7audio.msgs.MsgSignalEnvelope;
import de.crysandt.audio.mpeg7audio.msgs.MsgSpeaker;
import de.crysandt.math.Function;

public class LogAttackTime
extends MsgSpeaker
implements MsgListener {
    private float sampleRate;
    private float thresold;
    private float t0;
    private float t1;
    private float lat;

    public LogAttackTime(float sampleRate, float thresold) {
        this.sampleRate = sampleRate;
        this.thresold = thresold;
    }

    public void receivedMsg(Msg msg) {
        if (msg instanceof MsgSignalEnvelope) {
            this.receivedMsg((MsgSignalEnvelope)msg);
        }
    }

    public void receivedMsg(MsgSignalEnvelope msg) {
        int i;
        float max = ((Float)msg.signalEnv.get(0)).floatValue();
        this.t1 = 0.0f;
        for (i = 1; i < msg.signalEnv.size(); ++i) {
            if (!(((Float)msg.signalEnv.get(i)).floatValue() > max)) continue;
            max = ((Float)msg.signalEnv.get(i)).floatValue();
            this.t1 = (float)i * ((float)msg.slide / this.sampleRate);
        }
        for (i = 0; i < msg.signalEnv.size(); ++i) {
            if (!(((Float)msg.signalEnv.get(i)).floatValue() > this.thresold * max)) continue;
            this.t0 = (float)i * ((float)msg.slide / this.sampleRate);
            break;
        }
        this.lat = this.t1 - this.t0 < (float)msg.slide / this.sampleRate ? Function.log10((float)msg.slide / this.sampleRate) : Function.log10(this.t1 - this.t0);
        this.send(new MsgLogAttackTime(msg.time, msg.duration, this.lat));
    }
}

