/*
 * Decompiled with CFR 0.152.
 */
package it.univpm.deit.audio;

import de.crysandt.audio.mpeg7audio.msgs.Msg;
import de.crysandt.audio.mpeg7audio.msgs.MsgEndOfSignal;
import de.crysandt.audio.mpeg7audio.msgs.MsgHarmonicPeaks;
import de.crysandt.audio.mpeg7audio.msgs.MsgHarmonicSpectralVariation;
import de.crysandt.audio.mpeg7audio.msgs.MsgListener;
import de.crysandt.audio.mpeg7audio.msgs.MsgSpeaker;
import de.crysandt.math.Function;
import java.util.ArrayList;

public class HarmonicSpectralVariation
extends MsgSpeaker
implements MsgListener {
    private float num_hsv = 0.0f;
    private float hsv = 0.0f;
    private int nb_frames = 0;
    private ArrayList msgs = new ArrayList();

    public void receivedMsg(Msg msg) {
        if (msg instanceof MsgHarmonicPeaks) {
            this.receivedMsg((MsgHarmonicPeaks)msg);
        }
        if (msg instanceof MsgEndOfSignal) {
            this.receivedMsg((MsgEndOfSignal)msg);
        }
    }

    public void receivedMsg(MsgHarmonicPeaks mhp) {
        float num = 0.0f;
        float den1 = 0.0f;
        float den2 = 0.0f;
        this.msgs.add(mhp.getPeaks());
        if (this.msgs.size() == 2) {
            ArrayList peaks1 = (ArrayList)this.msgs.get(0);
            ArrayList peaks2 = (ArrayList)this.msgs.get(1);
            int size = peaks1.size() >= peaks2.size() ? peaks2.size() : peaks1.size();
            for (int i = 0; i < size; ++i) {
                num += ((float[])peaks1.get(i))[1] * ((float[])peaks2.get(i))[1];
                den1 += Function.square(((float[])peaks1.get(i))[1]);
                den2 += Function.square(((float[])peaks2.get(i))[1]);
            }
            float ihsv = 1.0f - num / ((float)Math.sqrt(den1) * (float)Math.sqrt(den2));
            this.num_hsv += ihsv;
            ++this.nb_frames;
            this.hsv = this.num_hsv / (float)this.nb_frames;
            this.msgs.remove(0);
        }
    }

    public void receivedMsg(MsgEndOfSignal meos) {
        int time = meos.time;
        int duration = meos.duration;
        this.send(new MsgHarmonicSpectralVariation(time, duration, this.hsv));
        this.send(meos);
    }
}

