/*
 * Decompiled with CFR 0.152.
 */
package it.univpm.deit.audio;

import de.crysandt.audio.mpeg7audio.msgs.Msg;
import de.crysandt.audio.mpeg7audio.msgs.MsgEndOfSignal;
import de.crysandt.audio.mpeg7audio.msgs.MsgHarmonicPeaks;
import de.crysandt.audio.mpeg7audio.msgs.MsgHarmonicSpectralDeviation;
import de.crysandt.audio.mpeg7audio.msgs.MsgListener;
import de.crysandt.audio.mpeg7audio.msgs.MsgSpeaker;
import de.crysandt.math.Function;
import java.util.ArrayList;

public class HarmonicSpectralDeviation
extends MsgSpeaker
implements MsgListener {
    private float num_hsd;
    private float hsd = 0.0f;
    private int nb_frames = 0;

    public void receivedMsg(Msg msg) {
        if (msg instanceof MsgHarmonicPeaks) {
            this.receivedMsg((MsgHarmonicPeaks)msg);
        }
        if (msg instanceof MsgEndOfSignal) {
            this.receivedMsg((MsgEndOfSignal)msg);
        }
    }

    public void receivedMsg(MsgHarmonicPeaks mhp) {
        float ihsd = 0.0f;
        float num = 0.0f;
        ArrayList peaks = mhp.getPeaks();
        int size = mhp.getHarmonicPeaksSize();
        float[] spectrumEnvelope = new float[size];
        if (size == 1) {
            ihsd = 0.0f;
        } else if (size == 2) {
            float[] pd1 = (float[])peaks.get(0);
            float[] pd2 = (float[])peaks.get(1);
            spectrumEnvelope[0] = spectrumEnvelope[1] = (pd1[1] + pd2[1]) / 2.0f;
            num = Math.abs(Function.log10(pd1[1]) - Function.log10(spectrumEnvelope[0])) + Math.abs(Function.log10(pd2[1]) - Function.log10(spectrumEnvelope[1]));
            ihsd = num / (float)size;
        } else {
            float[] pd1 = (float[])peaks.get(0);
            float[] pd2 = (float[])peaks.get(1);
            spectrumEnvelope[0] = (pd1[1] + pd2[1]) / 2.0f;
            for (int i = 1; i < spectrumEnvelope.length - 1; ++i) {
                pd1 = (float[])peaks.get(i - 1);
                pd2 = (float[])peaks.get(i);
                float[] pd3 = (float[])peaks.get(i + 1);
                spectrumEnvelope[i] = (pd1[1] + pd2[1] + pd3[1]) / 3.0f;
            }
            pd1 = (float[])peaks.get(size - 2);
            pd2 = (float[])peaks.get(size - 1);
            spectrumEnvelope[spectrumEnvelope.length - 1] = (pd1[1] + pd2[1]) / 2.0f;
            for (int j = 0; j < size; ++j) {
                pd1 = (float[])peaks.get(j);
                num += Math.abs(Function.log10(pd1[1]) - Function.log10(spectrumEnvelope[j]));
            }
            ihsd = num / (float)size;
        }
        this.num_hsd += ihsd;
        ++this.nb_frames;
        this.hsd = this.num_hsd / (float)this.nb_frames;
    }

    public void receivedMsg(MsgEndOfSignal meos) {
        int time = meos.time;
        int duration = meos.duration;
        this.send(new MsgHarmonicSpectralDeviation(time, duration, this.hsd));
        this.send(meos);
    }
}

