/*
 * Decompiled with CFR 0.152.
 */
package it.univpm.deit.audio;

import de.crysandt.audio.mpeg7audio.msgs.Msg;
import de.crysandt.audio.mpeg7audio.msgs.MsgClick;
import de.crysandt.audio.mpeg7audio.msgs.MsgEndOfSignal;
import de.crysandt.audio.mpeg7audio.msgs.MsgListener;
import de.crysandt.audio.mpeg7audio.msgs.MsgResizer;
import de.crysandt.audio.mpeg7audio.msgs.MsgSpeaker;
import java.util.Arrays;
import java.util.LinkedList;

public class Click
extends MsgSpeaker
implements MsgListener {
    private int channel = 1;
    private int position = 4;
    private double tresh = 25.0;
    private final float SAMPLE_RATE;
    private LinkedList clicks = new LinkedList();

    public Click(float samplerate) {
        this.SAMPLE_RATE = samplerate;
    }

    public void receivedMsg(Msg m) {
        if (m instanceof MsgResizer) {
            this.receivedMsg((MsgResizer)m);
        }
        if (m instanceof MsgEndOfSignal) {
            this.receivedMsg((MsgEndOfSignal)m);
        }
    }

    private void receivedMsg(MsgResizer m) {
        int k;
        int i;
        float[] s = m.getSignal();
        double[] d = new double[s.length];
        for (int i2 = 0; i2 < s.length; ++i2) {
            d[i2] = s[i2];
        }
        double[] highpass = new double[s.length];
        for (i = 4; i < d.length; ++i) {
            highpass[i] = (double)0.7821f * highpass[i - 1] - (double)0.67998f * highpass[i - 2] + (double)0.18268f * highpass[i - 3] - (double)0.030119f * highpass[i - 4] + (double)0.16718f * d[i] - (double)0.66872f * d[i - 1] + (double)1.0031f * d[i - 2] - (double)0.66872f * d[i - 3] + (double)0.16718f * d[i - 4];
        }
        for (i = 4; i < d.length; ++i) {
            if (!(highpass[i] < 0.0)) continue;
            highpass[i] = Math.abs(highpass[i]);
        }
        int n = 11;
        double[] windowslide = new double[n];
        double[] medianfilter = new double[highpass.length];
        double[] mdf = new double[highpass.length + (n - 1)];
        System.arraycopy(highpass, 0, mdf, (n - 1) / 2, highpass.length);
        for (int k2 = (n - 1) / 2; k2 < highpass.length; ++k2) {
            System.arraycopy(mdf, k2 - (n - 1) / 2, windowslide, 0, n);
            Arrays.sort(windowslide);
            medianfilter[k2 - (n - 1) / 2] = windowslide[(windowslide.length - 1) / 2];
        }
        int len = 11;
        double[] meanfilter = new double[medianfilter.length];
        double[] meanwindow = new double[len];
        double[] a = new double[medianfilter.length + (len - 1)];
        System.arraycopy(medianfilter, 0, a, (len + 1) / 2, medianfilter.length);
        for (k = 0; k < meanfilter.length; ++k) {
            System.arraycopy(a, k, meanwindow, 0, len);
            for (int i3 = 0; i3 < len; ++i3) {
                int n2 = k;
                meanfilter[n2] = meanfilter[n2] + meanwindow[i3] / (double)len;
            }
        }
        for (k = 0; k < highpass.length; ++k) {
            if (highpass[k] > this.tresh * meanfilter[k]) {
                Integer clickposition = new Integer(this.position - 5);
                if (!this.clicks.isEmpty()) {
                    Integer lastclick = (Integer)this.clicks.getLast();
                    if (clickposition - lastclick > 200) {
                        this.clicks.add(clickposition);
                    }
                } else {
                    this.clicks.add(clickposition);
                }
            }
            ++this.position;
        }
    }

    public void receivedMsg(MsgEndOfSignal meos) {
        int time = meos.time;
        int duration = meos.duration;
        this.send(new MsgClick(time, duration, this.clicks, this.channel, this.SAMPLE_RATE));
        this.send(meos);
    }
}

