/*
 * Decompiled with CFR 0.152.
 */
package it.univpm.deit.audio;

import de.crysandt.audio.mpeg7audio.msgs.Msg;
import de.crysandt.audio.mpeg7audio.msgs.MsgAudioSpectrum;
import de.crysandt.audio.mpeg7audio.msgs.MsgBandWidth;
import de.crysandt.audio.mpeg7audio.msgs.MsgEndOfSignal;
import de.crysandt.audio.mpeg7audio.msgs.MsgListener;
import de.crysandt.audio.mpeg7audio.msgs.MsgSpeaker;
import de.crysandt.math.Function;

public class BandWidth
extends MsgSpeaker
implements MsgListener {
    public final float samplerate;
    private int channel = 1;
    private float fs = 0.0f;
    private float bw = 0.0f;
    private int up_limit = 0;
    private double border = 0.0;
    private float[] maxpartspectrumarray = null;
    private int len = 0;
    private int fftlen = 0;

    public BandWidth(float samplerate) {
        this.samplerate = samplerate;
    }

    public void receivedMsg(Msg msg) {
        if (msg instanceof MsgAudioSpectrum) {
            this.receivedMsg((MsgAudioSpectrum)msg);
        }
        if (msg instanceof MsgEndOfSignal) {
            this.receivedMsg((MsgEndOfSignal)msg);
        }
    }

    public void receivedMsg(MsgAudioSpectrum m) {
        float[] partspectrum = m.getAudioSpectrum();
        this.fftlen = m.lengthFFT;
        this.len = m.getAudioSpectrumLength();
        if (this.maxpartspectrumarray == null) {
            this.maxpartspectrumarray = new float[this.len];
            System.arraycopy(partspectrum, 0, this.maxpartspectrumarray, 0, this.len);
        } else {
            for (int k = 0; k < this.len; ++k) {
                if (!(partspectrum[k] > this.maxpartspectrumarray[k])) continue;
                this.maxpartspectrumarray[k] = partspectrum[k];
            }
        }
    }

    public void receivedMsg(MsgEndOfSignal meos) {
        float[] lmps = new float[this.len];
        for (int k = 0; k < this.len; ++k) {
            lmps[k] = 10.0f * Function.log10(this.maxpartspectrumarray[k]);
        }
        float min_lmps = -3.0f;
        float max_lmps = Function.max(lmps);
        min_lmps = Function.min(lmps);
        this.border = (double)min_lmps + (double)(max_lmps - min_lmps) * 0.3;
        for (int i = 1; i < lmps.length - 1; ++i) {
            if (!((double)lmps[i + 1] < this.border) || !((double)lmps[i - 1] > this.border)) continue;
            this.up_limit = i;
        }
        this.fs = this.samplerate / (float)this.fftlen;
        this.bw = (float)this.up_limit * this.fs;
        int time = meos.time;
        int duration = meos.duration;
        this.send(new MsgBandWidth(time, duration, this.bw, this.channel));
        this.send(meos);
    }
}

