/*
 * Decompiled with CFR 0.152.
 */
package it.univpm.deit.audio;

import de.crysandt.audio.mpeg7audio.msgs.Msg;
import de.crysandt.audio.mpeg7audio.msgs.MsgAudioFundamentalFrequency;
import de.crysandt.audio.mpeg7audio.msgs.MsgAudioHarmonicity;
import de.crysandt.audio.mpeg7audio.msgs.MsgAudioSpectrum;
import de.crysandt.audio.mpeg7audio.msgs.MsgListener;
import de.crysandt.audio.mpeg7audio.msgs.MsgSpeaker;
import de.crysandt.math.Function;
import it.univpm.deit.FFT2N;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;

public class AudioHarmonicity
extends MsgSpeaker
implements MsgListener {
    private final int LENGTH_WINDOW = 30;
    private LinkedList<MsgAudioFundamentalFrequency> afflist = new LinkedList();
    private Map hamming = new TreeMap();
    private Map fft2n = new TreeMap();
    private float[] CombSpectrum;
    private float[] SignalSpectrum;
    private int SpectrumLength;
    private float dF;

    public void receivedMsg(Msg msg) {
        if (msg instanceof MsgAudioFundamentalFrequency) {
            MsgAudioFundamentalFrequency maff = (MsgAudioFundamentalFrequency)msg;
            this.afflist.addLast(maff);
            if (30 % maff.duration != 0) {
                throw new AssertionError();
            }
            if (this.afflist.size() * maff.duration == 30) {
                this.CombSpectrum = this.getCombSpectrum();
            }
        }
        if (msg instanceof MsgAudioSpectrum) {
            MsgAudioSpectrum mas = (MsgAudioSpectrum)msg;
            this.SignalSpectrum = mas.getAudioSpectrum();
            this.SpectrumLength = mas.getAudioSpectrumLength();
            this.dF = mas.deltaF;
        }
        if (this.afflist.size() * msg.duration == 30) {
            int uplimit = this.getUpperLimit(this.SignalSpectrum, this.CombSpectrum);
            float uplimitfreq = this.upperFrequency(uplimit);
            MsgAudioFundamentalFrequency msgaff = this.afflist.getLast();
            this.send(new MsgAudioHarmonicity(msgaff.time, msgaff.duration, msgaff.confidence, uplimitfreq));
            this.afflist.removeFirst();
        }
    }

    private float[] getHamming(int length) {
        Integer key = new Integer(length);
        float[] window = (float[])this.hamming.get(key);
        if (window == null) {
            window = new float[length];
            for (int n = 0; n < window.length; ++n) {
                window[n] = (float)(0.54 - 0.46 * Math.cos((double)n * 2.0 * Math.PI / (double)(window.length - 1)));
            }
            this.hamming.put(key, window);
        }
        return window;
    }

    private FFT2N getFFT2N(int length_fft) {
        Integer key = new Integer(length_fft);
        FFT2N fft = (FFT2N)this.fft2n.get(key);
        if (fft == null) {
            fft = new FFT2N(length_fft);
            this.fft2n.put(key, fft);
        }
        return fft;
    }

    private float[] getCombSpectrum() {
        float[] signal;
        int length = 0;
        Iterator i = this.afflist.iterator();
        while (i.hasNext()) {
            length += ((MsgAudioFundamentalFrequency)i.next()).getCombSignalLength();
        }
        float[] s = new float[length];
        i = this.afflist.iterator();
        int index = 0;
        while (i.hasNext()) {
            float[] source = ((MsgAudioFundamentalFrequency)i.next()).getCombSignal();
            System.arraycopy(source, 0, s, index, source.length);
            index += source.length;
        }
        float[] window = this.getHamming(s.length);
        for (int n = 0; n < window.length; ++n) {
            int n2 = n;
            s[n2] = s[n2] * window[n];
        }
        int length_fft = (int)Math.ceil(Function.log2(s.length));
        length_fft = (int)Math.pow(2.0, length_fft);
        FFT2N fft = this.getFFT2N(length_fft);
        if (length_fft == s.length) {
            signal = s;
        } else {
            signal = new float[length_fft];
            System.arraycopy(s, 0, signal, 0, s.length);
            Arrays.fill(signal, s.length, signal.length, 0.0f);
        }
        fft.fft(signal);
        float[] ps = FFT2N.PowerSpectrum(signal);
        return ps;
    }

    private int getUpperLimit(float[] sigspec, float[] combspec) {
        for (int lolimit = this.SpectrumLength - 1; lolimit >= 0; --lolimit) {
            float SignalPower = 0.0f;
            float CombedSignalPower = 0.0f;
            for (int i = this.SpectrumLength - 1; i >= lolimit; --i) {
                SignalPower += sigspec[i];
                CombedSignalPower += combspec[i];
            }
            if (!((double)(CombedSignalPower / SignalPower) < 0.5)) continue;
            return lolimit;
        }
        return 0;
    }

    private float upperFrequency(int index) {
        float[] fArray = new float[]{31.25f, 62.5f, 125.0f, 250.0f, 500.0f, 1000.0f, 2000.0f, 4000.0f, 8000.0f, 16000.0f};
        float freq = (float)index * this.dF;
        float[] octaves = fArray;
        if (freq < octaves[0]) {
            return octaves[0];
        }
        if (freq > octaves[9]) {
            return octaves[9];
        }
        int i = 1;
        while (freq > octaves[i]) {
            ++i;
        }
        if (freq < (octaves[i] + octaves[i - 1]) / 2.0f) {
            return octaves[i - 1];
        }
        return octaves[i];
    }
}

