/*
 * Decompiled with CFR 0.152.
 */
package it.univpm.deit.audio;

import de.crysandt.audio.mpeg7audio.msgs.Msg;
import de.crysandt.audio.mpeg7audio.msgs.MsgAudioFundamentalFrequency;
import de.crysandt.audio.mpeg7audio.msgs.MsgListener;
import de.crysandt.audio.mpeg7audio.msgs.MsgResizer;
import de.crysandt.audio.mpeg7audio.msgs.MsgSpeaker;
import de.crysandt.math.FFT2N;
import de.crysandt.math.Function;
import it.univpm.deit.audio.RawAndWeight;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;

public class AudioFundamentalFrequency
extends MsgSpeaker
implements MsgListener {
    private final int WINDOW_LENGTH;
    private final float SAMPLE_RATE;
    private final int HOP_SIZE;
    private final float LO_LIMIT;
    private final float HI_LIMIT;
    private final float MAX_HI_LIMIT = 44100.0f;
    private final LinkedList<MsgResizer> msglist = new LinkedList();
    private static LinkedList<RawAndWeight> maximums = new LinkedList();
    private static float Fs;

    public AudioFundamentalFrequency(int hopsize, float samplerate, float lolimit, float hilimit) {
        this.SAMPLE_RATE = samplerate;
        this.HOP_SIZE = hopsize;
        this.WINDOW_LENGTH = (int)Math.ceil(2000.0f / lolimit);
        this.LO_LIMIT = lolimit;
        this.HI_LIMIT = hilimit > 44100.0f ? 44100.0f : hilimit;
        Fs = this.SAMPLE_RATE;
    }

    public void receivedMsg(Msg msg) {
        if (msg instanceof MsgResizer) {
            this.receivedMsg((MsgResizer)msg);
        }
    }

    public void receivedMsg(MsgResizer m) {
        this.msglist.addLast(m);
        if (this.msglist.size() * m.duration == this.WINDOW_LENGTH) {
            int length = 0;
            Iterator i = this.msglist.iterator();
            while (i.hasNext()) {
                length += ((MsgResizer)i.next()).getSignalLength();
            }
            float[] signal = new float[length];
            i = this.msglist.iterator();
            int index = 0;
            while (i.hasNext()) {
                float[] source = ((MsgResizer)i.next()).getSignal();
                System.arraycopy(source, 0, signal, index, source.length);
                index += source.length;
            }
            int minlag = (int)Math.floor(this.SAMPLE_RATE / this.HI_LIMIT);
            int maxlag = (int)Math.floor(this.SAMPLE_RATE / this.LO_LIMIT);
            float[] crosscorrelation = AudioFundamentalFrequency.getCrossCorrelation(signal, minlag, maxlag);
            AudioFundamentalFrequency.findPeaks(crosscorrelation, minlag);
            float[] fundamental = AudioFundamentalFrequency.newPeak().toArray();
            int f0_lag = fundamental[0] != 0.0f ? (int)(this.SAMPLE_RATE / fundamental[0]) : 0;
            MsgResizer mr = this.msglist.get(0);
            float[] combedsignal = new float[mr.getSignalLength()];
            combedsignal = AudioFundamentalFrequency.getCombed(signal, f0_lag, mr.getSignalLength());
            this.send(new MsgAudioFundamentalFrequency(mr.time, mr.duration, this.LO_LIMIT, this.HI_LIMIT, fundamental[0], fundamental[1], combedsignal));
            this.msglist.removeFirst();
        }
    }

    private static float[] getCrossCorrelationOld(float[] signal, int minlag, int maxlag) {
        float[] crosscorrelation = new float[maxlag - minlag];
        for (int k = minlag; k < maxlag; ++k) {
            float c = 0.0f;
            float b = 0.0f;
            float a = 0.0f;
            for (int j = maxlag; j < signal.length; ++j) {
                a += signal[j] * signal[j - k];
                b += signal[j] * signal[j];
                c += signal[j - k] * signal[j - k];
            }
            crosscorrelation[k - minlag] = b == 0.0f || c == 0.0f ? 0.0f : (float)((double)a / Math.sqrt(b * c));
        }
        return crosscorrelation;
    }

    private static float[] getCrossCorrelation(float[] signal, int minlag, int maxlag) {
        int length_fft = 1 << Function.getHighestBit(signal.length - 1) + 1;
        int length_window = signal.length - maxlag;
        FFT2N fft = new FFT2N(length_fft);
        float[] f1 = new float[length_fft];
        System.arraycopy(signal, signal.length - length_window, f1, 0, length_window);
        fft.fft(f1);
        float[] f2 = new float[length_fft];
        System.arraycopy(signal, 0, f2, 0, signal.length);
        fft.fft(f2);
        FFT2N.conj(f1);
        f1 = FFT2N.mult(f1, f2);
        fft.ifft(f1);
        float[] power = new float[signal.length];
        for (int i = 0; i < power.length; ++i) {
            power[i] = signal[i] * signal[i];
        }
        double power_0 = 0.0;
        for (int i = signal.length - length_window; i < signal.length; ++i) {
            power_0 += (double)power[i];
        }
        float sqrt_power_0 = (float)Math.sqrt(power_0);
        float[] corr = new float[maxlag - minlag];
        double power_j = 0.0;
        int j_max = maxlag - minlag + length_window;
        for (int j = maxlag - minlag + 1; j < j_max; ++j) {
            power_j += (double)power[j];
        }
        int i = 0;
        int j = maxlag - minlag;
        while (i < corr.length) {
            corr[i] = (power_j += (double)power[j]) > 0.0 && sqrt_power_0 > 0.0f ? f1[j] / sqrt_power_0 / (float)Math.sqrt(power_j) : 0.0f;
            ++i;
            power_j -= (double)power[--j + length_window];
        }
        return corr;
    }

    static float[] arraymax(float[] array, boolean abs_max) {
        if (abs_max) {
            float[] max = new float[]{Math.abs(array[0]), 0.0f};
            for (int index = 0; index < array.length; ++index) {
                if (!(Math.abs(array[index]) > Math.abs(max[0]))) continue;
                max[0] = Math.abs(array[index]);
                max[1] = index;
            }
            return max;
        }
        float[] max = new float[]{array[0], 0.0f};
        for (int index = 0; index < array.length; ++index) {
            if (!(array[index] > max[0])) continue;
            max[0] = array[index];
            max[1] = index;
        }
        return max;
    }

    static float[] getCombed(float[] signal, int K, int framelength) {
        int i;
        float[] c = new float[framelength];
        float b = 0.0f;
        float a = 0.0f;
        for (i = signal.length - (framelength - 1); i < signal.length; ++i) {
            a += signal[i] * signal[i - K];
            b += signal[i - K] * signal[i - K];
        }
        float d = a / b;
        for (i = signal.length - (framelength - 1); i < signal.length; ++i) {
            c[i - (signal.length - (framelength - 1))] = signal[i] - d * signal[i - K];
        }
        return c;
    }

    static void findPeaks(float[] array, int minlag) {
        maximums.removeAll(maximums);
        for (int index = 10; index < array.length - 10; ++index) {
            for (int j = 1; j < 10 && array[index - j] < array[index] && array[index + j] < array[index]; ++j) {
                if (j != 9) continue;
                maximums.add(new RawAndWeight(Fs / (float)(index + minlag), array[index]));
            }
        }
        Collections.sort(maximums);
    }

    private static RawAndWeight newPeak() {
        RawAndWeight result = null;
        float tollerance = 0.01f;
        if (maximums.isEmpty()) {
            return new RawAndWeight(0.0f, 0.0f);
        }
        result = maximums.getFirst();
        for (RawAndWeight actual : maximums) {
            if (!(actual.weigth >= result.weigth - tollerance)) continue;
            result = actual;
        }
        return result;
    }
}

