/*
 * Decompiled with CFR 0.152.
 */
package it.univpm.deit;

public final class FFT2N {
    private final Butterfly butterfly;
    public final int length;

    public FFT2N(int length) throws IllegalArgumentException {
        if (!this.isPowerOf2(length)) {
            throw new IllegalArgumentException("length must be a power of 2");
        }
        this.length = length;
        this.butterfly = this.getButterfly(length);
    }

    private Butterfly getButterfly(int length) {
        switch (length) {
            case 2: {
                return new Butterfly2();
            }
            case 4: {
                return new Butterfly4();
            }
        }
        return new Butterfly2n(length, this.getButterfly(length / 2));
    }

    public void fft2(float[] re, float[] im) {
        this.butterfly.fft(re, im);
    }

    public void fft2(float[] re) {
        this.butterfly.fft(re);
    }

    public static float[] PowerSpectrum(float[] re, float[] im) {
        int i;
        float[] power = new float[re.length / 2 + 1];
        for (i = 0; i < power.length; ++i) {
            int n = i;
            power[n] = power[n] + (re[i] * re[i] + im[i] * im[i]);
        }
        while (i < re.length) {
            int n = re.length - i;
            power[n] = power[n] + (re[i] * re[i] + im[i] * im[i]);
            ++i;
        }
        return power;
    }

    public static float[] PowerSpectrum(float[] re) {
        int i;
        float[] power = new float[re.length / 2 + 1];
        for (i = 0; i < power.length; ++i) {
            int n = i;
            power[n] = power[n] + re[i] * re[i];
        }
        while (i < re.length) {
            int n = re.length - i;
            power[n] = power[n] + re[i] * re[i];
            int n2 = re.length - i;
            power[n2] = (float)((double)power[n2] * 2.0);
            ++i;
        }
        return power;
    }

    private boolean isPowerOf2(int x) {
        while ((x & 1) == 0) {
            x >>= 1;
        }
        return x == 1;
    }

    private static float[] wRe(int length) {
        float[] w_re = new float[length];
        for (int i = 0; i < w_re.length; ++i) {
            w_re[i] = (float)Math.cos(Math.PI * 2 * (double)i / (double)length);
        }
        return w_re;
    }

    private static float[] wIm(int length) {
        float[] w_im = new float[length];
        for (int i = 0; i < w_im.length; ++i) {
            w_im[i] = (float)(-Math.sin(Math.PI * 2 * (double)i / (double)length));
        }
        return w_im;
    }

    private void perfectShuffle(float[] src, float[] dest, int blocksize) {
        for (int b = 0; b < src.length; b += blocksize) {
            int i_max;
            int k;
            int i = k = b;
            int j = i_max = b + blocksize / 2;
            while (i < i_max) {
                dest[k++] = src[i++];
                dest[k++] = src[j++];
            }
        }
    }

    public void fft(float[] re, float[] im) {
        int i = re.length >>> 1;
        int j = i << 1;
        float[] data = new float[j + 1];
        while (--i >= 0) {
            data[j--] = im[i];
            data[j--] = re[i];
        }
        i = re.length >>> 1;
        j = 3;
        FFT2N.fou(data, i);
        while (--i > 0) {
            re[i] = data[j++];
            im[i] = data[j++];
        }
        im[0] = data[2];
        re[0] = data[1];
    }

    private static void fou(float[] data, int nn) {
        int m;
        int i;
        int n = nn << 1;
        int j = 1;
        for (i = 1; i < n; i += 2) {
            if (j > i) {
                float tmp = data[j];
                data[j] = data[i];
                data[i] = tmp;
                tmp = data[j + 1];
                data[j + 1] = data[i + 1];
                data[i + 1] = tmp;
            }
            for (m = nn; m >= 2 && j > m; j -= m, m >>= 1) {
            }
            j += m;
        }
        int mmax = 2;
        while (n > mmax) {
            int istep = mmax << 1;
            float theta = (float)Math.PI * 2 / (float)mmax;
            float wtemp = (float)Math.sin(0.5 * (double)theta);
            float wpr = -2.0f * wtemp * wtemp;
            float wpi = (float)Math.sin(theta);
            float wr = 1.0f;
            float wi = 0.0f;
            for (m = 1; m < mmax; m += 2) {
                for (i = m; i <= n; i += istep) {
                    j = i + mmax;
                    float tempr = wr * data[j] - wi * data[j + 1];
                    float tempi = wr * data[j + 1] + wi * data[j];
                    data[j] = data[i] - tempr;
                    data[j + 1] = data[i + 1] - tempi;
                    int n2 = i;
                    data[n2] = data[n2] + tempr;
                    int n3 = i + 1;
                    data[n3] = data[n3] + tempi;
                }
                wtemp = wr;
                wr = wtemp * wpr - wi * wpi + wr;
                wi = wi * wpr + wtemp * wpi + wi;
            }
            mmax = istep;
        }
    }

    public void fft(float[] re) {
        float h1r;
        int n = re.length;
        float[] data = new float[n + 1];
        float c1 = 0.5f;
        float c2 = -0.5f;
        int i = n;
        while (--i >= 0) {
            data[i + 1] = re[i];
        }
        float theta = (float)Math.PI / (float)(n >>> 1);
        FFT2N.fou(data, n >>> 1);
        float wtemp = (float)Math.sin(0.5 * (double)theta);
        float wpr = -2.0f * wtemp * wtemp;
        float wpi = (float)Math.sin(theta);
        float wr = 1.0f + wpr;
        float wi = wpi;
        int np3 = n + 3;
        for (i = 2; i <= n >>> 2; ++i) {
            int i1 = i + i - 1;
            int i2 = 1 + i1;
            int i3 = np3 - i2;
            int i4 = 1 + i3;
            h1r = c1 * (data[i1] + data[i3]);
            float h1i = c1 * (data[i2] - data[i4]);
            float h2r = -c2 * (data[i2] + data[i4]);
            float h2i = c2 * (data[i1] - data[i3]);
            data[i1] = h1r + wr * h2r - wi * h2i;
            data[i2] = h1i + wr * h2i + wi * h2r;
            data[i3] = h1r - wr * h2r + wi * h2i;
            data[i4] = -h1i + wr * h2i + wi * h2r;
            wtemp = wr;
            wr = wtemp * wpr - wi * wpi + wr;
            wi = wi * wpr + wtemp * wpi + wi;
        }
        h1r = data[1];
        data[1] = h1r + data[2];
        data[2] = h1r - data[2];
        int j = 1;
        int k = n - 1;
        i = n >>> 1;
        while (--i > 0) {
            re[k--] = -data[j + j + 2];
            re[j] = data[j + j + 1];
            ++j;
        }
        re[j] = data[2];
        re[0] = data[1];
    }

    public static void main(String[] args) {
        float[] signal = new float[]{0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        FFT2N fft2n = new FFT2N(signal.length);
        fft2n.fft(signal);
        assert (signal != null);
    }

    private class Butterfly2
    implements Butterfly {
        private Butterfly2() {
        }

        public void fft(float[] re, float[] im) {
            int l = 0;
            int l1 = 1;
            while (l < re.length) {
                float real = re[l] - re[l1];
                int n = l;
                re[n] = re[n] + re[l1];
                float imag = im[l] - im[l1];
                int n2 = l;
                im[n2] = im[n2] + im[l1];
                re[l1] = real;
                im[l1] = imag;
                l1 = 1 + (l += 2);
            }
        }

        public void fft(float[] re) {
            int l = 0;
            int l1 = 1;
            while (l < re.length) {
                float tmp = re[l] - re[l1];
                int n = l;
                re[n] = re[n] + re[l1];
                re[l1] = tmp;
                l1 = 1 + (l += 2);
            }
        }
    }

    private class Butterfly4
    implements Butterfly {
        private Butterfly2 butterfly2;

        private Butterfly4() {
            this.butterfly2 = new Butterfly2();
        }

        public void fft(float[] re, float[] im) {
            float[] tmp_re = new float[re.length];
            float[] tmp_im = new float[im.length];
            int l = 0;
            int l2 = 2;
            while (l < re.length) {
                tmp_re[l] = re[l] + re[l2];
                tmp_re[l2] = re[l] - re[l2];
                tmp_im[l] = im[l] + im[l2];
                tmp_im[l2] = im[l] - im[l2];
                tmp_re[++l2] = im[++l] - im[l2];
                tmp_im[l] = im[l] + im[l2];
                tmp_re[l] = re[l] + re[l2];
                tmp_im[l2] = re[l2] - re[l];
                l2 = 2 + (l += 3);
            }
            this.butterfly2.fft(tmp_re, tmp_im);
            FFT2N.this.perfectShuffle(tmp_re, re, 4);
            FFT2N.this.perfectShuffle(tmp_im, im, 4);
        }

        public void fft(float[] re) {
            for (int l = 0; l < re.length; l += 4) {
                int l1 = 1 + l;
                int l2 = 1 + l1;
                int l3 = 1 + l2;
                float tmp_0 = re[l] + re[l2];
                float tmp_2 = re[l1] + re[l3];
                int n = l3;
                re[n] = re[n] - re[l1];
                re[l1] = re[l] - re[l2];
                re[l] = tmp_0 + tmp_2;
                re[l2] = tmp_0 - tmp_2;
            }
        }
    }

    private static interface Butterfly {
        public void fft(float[] var1, float[] var2);

        public void fft(float[] var1);
    }

    private class Butterfly2n
    implements Butterfly {
        private int length;
        private Butterfly next;
        float[] w_re;
        float[] w_im;

        Butterfly2n(int length, Butterfly next) {
            this.length = length;
            this.next = next;
            this.w_re = FFT2N.wRe(length);
            this.w_im = FFT2N.wIm(length);
        }

        public void fft(float[] re, float[] im) {
            float[] tmp_re = new float[re.length];
            float[] tmp_im = new float[im.length];
            for (int l = 0; l < re.length; l += this.length) {
                int j;
                int i = l;
                int imax = j = l + this.length / 2;
                int k = 0;
                while (i < imax) {
                    float real = re[i];
                    tmp_re[i] = real + re[j];
                    float imag = im[i];
                    tmp_im[i] = imag + im[j];
                    tmp_re[j] = (real -= re[j]) * this.w_re[k] - (imag -= im[j]) * this.w_im[k];
                    tmp_im[j] = real * this.w_im[k] + imag * this.w_re[k];
                    ++i;
                    ++j;
                    ++k;
                }
            }
            this.next.fft(tmp_re, tmp_im);
            FFT2N.this.perfectShuffle(tmp_re, re, this.length);
            FFT2N.this.perfectShuffle(tmp_im, im, this.length);
        }

        public void fft(float[] re) {
            float[] tmp_re = new float[re.length / 2];
            float[] tmp_im = new float[re.length / 2];
            int i = 0;
            int j = 0;
            while (i < re.length) {
                tmp_re[j] = re[i++];
                tmp_im[j] = re[i++];
                ++j;
            }
            this.next.fft(tmp_re, tmp_im);
            re[0] = tmp_re[0] + tmp_im[0];
            re[re.length / 2] = tmp_re[0] - tmp_im[0];
            int i2 = 1;
            int j2 = tmp_re.length - 1;
            int ii = 2 + j2;
            int jj = re.length - 1;
            while (i2 <= j2) {
                float rp = (tmp_re[i2] + tmp_re[j2]) / 2.0f;
                float rm = (tmp_re[i2] - tmp_re[j2]) / 2.0f;
                float ip = (tmp_im[i2] + tmp_im[j2]) / 2.0f;
                float im = (tmp_im[i2] - tmp_im[j2]) / 2.0f;
                float tmp0 = this.w_re[i2] * ip + this.w_im[i2] * rm;
                re[i2] = rp + tmp0;
                re[j2] = rp - tmp0;
                tmp0 = this.w_im[i2] * ip - this.w_re[i2] * rm;
                re[ii] = tmp0 - im;
                re[jj] = tmp0 + im;
                ++i2;
                ++ii;
                --j2;
                --jj;
            }
        }
    }
}

