/*
 * Decompiled with CFR 0.152.
 */
package de.crysandt.math;

import java.util.Arrays;

public final class SVD {
    private float[][] U;
    private float[][] V;
    private float[] s;
    private int m;
    private int n;

    public SVD(float[][] X, int rows, int cols) {
        this(X, rows, cols, true, true);
    }

    public SVD(float[][] X, int rows, int cols, boolean WANTU, boolean WANTV) {
        int k;
        double t;
        this.m = rows;
        this.n = cols;
        float[][] A = new float[this.m][this.n];
        for (int i = 0; i < this.m; ++i) {
            System.arraycopy(X[i], 0, A[i], 0, this.n);
        }
        int nu = Math.min(this.m, this.n);
        this.s = new float[Math.min(this.m + 1, this.n)];
        this.U = WANTU ? new float[this.m][nu] : (float[][])null;
        this.V = WANTV ? new float[this.n][this.n] : (float[][])null;
        double[] e = new double[this.n];
        double[] work = new double[this.m];
        int nct = Math.min(this.m - 1, this.n);
        int nrt = Math.max(0, Math.min(this.n - 2, this.m));
        int k_max = Math.max(nct, nrt);
        for (int k2 = 0; k2 < k_max; ++k2) {
            int i;
            if (k2 < nct) {
                double sk = 0.0;
                for (i = k2; i < this.m; ++i) {
                    sk = SVD.hypot(sk, A[i][k2]);
                }
                if (sk != 0.0) {
                    if (A[k2][k2] < 0.0f) {
                        sk = -sk;
                    }
                    for (i = k2; i < this.m; ++i) {
                        float[] fArray = A[i];
                        int n = k2;
                        fArray[n] = (float)((double)fArray[n] / sk);
                    }
                    float[] fArray = A[k2];
                    int n = k2;
                    fArray[n] = fArray[n] + 1.0f;
                }
                this.s[k2] = (float)(-sk);
            }
            for (int j = k2 + 1; j < this.n; ++j) {
                if (k2 < nct & this.s[k2] != 0.0f) {
                    int i2;
                    t = 0.0;
                    for (i2 = k2; i2 < this.m; ++i2) {
                        t += (double)(A[i2][k2] * A[i2][j]);
                    }
                    t /= (double)(-A[k2][k2]);
                    for (i2 = k2; i2 < this.m; ++i2) {
                        float[] fArray = A[i2];
                        int n = j;
                        fArray[n] = (float)((double)fArray[n] + t * (double)A[i2][k2]);
                    }
                }
                e[j] = A[k2][j];
            }
            if (WANTU & k2 < nct) {
                for (int i3 = k2; i3 < this.m; ++i3) {
                    this.U[i3][k2] = A[i3][k2];
                }
            }
            if (k2 >= nrt) continue;
            double ek = 0.0;
            for (i = k2 + 1; i < this.n; ++i) {
                ek = SVD.hypot(ek, e[i]);
            }
            e[k2] = ek;
            if (e[k2] != 0.0) {
                if (e[k2 + 1] < 0.0) {
                    e[k2] = -e[k2];
                }
                i = k2 + 1;
                while (i < this.n) {
                    int n = i++;
                    e[n] = e[n] / e[k2];
                }
                int n = k2 + 1;
                e[n] = e[n] + 1.0;
            }
            e[k2] = -e[k2];
            if (k2 + 1 < this.m & e[k2] != 0.0) {
                int i4;
                int j;
                Arrays.fill(work, k2 + 1, this.m, 0.0);
                for (j = k2 + 1; j < this.n; ++j) {
                    double e_j = e[j];
                    for (i4 = k2 + 1; i4 < this.m; ++i4) {
                        int n = i4;
                        work[n] = work[n] + e_j * (double)A[i4][j];
                    }
                }
                for (j = k2 + 1; j < this.n; ++j) {
                    double t2 = -e[j] / e[k2 + 1];
                    for (i4 = k2 + 1; i4 < this.m; ++i4) {
                        float[] fArray = A[i4];
                        int n = j;
                        fArray[n] = (float)((double)fArray[n] + t2 * work[i4]);
                    }
                }
            }
            if (!WANTV) continue;
            for (i = k2 + 1; i < this.n; ++i) {
                this.V[i][k2] = (float)e[i];
            }
        }
        int p = Math.min(this.n, this.m + 1);
        if (nct < this.n) {
            this.s[nct] = A[nct][nct];
        }
        if (this.m < p) {
            this.s[p - 1] = 0.0f;
        }
        if (nrt + 1 < p) {
            e[nrt] = A[nrt][p - 1];
        }
        e[p - 1] = 0.0;
        if (WANTU) {
            for (int j = nct; j < nu; ++j) {
                for (int i = 0; i < this.m; ++i) {
                    this.U[i][j] = 0.0f;
                }
                this.U[j][j] = 1.0f;
            }
            for (k = nct - 1; k >= 0; --k) {
                int i;
                if ((double)this.s[k] != 0.0) {
                    for (int j = k + 1; j < nu; ++j) {
                        int i5;
                        t = 0.0;
                        for (i5 = k; i5 < this.m; ++i5) {
                            t += (double)(this.U[i5][k] * this.U[i5][j]);
                        }
                        t /= (double)(-this.U[k][k]);
                        for (i5 = k; i5 < this.m; ++i5) {
                            float[] fArray = this.U[i5];
                            int n = j;
                            fArray[n] = (float)((double)fArray[n] + t * (double)this.U[i5][k]);
                        }
                    }
                    for (i = k; i < this.m; ++i) {
                        this.U[i][k] = -this.U[i][k];
                    }
                    float[] fArray = this.U[k];
                    int n = k;
                    fArray[n] = fArray[n] + 1.0f;
                    for (i = 0; i < k - 1; ++i) {
                        this.U[i][k] = 0.0f;
                    }
                    continue;
                }
                for (i = 0; i < this.m; ++i) {
                    this.U[i][k] = 0.0f;
                }
                this.U[k][k] = 1.0f;
            }
        }
        if (WANTV) {
            for (k = this.n - 1; k >= 0; --k) {
                if (k < nrt & e[k] != 0.0) {
                    for (int j = k + 1; j < nu; ++j) {
                        int i;
                        t = 0.0;
                        for (i = k + 1; i < this.n; ++i) {
                            t += (double)(this.V[i][k] * this.V[i][j]);
                        }
                        t /= (double)(-this.V[k + 1][k]);
                        for (i = k + 1; i < this.n; ++i) {
                            float[] fArray = this.V[i];
                            int n = j;
                            fArray[n] = (float)((double)fArray[n] + t * (double)this.V[i][k]);
                        }
                    }
                }
                for (int i = 0; i < this.n; ++i) {
                    this.V[i][k] = 0.0f;
                }
                this.V[k][k] = 1.0f;
            }
        }
        int pp = p - 1;
        int iter = 0;
        double eps = 1.4E-45f;
        block35: while (p > 0) {
            int kase;
            int k3;
            for (k3 = p - 2; k3 >= -1 && k3 != -1; --k3) {
                if (!(Math.abs(e[k3]) <= eps * (double)(Math.abs(this.s[k3]) + Math.abs(this.s[k3 + 1])))) continue;
                e[k3] = 0.0;
                break;
            }
            if (k3 == p - 2) {
                kase = 4;
            } else {
                int ks;
                for (ks = p - 1; ks >= k3 && ks != k3; --ks) {
                    double t3 = (ks != p ? Math.abs(e[ks]) : 0.0) + (ks != k3 + 1 ? Math.abs(e[ks - 1]) : 0.0);
                    if (!((double)Math.abs(this.s[ks]) <= eps * t3)) continue;
                    this.s[ks] = 0.0f;
                    break;
                }
                if (ks == k3) {
                    kase = 3;
                } else if (ks == p - 1) {
                    kase = 1;
                } else {
                    kase = 2;
                    k3 = ks;
                }
            }
            ++k3;
            switch (kase) {
                case 1: {
                    int i;
                    double sn;
                    double cs;
                    double t4;
                    double f = e[p - 2];
                    e[p - 2] = 0.0;
                    for (int j = p - 2; j >= k3; --j) {
                        t4 = SVD.hypot(this.s[j], f);
                        cs = (double)this.s[j] / t4;
                        sn = f / t4;
                        this.s[j] = (float)t4;
                        if (j != k3) {
                            f = -sn * e[j - 1];
                            e[j - 1] = cs * e[j - 1];
                        }
                        if (!WANTV) continue;
                        for (i = 0; i < this.n; ++i) {
                            t4 = cs * (double)this.V[i][j] + sn * (double)this.V[i][p - 1];
                            this.V[i][p - 1] = (float)(-sn * (double)this.V[i][j] + cs * (double)this.V[i][p - 1]);
                            this.V[i][j] = (float)t4;
                        }
                    }
                    continue block35;
                }
                case 2: {
                    int i;
                    double sn;
                    double cs;
                    double t4;
                    double f = e[k3 - 1];
                    e[k3 - 1] = 0.0;
                    for (int j = k3; j < p; ++j) {
                        t4 = SVD.hypot(this.s[j], f);
                        cs = (double)this.s[j] / t4;
                        sn = f / t4;
                        this.s[j] = (float)t4;
                        f = -sn * e[j];
                        int n = j;
                        e[n] = e[n] * cs;
                        if (!WANTU) continue;
                        for (i = 0; i < this.m; ++i) {
                            t4 = cs * (double)this.U[i][j] + sn * (double)this.U[i][k3 - 1];
                            this.U[i][k3 - 1] = (float)(-sn * (double)this.U[i][j] + cs * (double)this.U[i][k3 - 1]);
                            this.U[i][j] = (float)t4;
                        }
                    }
                    continue block35;
                }
                case 3: {
                    double scale = Math.max(Math.max(Math.max((double)Math.max(Math.abs(this.s[p - 1]), Math.abs(this.s[p - 2])), Math.abs(e[p - 2])), (double)Math.abs(this.s[k3])), Math.abs(e[k3]));
                    double sp = (double)this.s[p - 1] / scale;
                    double spm1 = (double)this.s[p - 2] / scale;
                    double epm1 = e[p - 2] / scale;
                    double sk = (double)this.s[k3] / scale;
                    double ek = e[k3] / scale;
                    double b = ((spm1 + sp) * (spm1 - sp) + epm1 * epm1) / 2.0;
                    double c = sp * epm1 * (sp * epm1);
                    double shift = 0.0;
                    if (b != 0.0 | c != 0.0) {
                        shift = (float)Math.sqrt(b * b + c);
                        if (b < 0.0) {
                            shift = -shift;
                        }
                        shift = c / (b + shift);
                    }
                    double f = (sk + sp) * (sk - sp) + shift;
                    double g = sk * ek;
                    for (int j = k3; j < p - 1; ++j) {
                        int i;
                        double t5 = SVD.hypot(f, g);
                        double cs = f / t5;
                        double sn = g / t5;
                        if (j != k3) {
                            e[j - 1] = t5;
                        }
                        f = cs * (double)this.s[j] + sn * e[j];
                        e[j] = cs * e[j] - sn * (double)this.s[j];
                        g = sn * (double)this.s[j + 1];
                        int n = j + 1;
                        this.s[n] = (float)((double)this.s[n] * cs);
                        if (WANTV) {
                            for (i = 0; i < this.n; ++i) {
                                t5 = cs * (double)this.V[i][j] + sn * (double)this.V[i][j + 1];
                                this.V[i][j + 1] = (float)(-sn * (double)this.V[i][j] + cs * (double)this.V[i][j + 1]);
                                this.V[i][j] = (float)t5;
                            }
                        }
                        t5 = SVD.hypot(f, g);
                        cs = f / t5;
                        sn = g / t5;
                        this.s[j] = (float)t5;
                        f = cs * e[j] + sn * (double)this.s[j + 1];
                        this.s[j + 1] = (float)(-sn * e[j] + cs * (double)this.s[j + 1]);
                        g = sn * e[j + 1];
                        int n2 = j + 1;
                        e[n2] = e[n2] * cs;
                        if (!WANTU || j >= this.m - 1) continue;
                        for (i = 0; i < this.m; ++i) {
                            t5 = cs * (double)this.U[i][j] + sn * (double)this.U[i][j + 1];
                            this.U[i][j + 1] = (float)(-sn * (double)this.U[i][j] + cs * (double)this.U[i][j + 1]);
                            this.U[i][j] = (float)t5;
                        }
                    }
                    e[p - 2] = f;
                    ++iter;
                    break;
                }
                case 4: {
                    if ((double)this.s[k3] <= 0.0) {
                        float f = this.s[k3] = this.s[k3] < 0.0f ? -this.s[k3] : 0.0f;
                        if (WANTV) {
                            for (int i = 0; i <= pp; ++i) {
                                this.V[i][k3] = -this.V[i][k3];
                            }
                        }
                    }
                    while (k3 < pp && !(this.s[k3] >= this.s[k3 + 1])) {
                        float t6 = this.s[k3];
                        this.s[k3] = this.s[k3 + 1];
                        this.s[k3 + 1] = t6;
                        if (WANTV && k3 < this.n - 1) {
                            for (int i = 0; i < this.n; ++i) {
                                t6 = this.V[i][k3 + 1];
                                this.V[i][k3 + 1] = this.V[i][k3];
                                this.V[i][k3] = t6;
                            }
                        }
                        if (WANTU && k3 < this.m - 1) {
                            for (int i = 0; i < this.m; ++i) {
                                t6 = this.U[i][k3 + 1];
                                this.U[i][k3 + 1] = this.U[i][k3];
                                this.U[i][k3] = t6;
                            }
                        }
                        ++k3;
                    }
                    iter = 0;
                    --p;
                }
            }
        }
    }

    private static double hypot(double a, double b) {
        if (Math.abs(a) > Math.abs(b)) {
            double r = b / a;
            return Math.abs(a) * Math.sqrt(1.0 + r * r);
        }
        if (b != 0.0) {
            double r = a / b;
            return Math.abs(b) * Math.sqrt(1.0 + r * r);
        }
        return 0.0;
    }

    public float[][] getS() {
        float[][] S = new float[this.n][this.n];
        for (int i = 0; i < this.n; ++i) {
            S[i][i] = this.s[i];
        }
        return S;
    }

    public float[][] getV() {
        if (this.V == null) {
            throw new IllegalArgumentException("Matrix V not computed.");
        }
        float[][] temp = new float[this.n][this.n];
        for (int i = 0; i < this.n; ++i) {
            System.arraycopy(this.V[i], 0, temp[i], 0, this.n);
        }
        return temp;
    }

    public float[][] getU() {
        if (this.U == null) {
            throw new IllegalArgumentException("Matrix U not computed.");
        }
        float[][] temp = new float[this.m][this.n];
        for (int i = 0; i < this.m; ++i) {
            System.arraycopy(this.U[i], 0, temp[i], 0, this.n);
        }
        return temp;
    }
}

