/*
 * Decompiled with CFR 0.152.
 */
package de.crysandt.math;

public final class Function {
    public static final double LOG2 = Math.log(2.0);
    public static final double LOG10 = Math.log(10.0);

    public static float log2(double x) {
        return (float)(Math.log(x) / LOG2);
    }

    public static float log10(double x) {
        return (float)(Math.log(x) / LOG10);
    }

    public static float square(float x) {
        return x * x;
    }

    public static double square(double x) {
        return x * x;
    }

    public static float sum(float[] data) {
        double sum = 0.0;
        for (int i = 0; i < data.length; ++i) {
            sum += (double)data[i];
        }
        return (float)sum;
    }

    public static double sum(double[] data) {
        double sum = 0.0;
        for (int i = 0; i < data.length; ++i) {
            sum += data[i];
        }
        return sum;
    }

    public static float min(float[] data) {
        float min = data[0];
        for (int i = 1; i < data.length; ++i) {
            if (!(data[i] < min)) continue;
            min = data[i];
        }
        return min;
    }

    public static int min_index(float[] data) {
        float min = data[0];
        int index = 0;
        for (int i = 1; i < data.length; ++i) {
            if (!(data[i] < min)) continue;
            index = i;
            min = data[index];
        }
        return index;
    }

    public static float max(float[] data) {
        float max = data[0];
        for (int i = 1; i < data.length; ++i) {
            if (!(data[i] > max)) continue;
            max = data[i];
        }
        return max;
    }

    public static double max(double[] data) {
        double max = data[0];
        for (int i = 1; i < data.length; ++i) {
            if (!(data[i] > max)) continue;
            max = data[i];
        }
        return max;
    }

    public static int max_index(float[] data) {
        float max = data[0];
        int index = 0;
        for (int i = 1; i < data.length; ++i) {
            if (!(data[i] > max)) continue;
            index = i;
            max = data[index];
        }
        return index;
    }

    public static short max(short[] data) {
        short max = data[0];
        for (int i = 1; i < data.length; ++i) {
            if (data[i] <= max) continue;
            max = data[i];
        }
        return max;
    }

    public static float mean_arith(float[] data) {
        return Function.sum(data) / (float)data.length;
    }

    public static double mean_arith(double[] data) {
        return Function.sum(data) / (double)data.length;
    }

    public static float mean_geom(float[] data) {
        double mean = 1.0;
        for (int i = 0; i < data.length; ++i) {
            mean *= (double)data[i];
        }
        return (float)Math.pow(mean, 1.0 / (double)data.length);
    }

    public static double mean_geom(double[] data) {
        double mean = 1.0;
        for (int i = 0; i < data.length; ++i) {
            mean *= data[i];
        }
        return Math.pow(mean, 1.0 / (double)data.length);
    }

    public static float variance(float[] data, float mean) {
        double v = 0.0;
        for (int i = 0; i < data.length; ++i) {
            v += (double)(data[i] * data[i]);
        }
        v /= (double)data.length;
        return (float)(v -= (double)(mean * mean));
    }

    public static double variance(double[] data, double mean) {
        double v = 0.0;
        for (int i = 0; i < data.length; ++i) {
            double tmp = data[i];
            v += tmp * tmp;
        }
        v /= (double)data.length;
        return v -= mean * mean;
    }

    public static float variance(float[] data) {
        return Function.variance(data, Function.mean_arith(data));
    }

    public static double variance(double[] data) {
        return Function.variance(data, Function.mean_arith(data));
    }

    public static float[] mean_arith(float[][] matrix) {
        int rows = matrix.length;
        int cols = matrix[0].length;
        double[] sum = new double[cols];
        for (int r = 0; r < rows; ++r) {
            float[] row = matrix[r];
            for (int c = 0; c < row.length; ++c) {
                int n = c;
                sum[n] = sum[n] + (double)row[c];
            }
        }
        float[] mean = new float[cols];
        for (int i = 0; i < cols; ++i) {
            mean[i] = (float)(sum[i] / (double)rows);
        }
        return mean;
    }

    public static float[] variance(float[][] matrix) {
        return Function.variance(matrix, Function.mean_arith(matrix));
    }

    public static float[] variance(float[][] matrix, float[] mean) {
        int c;
        int rows = matrix.length;
        int cols = matrix[0].length;
        double[] power = new double[cols];
        for (int r = 0; r < rows; ++r) {
            float[] row = matrix[r];
            for (c = 0; c < row.length; ++c) {
                int n = c;
                float row_c = row[c];
                power[n] = power[n] + (double)(row_c * row_c);
            }
        }
        float[] var = new float[cols];
        for (c = 0; c < var.length; ++c) {
            var[c] = (float)(power[c] / (double)rows) - mean[c] * mean[c];
        }
        return var;
    }

    public static int getHighestBit(int x) {
        int highest_bit = 0;
        for (int shift = 16; shift >= 1; shift /= 2) {
            if (x < 1 << shift) continue;
            highest_bit += shift;
            x >>= shift;
        }
        return highest_bit;
    }
}

