/*
 * Decompiled with CFR 0.152.
 */
package de.crysandt.hmm;

import de.crysandt.hmm.GaussianDistribution;
import de.crysandt.math.LinAlg;

public class GaussianDistributionFull
extends GaussianDistribution {
    private final float[] center;
    private final float[][] cov_inv;

    public GaussianDistributionFull(float[] center, float[][] cov_inv, float det) {
        super(center.length, det);
        this.center = new float[this.SIZE];
        this.cov_inv = new float[this.SIZE][this.SIZE];
        System.arraycopy(center, 0, this.center, 0, this.SIZE);
        for (int i = 0; i < this.SIZE; ++i) {
            System.arraycopy(cov_inv[i], 0, this.cov_inv[i], 0, this.SIZE);
        }
    }

    public GaussianDistributionFull(float[] center, float[][] cov_inv) {
        this(center, cov_inv, (float)LinAlg.det(cov_inv));
    }

    public double getProb(float[] x) {
        double arg = this.getLogProb(x);
        assert (!Double.isInfinite(arg));
        assert (!Double.isNaN(arg));
        double value = Math.exp(arg);
        assert (!Double.isNaN(value));
        assert (!Double.isInfinite(value));
        return value;
    }

    public double getLogProb(float[] x) {
        assert (this.SIZE == x.length);
        float[] diff = new float[this.SIZE];
        for (int i = 0; i < this.SIZE; ++i) {
            diff[i] = x[i] - this.center[i];
        }
        double sum = 0.0;
        for (int i = 0; i < this.SIZE; ++i) {
            sum += (double)(LinAlg.dot(this.cov_inv[i], diff) * diff[i]);
        }
        if (sum < 0.0) {
            sum = 0.0;
        }
        assert (!Double.isInfinite(sum));
        assert (!Double.isNaN(sum));
        return -sum / 2.0 + (double)this.scal_log;
    }

    public int getLength() {
        return this.SIZE;
    }

    public float[] getCenter() {
        float[] tmp = new float[this.SIZE];
        System.arraycopy(this.center, 0, tmp, 0, this.SIZE);
        return tmp;
    }

    public float[][] getCovarianceInverse() {
        float[][] tmp = new float[this.SIZE][this.SIZE];
        for (int i = 0; i < this.SIZE; ++i) {
            System.arraycopy(this.cov_inv[i], 0, tmp[i], 0, this.SIZE);
        }
        return tmp;
    }
}

